/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.ext;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.glassfish.admin.amx.base.ConnectorRuntimeAPIProvider;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.base.Realms;
import org.glassfish.admin.amx.base.RuntimeRoot;
import org.glassfish.admin.amx.base.SystemStatus;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.impl.config.AMXExtStartupServiceMBean;
import org.glassfish.admin.amx.impl.ext.ConnectorRuntimeAPIProviderImpl;
import org.glassfish.admin.amx.impl.ext.LoggingImpl;
import org.glassfish.admin.amx.impl.ext.RealmsImpl;
import org.glassfish.admin.amx.impl.ext.RuntimeRootImpl;
import org.glassfish.admin.amx.impl.ext.SystemStatusImpl;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.impl.util.ObjectNameBuilder;
import org.glassfish.admin.amx.logging.Logging;
import org.glassfish.admin.amx.util.FeatureAvailability;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;

@Service
public final class AMXExtStartupService
implements PostConstruct,
PreDestroy,
AMXExtStartupServiceMBean {
    @Inject
    InjectedValues mInjectedValues;
    @Inject
    private MBeanServer mMBeanServer;
    private volatile boolean mLoaded = false;

    private static void debug(String s) {
        System.out.println(s);
    }

    public void postConstruct() {
        try {
            StandardMBean mbean = new StandardMBean(this, AMXExtStartupServiceMBean.class);
            this.mMBeanServer.registerMBean(mbean, OBJECT_NAME);
        }
        catch (JMException e) {
            throw new Error(e);
        }
    }

    public void preDestroy() {
        this.unloadAMXMBeans();
    }

    public DomainRoot getDomainRootProxy() {
        return ProxyFactory.getInstance((MBeanServer)this.mMBeanServer).getDomainRootProxy(false);
    }

    public synchronized ObjectName loadAMXMBeans() {
        if (!this.mLoaded) {
            this.mLoaded = true;
            FeatureAvailability.getInstance().waitForFeature("AMXCoreReady", "AMXExtStartupService.loadAMXMBeans");
            FeatureAvailability.getInstance().waitForFeature("AMXConfigReady", "AMXExtStartupService.loadAMXMBeans");
            MBeanServer s = this.mMBeanServer;
            ObjectName domainRoot = this.getDomainRootProxy().objectName();
            ObjectName loggingObjectName = ObjectNameBuilder.buildChildObjectName((MBeanServer)s, (ObjectName)domainRoot, Logging.class);
            AMXImplBase mbean = new LoggingImpl(domainRoot, "server");
            this.registerChild(mbean, loggingObjectName);
            ObjectName runtimeObjectname = ObjectNameBuilder.buildChildObjectName((MBeanServer)s, (ObjectName)domainRoot, RuntimeRoot.class);
            mbean = new RuntimeRootImpl(domainRoot);
            this.registerChild(mbean, runtimeObjectname);
            ObjectName ext = this.getDomainRootProxy().getExt().objectName();
            ObjectNameBuilder names = new ObjectNameBuilder(s, ext);
            ObjectName child = names.buildChildObjectName(SystemStatus.class);
            mbean = new SystemStatusImpl(ext);
            this.registerChild(mbean, child);
            child = names.buildChildObjectName(Realms.class);
            mbean = new RealmsImpl(ext);
            this.registerChild(mbean, child);
            child = names.buildChildObjectName(ConnectorRuntimeAPIProvider.class);
            mbean = new ConnectorRuntimeAPIProviderImpl(ext, InjectedValues.getInstance().getHabitat());
            this.registerChild(mbean, child);
        }
        return null;
    }

    protected synchronized ObjectName registerChild(Object mbean, ObjectName childObjectName) {
        try {
            ObjectName objectName = this.mMBeanServer.registerMBean(mbean, childObjectName).getObjectName();
            return objectName;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void unloadAMXMBeans() {
    }
}

