/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsservice.JMSPacket;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jms.ra.DirectPacket;
import com.sun.messaging.jms.ra.DirectSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;

public class DirectObjectPacket
extends DirectPacket
implements ObjectMessage {
    private byte[] messageBody = null;
    private ByteArrayOutputStream byteArrayOutputStream = null;
    private ObjectOutputStream objectOutputStream = null;
    private ByteArrayInputStream byteArrayInputStream = null;
    private ObjectInputStream objectInputStream = null;
    private static final transient String _className = "com.sun.messaging.jms.ra.DirectObjectPacket";

    public DirectObjectPacket(DirectSession directSession, JMSService jMSService, Serializable serializable) throws JMSException {
        super(directSession, jMSService);
        if (_logFINE) {
            Object[] objectArray = new Object[]{directSession, jMSService, serializable};
            _loggerOC.entering(_className, "constructor()", objectArray);
        }
        if (serializable != null) {
            this.setObject(serializable);
        }
    }

    public DirectObjectPacket(JMSPacket jMSPacket, long l, DirectSession directSession, JMSService jMSService) throws JMSException {
        super(jMSPacket, l, directSession, jMSService);
        this._getMessageBodyFromPacket();
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.messageBody = null;
    }

    public Serializable getObject() throws JMSException {
        String string = "getObject()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string);
        }
        Serializable serializable = null;
        if (this.messageBody != null) {
            try {
                this.byteArrayInputStream = new ByteArrayInputStream(this.messageBody);
                this.objectInputStream = new ObjectInputStreamWithContextLoader(this.byteArrayInputStream);
                serializable = (Serializable)this.objectInputStream.readObject();
                return serializable;
            }
            catch (Exception exception) {
                Object object = null;
                String string2 = "MQJMSRA_DM4001: :Exception:ObjectMessage." + string + "DeSerializing object:" + ":message=" + exception.getMessage();
                _loggerJM.severe(string2);
                object = exception instanceof InvalidClassException || exception instanceof OptionalDataException || exception instanceof ClassNotFoundException ? new MessageFormatException(string2) : new JMSException(string2);
                object.initCause((Throwable)exception);
                throw object;
            }
        }
        return null;
    }

    public void setObject(Serializable serializable) throws JMSException {
        String string = "setObject()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string);
        }
        this.checkForReadOnlyMessageBody(string);
        try {
            this.byteArrayOutputStream = new ByteArrayOutputStream();
            this.objectOutputStream = new ObjectOutputStream(this.byteArrayOutputStream);
            this.objectOutputStream.writeObject(serializable);
            this.objectOutputStream.flush();
            this.messageBody = this.byteArrayOutputStream.toByteArray();
            this.objectOutputStream.close();
            this.byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            String string2 = "MQJMSRA_DM4001: :Exception:ObjectMessage." + string + "object=" + serializable + ":message=" + exception.getMessage();
            _loggerJM.severe(string2);
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
    }

    protected void _setDefaultValues() throws JMSException {
        super._setDefaultValues();
        this.pkt.setPacketType(5);
    }

    protected void _setBodyToPacket() throws JMSException {
        if (this.messageBody != null) {
            try {
                super._setMessageBodyOfPacket(this.messageBody);
            }
            catch (Exception exception) {
                String string = "MQJMSRA_DM4001: :ERROR setting ObjectMessage body:Exception=" + exception.getMessage();
                _loggerJM.severe(string);
                JMSException jMSException = new JMSException(string);
                jMSException.initCause((Throwable)exception);
                throw jMSException;
            }
        }
    }

    protected void _getMessageBodyFromPacket() throws JMSException {
        this.messageBody = super._getMessageBodyByteArray();
    }

    static class ObjectInputStreamWithContextLoader
    extends ObjectInputStream {
        public ObjectInputStreamWithContextLoader(InputStream inputStream) throws IOException, StreamCorruptedException {
            super(inputStream);
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            try {
                return super.resolveClass(objectStreamClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassLoader classLoader = null;
                try {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    throw new ClassNotFoundException(classNotFoundException.getMessage() + "; " + securityException.getMessage());
                }
                if (classLoader == null) {
                    throw classNotFoundException;
                }
                return Class.forName(objectStreamClass.getName(), false, classLoader);
            }
        }
    }
}

