/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.protocol.http;

import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MQAddress;
import com.sun.messaging.jmq.jmsclient.protocol.SocketConnectionHandler;
import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jms.JMSException;

public class HTTPConnectionHandler
extends SocketConnectionHandler {
    private HttpTunnelSocket socket = null;
    private String URLString = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPConnectionHandler(Object object) throws JMSException {
        ConnectionImpl connectionImpl = (ConnectionImpl)object;
        this.URLString = connectionImpl.getProperty("imqConnectionURL");
        if (this.URLString == null) {
            throw new JMSException("imqConnectionURL property not found.");
        }
        try {
            this.socket = new HttpTunnelSocket(this.URLString);
        }
        catch (Exception exception) {
            connectionImpl.getExceptionHandler();
            ExceptionHandler.handleConnectException(exception, this.URLString);
        }
        finally {
            connectionImpl.setLastContactedBrokerAddress(this.URLString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPConnectionHandler(MQAddress mQAddress, ConnectionImpl connectionImpl) throws JMSException {
        ConnectionImpl connectionImpl2 = connectionImpl;
        this.URLString = mQAddress.getURL();
        if (this.URLString == null) {
            throw new JMSException("URL not found.");
        }
        try {
            this.socket = new HttpTunnelSocket(this.URLString);
        }
        catch (Exception exception) {
            connectionImpl2.getExceptionHandler();
            ExceptionHandler.handleConnectException(exception, this.URLString);
        }
        finally {
            connectionImpl.setLastContactedBrokerAddress(this.URLString);
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    public int getLocalPort() throws IOException {
        return this.socket.getConnId();
    }

    protected void closeSocket() throws IOException {
        this.socket.close();
    }

    public String getBrokerHostName() {
        return this.URLString;
    }

    public String getBrokerAddress() {
        return this.URLString;
    }
}

