/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.protocol.direct;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsclient.ConnectionHandler;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.MQAddress;
import com.sun.messaging.jmq.jmsclient.PacketDispatcher;
import com.sun.messaging.jmq.jmsclient.runtime.ClientRuntime;
import com.sun.messaging.jmq.jmsclient.runtime.impl.ClientRuntimeImpl;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQDualThreadConnection;
import com.sun.messaging.jmq.jmsservice.DirectBrokerConnection;
import com.sun.messaging.jmq.jmsservice.HandOffQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.jms.JMSException;

public class DirectConnectionHandler
implements ConnectionHandler {
    private HandOffQueue inBoundQ = null;
    private HandOffQueue outBoundQ = null;
    private DirectBrokerConnection directConnection = null;
    private ConnectionImpl connection = null;
    private volatile boolean isClosed = false;
    private static boolean directDebug = Boolean.getBoolean("imq.direct.debug");

    public boolean isDirectMode() {
        return true;
    }

    public DirectConnectionHandler(Object object) throws JMSException {
        this.connection = (ConnectionImpl)object;
        this.init();
        if (directDebug) {
            ConnectionImpl.getConnectionLogger().info("Direct connection handler created...");
        }
    }

    public DirectConnectionHandler(MQAddress mQAddress, ConnectionImpl connectionImpl) throws JMSException {
        this.connection = connectionImpl;
        this.init();
        if (directDebug) {
            ConnectionImpl.getConnectionLogger().info("Direct connection handler created...");
        }
    }

    private void init() throws JMSException {
        try {
            boolean bl = ClientRuntime.getRuntime().isEmbeddedBrokerRunning();
            if (!bl) {
                throw new RuntimeException("Direct broker not initialized for this client runtime.");
            }
            ClientRuntimeImpl clientRuntimeImpl = (ClientRuntimeImpl)ClientRuntime.getRuntime();
            this.directConnection = clientRuntimeImpl.createDirectConnection();
            this.inBoundQ = this.directConnection.getBrokerToClientQueue();
            this.outBoundQ = this.directConnection.getClientToBrokerQueue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JMSException jMSException = new JMSException(exception.getMessage());
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
    }

    public void setReplyDispatcher(PacketDispatcher packetDispatcher) {
        ((IMQDualThreadConnection)this.directConnection).setReplyDispatcher(packetDispatcher);
    }

    public void writePacket(ReadWritePacket readWritePacket) throws IOException {
        try {
            if (this.isClosed) {
                throw new IOException("Connection is closed.");
            }
            readWritePacket.updateSequenceNumber();
            readWritePacket.updateTimestamp();
            readWritePacket.updateBuffers();
            ReadWritePacket readWritePacket2 = (ReadWritePacket)readWritePacket.clone();
            this.outBoundQ.put(readWritePacket2);
            if (directDebug) {
                System.out.println("Direct connection wrote pkt..." + readWritePacket2);
                System.out.flush();
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getMessage());
            throw iOException;
        }
    }

    public ReadWritePacket readPacket() throws IOException {
        ReadWritePacket readWritePacket = null;
        try {
            if (!this.isClosed) {
                readWritePacket = (ReadWritePacket)this.inBoundQ.take();
            }
            if (directDebug) {
                System.out.println("Direct connection read pkt..." + readWritePacket);
                System.out.flush();
            }
            if (this.isClosed) {
                throw new IOException("Connection is closed.");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return readWritePacket;
    }

    public synchronized void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(0);
        this.isClosed = true;
        try {
            this.inBoundQ.put(readWritePacket);
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getMessage());
            throw iOException;
        }
    }

    public String getBrokerAddress() {
        return "localhost";
    }

    public String getBrokerHostName() {
        return "localhost";
    }

    public InputStream getInputStream() throws IOException {
        return null;
    }

    public int getLocalPort() throws IOException {
        return 0;
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    public Packet fetchReply() {
        return ((IMQDualThreadConnection)this.directConnection).fetchReply();
    }

    public void configure(Properties properties) throws IOException {
    }
}

