/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstClass;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUtf8;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

public class ExceptionsAttribute
extends ClassAttribute {
    public static final String expectedAttrName = "Exceptions";
    private Vector exceptionTable;

    public Enumeration exceptions() {
        return this.exceptionTable.elements();
    }

    public ExceptionsAttribute(ConstUtf8 attrName, Vector excTable) {
        super(attrName);
        this.exceptionTable = excTable;
    }

    public ExceptionsAttribute(ConstUtf8 attrName, ConstClass exc) {
        super(attrName);
        this.exceptionTable = new Vector(1);
        this.exceptionTable.addElement(exc);
    }

    static ExceptionsAttribute read(ConstUtf8 attrName, DataInputStream data, ConstantPool pool) throws IOException {
        int nExcepts = data.readUnsignedShort();
        Vector<ConstClass> excTable = new Vector<ConstClass>();
        while (nExcepts-- > 0) {
            int excIndex = data.readUnsignedShort();
            ConstClass exc_class = null;
            if (excIndex != 0) {
                exc_class = (ConstClass)pool.constantAt(excIndex);
            }
            excTable.addElement(exc_class);
        }
        return new ExceptionsAttribute(attrName, excTable);
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.attrName().getIndex());
        out.writeInt(2 + 2 * this.exceptionTable.size());
        out.writeShort(this.exceptionTable.size());
        for (int i = 0; i < this.exceptionTable.size(); ++i) {
            out.writeShort(((ConstClass)this.exceptionTable.elementAt(i)).getIndex());
        }
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.print("Exceptions:");
        for (int i = 0; i < this.exceptionTable.size(); ++i) {
            out.print(" " + ((ConstClass)this.exceptionTable.elementAt(i)).asString());
        }
        out.println();
    }
}

