/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.apache.tomcat.util.modeler.AttributeInfo;
import org.apache.tomcat.util.modeler.ConstructorInfo;
import org.apache.tomcat.util.modeler.FieldInfo;
import org.apache.tomcat.util.modeler.NotificationInfo;
import org.apache.tomcat.util.modeler.OperationInfo;

public class ManagedBean
implements Serializable {
    transient ModelMBeanInfo info = null;
    protected AttributeInfo[] attributes = new AttributeInfo[0];
    protected String className = "org.apache.tomcat.util.modeler.BaseModelMBean";
    protected ConstructorInfo[] constructors = new ConstructorInfo[0];
    protected String description = null;
    protected String domain = null;
    protected String group = null;
    protected String name = null;
    protected List fields = new ArrayList();
    protected NotificationInfo[] notifications = new NotificationInfo[0];
    protected OperationInfo[] operations = new OperationInfo[0];
    protected String type = null;

    public ManagedBean() {
        AttributeInfo ai = new AttributeInfo();
        ai.setName("modelerType");
        ai.setDescription("Type of the modeled resource. Can be set only once");
        ai.setType("java.lang.String");
        this.addAttribute(ai);
    }

    public AttributeInfo[] getAttributes() {
        return this.attributes;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
        this.info = null;
    }

    public ConstructorInfo[] getConstructors() {
        return this.constructors;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.info = null;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public List getFields() {
        return this.fields;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.info = null;
    }

    public NotificationInfo[] getNotifications() {
        return this.notifications;
    }

    public OperationInfo[] getOperations() {
        return this.operations;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.info = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttribute(AttributeInfo attribute) {
        AttributeInfo[] attributeInfoArray = this.attributes;
        synchronized (this.attributes) {
            AttributeInfo[] results = new AttributeInfo[this.attributes.length + 1];
            System.arraycopy(this.attributes, 0, results, 0, this.attributes.length);
            results[this.attributes.length] = attribute;
            this.attributes = results;
            this.info = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConstructor(ConstructorInfo constructor) {
        ConstructorInfo[] constructorInfoArray = this.constructors;
        synchronized (this.constructors) {
            ConstructorInfo[] results = new ConstructorInfo[this.constructors.length + 1];
            System.arraycopy(this.constructors, 0, results, 0, this.constructors.length);
            results[this.constructors.length] = constructor;
            this.constructors = results;
            this.info = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void addField(FieldInfo field) {
        this.fields.add(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotification(NotificationInfo notification) {
        NotificationInfo[] notificationInfoArray = this.notifications;
        synchronized (this.notifications) {
            NotificationInfo[] results = new NotificationInfo[this.notifications.length + 1];
            System.arraycopy(this.notifications, 0, results, 0, this.notifications.length);
            results[this.notifications.length] = notification;
            this.notifications = results;
            this.info = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOperation(OperationInfo operation) {
        OperationInfo[] operationInfoArray = this.operations;
        synchronized (this.operations) {
            OperationInfo[] results = new OperationInfo[this.operations.length + 1];
            System.arraycopy(this.operations, 0, results, 0, this.operations.length);
            results[this.operations.length] = operation;
            this.operations = results;
            this.info = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public ModelMBean createMBean() throws InstanceNotFoundException, InvalidTargetObjectTypeException, MBeanException, RuntimeOperationsException {
        return this.createMBean(null);
    }

    public ModelMBean createMBean(Object instance) throws InstanceNotFoundException, InvalidTargetObjectTypeException, MBeanException, RuntimeOperationsException {
        Class<?> clazz = null;
        Exception ex = null;
        try {
            clazz = Class.forName(this.getClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl != null) {
                    clazz = cl.loadClass(this.getClassName());
                }
            }
            catch (Exception e) {
                ex = e;
            }
        }
        if (clazz == null) {
            throw new MBeanException(ex, "Cannot load ModelMBean class " + this.getClassName());
        }
        ModelMBean mbean = null;
        try {
            mbean = (ModelMBean)clazz.newInstance();
            mbean.setModelMBeanInfo(this.createMBeanInfo());
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (RuntimeOperationsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MBeanException(e, "Cannot instantiate ModelMBean of class " + this.getClassName());
        }
        try {
            if (instance != null) {
                mbean.setManagedResource(instance, "objectReference");
            }
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (InvalidTargetObjectTypeException e) {
            throw e;
        }
        return mbean;
    }

    public ModelMBeanInfo createMBeanInfo() {
        if (this.info != null) {
            return this.info;
        }
        AttributeInfo[] attrs = this.getAttributes();
        ModelMBeanAttributeInfo[] attributes = new ModelMBeanAttributeInfo[attrs.length];
        for (int i = 0; i < attrs.length; ++i) {
            attributes[i] = attrs[i].createAttributeInfo();
        }
        ConstructorInfo[] consts = this.getConstructors();
        ModelMBeanConstructorInfo[] constructors = new ModelMBeanConstructorInfo[consts.length];
        for (int i = 0; i < consts.length; ++i) {
            constructors[i] = consts[i].createConstructorInfo();
        }
        NotificationInfo[] notifs = this.getNotifications();
        ModelMBeanNotificationInfo[] notifications = new ModelMBeanNotificationInfo[notifs.length];
        for (int i = 0; i < notifs.length; ++i) {
            notifications[i] = notifs[i].createNotificationInfo();
        }
        OperationInfo[] opers = this.getOperations();
        ModelMBeanOperationInfo[] operations = new ModelMBeanOperationInfo[opers.length];
        for (int i = 0; i < opers.length; ++i) {
            operations[i] = opers[i].createOperationInfo();
        }
        this.info = new ModelMBeanInfoSupport(this.getClassName(), this.getDescription(), attributes, constructors, operations, notifications);
        try {
            Descriptor descriptor = this.info.getMBeanDescriptor();
            for (FieldInfo field : this.getFields()) {
                descriptor.setField(field.getName(), field.getValue());
            }
            this.info.setMBeanDescriptor(descriptor);
        }
        catch (MBeanException e) {
            // empty catch block
        }
        return this.info;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ManagedBean[");
        sb.append("name=");
        sb.append(this.name);
        sb.append(", className=");
        sb.append(this.className);
        sb.append(", description=");
        sb.append(this.description);
        if (this.group != null) {
            sb.append(", group=");
            sb.append(this.group);
        }
        sb.append(", type=");
        sb.append(this.type);
        sb.append("]");
        return sb.toString();
    }
}

