/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.stats;

import com.sun.enterprise.admin.monitor.stats.StatisticImpl;
import com.sun.enterprise.util.i18n.StringManager;
import org.glassfish.j2ee.statistics.BoundedRangeStatistic;

public final class BoundedRangeStatisticImpl
extends StatisticImpl
implements BoundedRangeStatistic {
    private final long currentVal;
    private final long highWaterMark;
    private final long lowWaterMark;
    private final long upperBound;
    private final long lowerBound;
    private static final StringManager localStrMgr = StringManager.getManager(BoundedRangeStatisticImpl.class);
    public static final long DEFAULT_MAX_BOUND = Long.MAX_VALUE;
    public static final long DEFAULT_MIN_BOUND = DEFAULT_VALUE;

    public String toString() {
        return super.toString() + NEWLINE + "Current: " + this.getCurrent() + NEWLINE + "LowWaterMark: " + this.getLowWaterMark() + NEWLINE + "HighWaterMark: " + this.getHighWaterMark() + NEWLINE + "LowerBound: " + this.getLowerBound() + NEWLINE + "UpperBound: " + this.getUpperBound();
    }

    public BoundedRangeStatisticImpl(String name) {
        this(name, DEFAULT_UNIT);
    }

    public BoundedRangeStatisticImpl(String name, String unit) {
        this(name, unit, DEFAULT_VALUE);
    }

    public BoundedRangeStatisticImpl(String name, String unit, String desc, long value, long max, long min) {
        this(value, value, value, max, min, name, unit, desc, Util.getInitTime()[0], Util.getInitTime()[1]);
    }

    public BoundedRangeStatisticImpl(String name, String unit, long value) {
        this(name, unit, value, Long.MAX_VALUE, DEFAULT_MIN_BOUND);
    }

    public BoundedRangeStatisticImpl(String name, String unit, long value, long max, long min) {
        this(name, unit, value, max, min, value, value);
    }

    public BoundedRangeStatisticImpl(String name, String unit, long value, long max, long min, long highMark, long lowMark) {
        this(value, highMark, lowMark, max, min, name, unit, Util.getDescriptionFromName(name), Util.getInitTime()[0], Util.getInitTime()[1]);
    }

    public BoundedRangeStatisticImpl(long curVal, long highMark, long lowMark, long upper, long lower, String name, String unit, String desc, long startTime, long sampleTime) {
        super(name, unit, desc, startTime, sampleTime);
        this.currentVal = curVal;
        this.highWaterMark = highMark;
        this.lowWaterMark = lowMark;
        this.upperBound = upper;
        this.lowerBound = lower;
    }

    public long getCurrent() {
        return this.currentVal;
    }

    public long getHighWaterMark() {
        return this.highWaterMark;
    }

    public long getLowWaterMark() {
        return this.lowWaterMark;
    }

    public long getLowerBound() {
        return this.lowerBound;
    }

    public long getUpperBound() {
        return this.upperBound;
    }

    private static class Util {
        private Util() {
        }

        private static String getDescriptionFromName(String name) {
            return localStrMgr.getString("describes_string") + name;
        }

        private static long[] getInitTime() {
            long time = System.currentTimeMillis();
            return new long[]{time, time};
        }
    }
}

