/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="create-javamail-resource")
@Scoped(value=PerLookup.class)
@I18n(value="create.javamail.resource")
public class CreateJavaMailResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJavaMailResource.class);
    @Param(name="mailhost")
    String mailHost;
    @Param(name="mailuser")
    String mailUser;
    @Param(name="fromaddress")
    String fromAddress;
    @Param(name="jndi_name", primary=true)
    String jndiName;
    @Param(name="storeprotocol", optional=true, defaultValue="imap")
    String storeProtocol;
    @Param(name="storeprotocolclass", optional=true, defaultValue="com.sun.mail.imap.IMAPStore")
    String storeProtocolClass;
    @Param(name="transprotocol", optional=true, defaultValue="smtp")
    String transportProtocol;
    @Param(name="transprotocolclass", optional=true, defaultValue="com.sun.mail.smtp.SMTPTransport")
    String transportProtocolClass;
    @Param(optional=true, defaultValue="true")
    Boolean enabled;
    @Param(optional=true, defaultValue="false")
    Boolean debug;
    @Param(name="property", optional=true, separator=58)
    Properties properties;
    @Param(optional=true, defaultValue="server")
    String target;
    @Param(optional=true)
    String description;
    @Inject
    Resources resources;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        if (this.mailHost == null) {
            report.setMessage(localStrings.getLocalString("create.mail.resource.noHostName", "No host name defined for Mail Resource."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.mailUser == null) {
            report.setMessage(localStrings.getLocalString("create.mail.resource.noUserName", "No user name defined for Mail Resource."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.fromAddress == null) {
            report.setMessage(localStrings.getLocalString("create.mail.resource.noFrom", "From not defined for Mail Resource."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        for (Resource resource : this.resources.getResources()) {
            if (!(resource instanceof BindableResource) || !((BindableResource)resource).getJndiName().equals(this.jndiName)) continue;
            report.setMessage(localStrings.getLocalString("create.mail.resource.duplicate.1", "Resource named {0} already exists.", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<Resources>(){

                @Override
                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    MailResource newResource = (MailResource)param.createChild(MailResource.class);
                    newResource.setJndiName(CreateJavaMailResource.this.jndiName);
                    newResource.setFrom(CreateJavaMailResource.this.fromAddress);
                    newResource.setUser(CreateJavaMailResource.this.mailUser);
                    newResource.setHost(CreateJavaMailResource.this.mailHost);
                    newResource.setEnabled(CreateJavaMailResource.this.enabled.toString());
                    newResource.setStoreProtocol(CreateJavaMailResource.this.storeProtocol);
                    newResource.setStoreProtocolClass(CreateJavaMailResource.this.storeProtocolClass);
                    newResource.setTransportProtocol(CreateJavaMailResource.this.transportProtocol);
                    newResource.setTransportProtocolClass(CreateJavaMailResource.this.transportProtocolClass);
                    newResource.setDebug(CreateJavaMailResource.this.debug.toString());
                    if (CreateJavaMailResource.this.description != null) {
                        newResource.setDescription(CreateJavaMailResource.this.description);
                    }
                    if (CreateJavaMailResource.this.properties != null) {
                        for (Map.Entry<Object, Object> e : CreateJavaMailResource.this.properties.entrySet()) {
                            Property prop = (Property)newResource.createChild(Property.class);
                            prop.setName((String)e.getKey());
                            prop.setValue((String)e.getValue());
                            newResource.getProperty().add(prop);
                        }
                    }
                    param.getResources().add(newResource);
                    return newResource;
                }
            }, this.resources);
            if (!targetServer.isResourceRefExists(this.jndiName)) {
                targetServer.createResourceRef(this.enabled.toString(), this.jndiName);
            }
            report.setMessage(localStrings.getLocalString("create.mail.resource.success", "Mail Resource {0} created.", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("create.mail.resource.fail", "Unable to create Mail Resource {0}.", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
    }
}

