/*
 * G-ToDo Gkrellm Plugin
 * Copyright 2003-2004 Dimitar Haralanov
 *
 */
/* This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __SUPPORT_H
#define __SUPPORT_H

#include <main.h>

/*
 * Time Structure
 * It holds the time broken down into easy to use
 * structure members
 */
typedef struct {
     int month;
     int day;
     int year;
     int hour;
     int min;
     int sec;
     int ampm;
} gtodo_time_struct_t;

/* enumerate the possible sorting types */
enum {
     SORT_ID_TASK = 0,
     SORT_ID_COMPLETE,
     SORT_ID_DEADLINE,
     SORT_ID_TIME
};

/* Set the members of the time struct to the time
 * specified by the time_t arguement
 */
void   gtodo_get_date_from_time     (time_t, gtodo_time_struct_t *);

/* Return the time (in seconds since the Epoch) specified
 * by the time structure
 */
time_t gtodo_get_time_from_date     (gtodo_time_struct_t);

/* Return the time (in seconds since the Epoch) specified
 * by the string. The string should be in the format
 * mm/dd/yyyy hh:mm:ss
 */
time_t gtodo_get_time_from_date_str (gchar *);

/* Set the string (in mm/dd/yyyy hh:mm:ss format) to the
 * time specified by the time_t arguement. Returns the
 * pointer to the string
 */
gchar *gtodo_get_date_from_time_str (time_t, gchar *);

/* Compare the cell two cell values pointed to by the two
 * iterators and the gpointer. This function is used by
 * the TreeView sorting */
gint   gtodo_list_store_sort        (GtkTreeModel *, GtkTreeIter *, GtkTreeIter *, gpointer);

/*
 * The following functions are used as custom formatting for the
 * column renderers in the various GtkTreeViews
 */
void   display_date_column          (GtkTreeViewColumn *, GtkCellRenderer *,
				     GtkTreeModel *, GtkTreeIter *, gpointer);
void   display_comment_column       (GtkTreeViewColumn *, GtkCellRenderer *,
				     GtkTreeModel *, GtkTreeIter *, gpointer);
void   display_time_column          (GtkTreeViewColumn *, GtkCellRenderer *,
				     GtkTreeModel *, GtkTreeIter *, gpointer);
void   display_complete_column      (GtkTreeViewColumn *, GtkCellRenderer *,
				     GtkTreeModel *, GtkTreeIter *, gpointer);

/* A popup window displaying an alert. The function uses the same
 * style of arguments as the printf function
 */
void   alert                        (GtkWidget *, const char *, ...) __attribute__ ((format (printf, 2, 3)));
#endif /* support.h */
