/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpproceduraldb_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpproceduraldb
 * @title: gimpproceduraldb
 * @short_description: Functions for querying and changing procedural database (PDB) entries.
 *
 * Functions for querying and changing procedural database (PDB)
 * entries.
 **/


/**
 * gimp_procedural_db_temp_name:
 *
 * Generates a unique temporary PDB name.
 *
 * This procedure generates a temporary PDB entry name that is
 * guaranteed to be unique.
 *
 * Returns: (transfer full): A unique temporary name for a temporary
 * PDB entry.
 **/
gchar *
gimp_procedural_db_temp_name (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *temp_name = NULL;

  args = gimp_value_array_new_from_types (G_TYPE_NONE);

  return_vals = gimp_run_procedure_with_array ("gimp-procedural-db-temp-name",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    temp_name = g_value_dup_string (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return temp_name;
}

/**
 * gimp_procedural_db_dump:
 * @filename: The dump filename.
 *
 * Dumps the current contents of the procedural database
 *
 * This procedure dumps the contents of the procedural database to the
 * specified file. The file will contain all of the information
 * provided for each registered procedure.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_procedural_db_dump (const gchar *filename)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), filename);

  return_vals = gimp_run_procedure_with_array ("gimp-procedural-db-dump",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_procedural_db_query:
 * @name: The regex for procedure name.
 * @blurb: The regex for procedure blurb.
 * @help: The regex for procedure help.
 * @author: The regex for procedure author.
 * @copyright: The regex for procedure copyright.
 * @date: The regex for procedure date.
 * @proc_type: The regex for procedure type: { 'Internal GIMP procedure', 'GIMP Plug-in', 'GIMP Extension', 'Temporary Procedure' }.
 * @num_matches: (out): The number of matching procedures.
 * @procedure_names: (out) (array length=num_matches) (element-type gchar*) (transfer full): The list of procedure names.
 *
 * Queries the procedural database for its contents using regular
 * expression matching.
 *
 * This procedure queries the contents of the procedural database. It
 * is supplied with seven arguments matching procedures on { name,
 * blurb, help, author, copyright, date, procedure type}. This is
 * accomplished using regular expression matching. For instance, to
 * find all procedures with \"jpeg\" listed in the blurb, all seven
 * arguments can be supplied as \".*\", except for the second, which
 * can be supplied as \".*jpeg.*\". There are two return arguments for
 * this procedure. The first is the number of procedures matching the
 * query. The second is a concatenated list of procedure names
 * corresponding to those matching the query. If no matching entries
 * are found, then the returned string is NULL and the number of
 * entries is 0.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_procedural_db_query (const gchar   *name,
                          const gchar   *blurb,
                          const gchar   *help,
                          const gchar   *author,
                          const gchar   *copyright,
                          const gchar   *date,
                          const gchar   *proc_type,
                          gint          *num_matches,
                          gchar       ***procedure_names)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_STRING,
                                          G_TYPE_STRING,
                                          G_TYPE_STRING,
                                          G_TYPE_STRING,
                                          G_TYPE_STRING,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_string (gimp_value_array_index (args, 1), blurb);
  g_value_set_string (gimp_value_array_index (args, 2), help);
  g_value_set_string (gimp_value_array_index (args, 3), author);
  g_value_set_string (gimp_value_array_index (args, 4), copyright);
  g_value_set_string (gimp_value_array_index (args, 5), date);
  g_value_set_string (gimp_value_array_index (args, 6), proc_type);

  return_vals = gimp_run_procedure_with_array ("gimp-procedural-db-query",
                                               args);
  gimp_value_array_unref (args);

  *num_matches = 0;
  *procedure_names = NULL;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *num_matches = g_value_get_int (gimp_value_array_index (return_vals, 1));
      *procedure_names = gimp_value_dup_string_array (gimp_value_array_index (return_vals, 2));
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_procedural_db_proc_exists:
 * @procedure_name: The procedure name.
 *
 * Checks if the specified procedure exists in the procedural database
 *
 * This procedure checks if the specified procedure is registered in
 * the procedural database.
 *
 * Returns: Whether a procedure of that name is registered.
 *
 * Since: 2.6
 **/
gboolean
gimp_procedural_db_proc_exists (const gchar *procedure_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean exists = FALSE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), procedure_name);

  return_vals = gimp_run_procedure_with_array ("gimp-procedural-db-proc-exists",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    exists = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return exists;
}

/**
 * _gimp_procedural_db_proc_info:
 * @procedure_name: The procedure name.
 * @blurb: (out) (transfer full): A short blurb.
 * @help: (out) (transfer full): Detailed procedure help.
 * @author: (out) (transfer full): Author(s) of the procedure.
 * @copyright: (out) (transfer full): The copyright.
 * @date: (out) (transfer full): Copyright date.
 * @proc_type: (out): The procedure type.
 * @num_args: (out): The number of input arguments.
 * @num_values: (out): The number of return values.
 *
 * Queries the procedural database for information on the specified
 * procedure.
 *
 * This procedure returns information on the specified procedure. A
 * short blurb, detailed help, author(s), copyright information,
 * procedure type, number of input, and number of return values are
 * returned. For specific information on each input argument and return
 * value, use the gimp_procedural_db_proc_arg() and
 * gimp_procedural_db_proc_val() procedures.
 *
 * Returns: TRUE on success.
 **/
gboolean
_gimp_procedural_db_proc_info (const gchar      *procedure_name,
                               gchar           **blurb,
                               gchar           **help,
                               gchar           **author,
                               gchar           **copyright,
                               gchar           **date,
                               GimpPDBProcType  *proc_type,
                               gint             *num_args,
                               gint             *num_values)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), procedure_name);

  return_vals = gimp_run_procedure_with_array ("gimp-procedural-db-proc-info",
                                               args);
  gimp_value_array_unref (args);

  *blurb = NULL;
  *help = NULL;
  *author = NULL;
  *copyright = NULL;
  *date = NULL;
  *proc_type = 0;
  *num_args = 0;
  *num_values = 0;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *blurb = g_value_dup_string (gimp_value_array_index (return_vals, 1));
      *help = g_value_dup_string (gimp_value_array_index (return_vals, 2));
      *author = g_value_dup_string (gimp_value_array_index (return_vals, 3));
      *copyright = g_value_dup_string (gimp_value_array_index (return_vals, 4));
      *date = g_value_dup_string (gimp_value_array_index (return_vals, 5));
      *proc_type = g_value_get_enum (gimp_value_array_index (return_vals, 6));
      *num_args = g_value_get_int (gimp_value_array_index (return_vals, 7));
      *num_values = g_value_get_int (gimp_value_array_index (return_vals, 8));
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_procedural_db_proc_arg:
 * @procedure_name: The procedure name.
 * @arg_num: The argument number.
 * @arg_type: (out): The type of argument.
 * @arg_name: (out) (transfer full): The name of the argument.
 * @arg_desc: (out) (transfer full): A description of the argument.
 *
 * Queries the procedural database for information on the specified
 * procedure's argument.
 *
 * This procedure returns information on the specified procedure's
 * argument. The argument type, name, and a description are retrieved.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_procedural_db_proc_arg (const gchar     *procedure_name,
                             gint             arg_num,
                             GimpPDBArgType  *arg_type,
                             gchar          **arg_name,
                             gchar          **arg_desc)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), procedure_name);
  g_value_set_int (gimp_value_array_index (args, 1), arg_num);

  return_vals = gimp_run_procedure_with_array ("gimp-procedural-db-proc-arg",
                                               args);
  gimp_value_array_unref (args);

  *arg_type = 0;
  *arg_name = NULL;
  *arg_desc = NULL;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *arg_type = g_value_get_enum (gimp_value_array_index (return_vals, 1));
      *arg_name = g_value_dup_string (gimp_value_array_index (return_vals, 2));
      *arg_desc = g_value_dup_string (gimp_value_array_index (return_vals, 3));
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_procedural_db_proc_val:
 * @procedure_name: The procedure name.
 * @val_num: The return value number.
 * @val_type: (out): The type of return value.
 * @val_name: (out) (transfer full): The name of the return value.
 * @val_desc: (out) (transfer full): A description of the return value.
 *
 * Queries the procedural database for information on the specified
 * procedure's return value.
 *
 * This procedure returns information on the specified procedure's
 * return value. The return value type, name, and a description are
 * retrieved.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_procedural_db_proc_val (const gchar     *procedure_name,
                             gint             val_num,
                             GimpPDBArgType  *val_type,
                             gchar          **val_name,
                             gchar          **val_desc)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), procedure_name);
  g_value_set_int (gimp_value_array_index (args, 1), val_num);

  return_vals = gimp_run_procedure_with_array ("gimp-procedural-db-proc-val",
                                               args);
  gimp_value_array_unref (args);

  *val_type = 0;
  *val_name = NULL;
  *val_desc = NULL;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *val_type = g_value_get_enum (gimp_value_array_index (return_vals, 1));
      *val_name = g_value_dup_string (gimp_value_array_index (return_vals, 2));
      *val_desc = g_value_dup_string (gimp_value_array_index (return_vals, 3));
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_procedural_db_get_data:
 * @identifier: The identifier associated with data.
 * @bytes: (out): The number of bytes in the data.
 * @data: (out) (array length=bytes) (element-type guint8) (transfer full): A byte array containing data.
 *
 * Returns data associated with the specified identifier.
 *
 * This procedure returns any data which may have been associated with
 * the specified identifier. The data is a variable length array of
 * bytes. If no data has been associated with the identifier, an error
 * is returned.
 *
 * Returns: TRUE on success.
 **/
gboolean
_gimp_procedural_db_get_data (const gchar  *identifier,
                              gint         *bytes,
                              guint8      **data)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), identifier);

  return_vals = gimp_run_procedure_with_array ("gimp-procedural-db-get-data",
                                               args);
  gimp_value_array_unref (args);

  *bytes = 0;
  *data = NULL;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *bytes = g_value_get_int (gimp_value_array_index (return_vals, 1));
      *data = gimp_value_dup_int8_array (gimp_value_array_index (return_vals, 2));
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_procedural_db_get_data_size:
 * @identifier: The identifier associated with data.
 *
 * Returns size of data associated with the specified identifier.
 *
 * This procedure returns the size of any data which may have been
 * associated with the specified identifier. If no data has been
 * associated with the identifier, an error is returned.
 *
 * Returns: The number of bytes in the data.
 **/
gint
gimp_procedural_db_get_data_size (const gchar *identifier)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint bytes = 0;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), identifier);

  return_vals = gimp_run_procedure_with_array ("gimp-procedural-db-get-data-size",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    bytes = g_value_get_int (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return bytes;
}

/**
 * _gimp_procedural_db_set_data:
 * @identifier: The identifier associated with data.
 * @bytes: The number of bytes in the data.
 * @data: (array length=bytes) (element-type guint8): A byte array containing data.
 *
 * Associates the specified identifier with the supplied data.
 *
 * This procedure associates the supplied data with the provided
 * identifier. The data may be subsequently retrieved by a call to
 * 'procedural-db-get-data'.
 *
 * Returns: TRUE on success.
 **/
gboolean
_gimp_procedural_db_set_data (const gchar  *identifier,
                              gint          bytes,
                              const guint8 *data)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT8_ARRAY,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), identifier);
  g_value_set_int (gimp_value_array_index (args, 1), bytes);
  gimp_value_set_int8_array (gimp_value_array_index (args, 2), data, bytes);

  return_vals = gimp_run_procedure_with_array ("gimp-procedural-db-set-data",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
