/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimppalette_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimppalette
 * @title: gimppalette
 * @short_description: Functions operating on a single palette.
 *
 * Functions operating on a single palette.
 **/


/**
 * gimp_palette_new:
 * @name: The requested name of the new palette.
 *
 * Creates a new palette
 *
 * This procedure creates a new, uninitialized palette
 *
 * Returns: (transfer full): The actual new palette name.
 *
 * Since: 2.2
 **/
gchar *
gimp_palette_new (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *actual_name = NULL;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);

  return_vals = gimp_run_procedure_with_array ("gimp-palette-new",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    actual_name = g_value_dup_string (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return actual_name;
}

/**
 * gimp_palette_duplicate:
 * @name: The palette name.
 *
 * Duplicates a palette
 *
 * This procedure creates an identical palette by a different name
 *
 * Returns: (transfer full): The name of the palette's copy.
 *
 * Since: 2.2
 **/
gchar *
gimp_palette_duplicate (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *copy_name = NULL;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);

  return_vals = gimp_run_procedure_with_array ("gimp-palette-duplicate",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    copy_name = g_value_dup_string (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return copy_name;
}

/**
 * gimp_palette_rename:
 * @name: The palette name.
 * @new_name: The new name of the palette.
 *
 * Rename a palette
 *
 * This procedure renames a palette
 *
 * Returns: (transfer full): The actual new name of the palette.
 *
 * Since: 2.2
 **/
gchar *
gimp_palette_rename (const gchar *name,
                     const gchar *new_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *actual_name = NULL;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_string (gimp_value_array_index (args, 1), new_name);

  return_vals = gimp_run_procedure_with_array ("gimp-palette-rename",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    actual_name = g_value_dup_string (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return actual_name;
}

/**
 * gimp_palette_delete:
 * @name: The palette name.
 *
 * Deletes a palette
 *
 * This procedure deletes a palette
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_palette_delete (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);

  return_vals = gimp_run_procedure_with_array ("gimp-palette-delete",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_palette_is_editable:
 * @name: The palette name.
 *
 * Tests if palette can be edited
 *
 * Returns TRUE if you have permission to change the palette
 *
 * Returns: TRUE if the palette can be edited.
 *
 * Since: 2.4
 **/
gboolean
gimp_palette_is_editable (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean editable = FALSE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);

  return_vals = gimp_run_procedure_with_array ("gimp-palette-is-editable",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    editable = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return editable;
}

/**
 * gimp_palette_get_info:
 * @name: The palette name.
 * @num_colors: (out): The number of colors in the palette.
 *
 * Retrieve information about the specified palette.
 *
 * This procedure retrieves information about the specified palette.
 * This includes the name, and the number of colors.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_palette_get_info (const gchar *name,
                       gint        *num_colors)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);

  return_vals = gimp_run_procedure_with_array ("gimp-palette-get-info",
                                               args);
  gimp_value_array_unref (args);

  *num_colors = 0;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    *num_colors = g_value_get_int (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_palette_get_colors:
 * @name: The palette name.
 * @num_colors: (out): Length of the colors array.
 *
 * Gets all colors from the specified palette.
 *
 * This procedure retrieves all color entries of the specified palette.
 *
 * Returns: (array length=num_colors) (element-type GimpRGB) (transfer
 * full): The colors in the palette.
 *
 * Since: 2.6
 **/
GimpRGB *
gimp_palette_get_colors (const gchar *name,
                         gint        *num_colors)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpRGB *colors = NULL;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);

  return_vals = gimp_run_procedure_with_array ("gimp-palette-get-colors",
                                               args);
  gimp_value_array_unref (args);

  *num_colors = 0;

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    {
      *num_colors = g_value_get_int (gimp_value_array_index (return_vals, 1));
      colors = gimp_value_dup_rgb_array (gimp_value_array_index (return_vals, 2));
    }

  gimp_value_array_unref (return_vals);

  return colors;
}

/**
 * gimp_palette_get_columns:
 * @name: The palette name.
 *
 * Retrieves the number of columns to use to display this palette
 *
 * This procedures retrieves the preferred number of columns to use
 * when the palette is being displayed.
 *
 * Returns: The number of columns used to display this palette.
 *
 * Since: 2.4
 **/
gint
gimp_palette_get_columns (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint num_columns = 0;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);

  return_vals = gimp_run_procedure_with_array ("gimp-palette-get-columns",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    num_columns = g_value_get_int (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return num_columns;
}

/**
 * gimp_palette_set_columns:
 * @name: The palette name.
 * @columns: The new number of columns.
 *
 * Sets the number of columns to use when displaying the palette
 *
 * This procedures controls how many colors are shown per row when the
 * palette is being displayed. This value can only be changed if the
 * palette is writable. The maximum allowed value is 64.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_palette_set_columns (const gchar *name,
                          gint         columns)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), columns);

  return_vals = gimp_run_procedure_with_array ("gimp-palette-set-columns",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_palette_add_entry:
 * @name: The palette name.
 * @entry_name: The name of the entry.
 * @color: The new entry's color color.
 * @entry_num: (out): The index of the added entry.
 *
 * Adds a palette entry to the specified palette.
 *
 * This procedure adds an entry to the specified palette. It returns an
 * error if the entry palette does not exist.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_palette_add_entry (const gchar   *name,
                        const gchar   *entry_name,
                        const GimpRGB *color,
                        gint          *entry_num)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_STRING,
                                          GIMP_TYPE_RGB,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_string (gimp_value_array_index (args, 1), entry_name);
  gimp_value_set_rgb (gimp_value_array_index (args, 2), color);

  return_vals = gimp_run_procedure_with_array ("gimp-palette-add-entry",
                                               args);
  gimp_value_array_unref (args);

  *entry_num = 0;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    *entry_num = g_value_get_int (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_palette_delete_entry:
 * @name: The palette name.
 * @entry_num: The index of the added entry.
 *
 * Deletes a palette entry from the specified palette.
 *
 * This procedure deletes an entry from the specified palette. It
 * returns an error if the entry palette does not exist.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_palette_delete_entry (const gchar *name,
                           gint         entry_num)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), entry_num);

  return_vals = gimp_run_procedure_with_array ("gimp-palette-delete-entry",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_palette_entry_get_color:
 * @name: The palette name.
 * @entry_num: The entry to retrieve.
 * @color: (out caller-allocates): The color requested.
 *
 * Gets the specified palette entry from the specified palette.
 *
 * This procedure retrieves the color of the zero-based entry specified
 * for the specified palette. It returns an error if the entry does not
 * exist.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_palette_entry_get_color (const gchar *name,
                              gint         entry_num,
                              GimpRGB     *color)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), entry_num);

  return_vals = gimp_run_procedure_with_array ("gimp-palette-entry-get-color",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    gimp_value_get_rgb (gimp_value_array_index (return_vals, 1), &*color);

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_palette_entry_set_color:
 * @name: The palette name.
 * @entry_num: The entry to retrieve.
 * @color: The new color.
 *
 * Sets the specified palette entry in the specified palette.
 *
 * This procedure sets the color of the zero-based entry specified for
 * the specified palette. It returns an error if the entry does not
 * exist.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_palette_entry_set_color (const gchar   *name,
                              gint           entry_num,
                              const GimpRGB *color)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_RGB,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), entry_num);
  gimp_value_set_rgb (gimp_value_array_index (args, 2), color);

  return_vals = gimp_run_procedure_with_array ("gimp-palette-entry-set-color",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_palette_entry_get_name:
 * @name: The palette name.
 * @entry_num: The entry to retrieve.
 * @entry_name: (out) (transfer full): The name requested.
 *
 * Gets the specified palette entry from the specified palette.
 *
 * This procedure retrieves the name of the zero-based entry specified
 * for the specified palette. It returns an error if the entry does not
 * exist.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_palette_entry_get_name (const gchar  *name,
                             gint          entry_num,
                             gchar       **entry_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), entry_num);

  return_vals = gimp_run_procedure_with_array ("gimp-palette-entry-get-name",
                                               args);
  gimp_value_array_unref (args);

  *entry_name = NULL;

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    *entry_name = g_value_dup_string (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_palette_entry_set_name:
 * @name: The palette name.
 * @entry_num: The entry to retrieve.
 * @entry_name: The new name.
 *
 * Sets the specified palette entry in the specified palette.
 *
 * This procedure sets the name of the zero-based entry specified for
 * the specified palette. It returns an error if the entry does not
 * exist.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_palette_entry_set_name (const gchar *name,
                             gint         entry_num,
                             const gchar *entry_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), name);
  g_value_set_int (gimp_value_array_index (args, 1), entry_num);
  g_value_set_string (gimp_value_array_index (args, 2), entry_name);

  return_vals = gimp_run_procedure_with_array ("gimp-palette-entry-set-name",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
