/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include <string.h>

#include <gegl.h>

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "libgimpbase/gimpbase.h"
#include "libgimpconfig/gimpconfig.h"

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "core/gimp-utils.h"
#include "core/gimp.h"
#include "core/gimpimage.h"
#include "core/gimplayer.h"
#include "core/gimpparamspecs.h"
#include "file/file-open.h"
#include "file/file-save.h"
#include "file/file-utils.h"
#include "plug-in/gimppluginmanager-file.h"
#include "plug-in/gimppluginprocedure.h"

#include "gimppdb.h"
#include "gimpprocedure.h"
#include "internal-procs.h"


static GimpValueArray *
file_load_invoker (GimpProcedure         *procedure,
                   Gimp                  *gimp,
                   GimpContext           *context,
                   GimpProgress          *progress,
                   const GimpValueArray  *args,
                   GError               **error)
{
  GimpValueArray      *new_args;
  GimpValueArray      *return_vals;
  GimpPlugInProcedure *file_proc;
  GimpProcedure       *proc;
  GFile               *file;
  gint                 i;

  file = file_utils_filename_to_file (gimp,
                                      g_value_get_string (gimp_value_array_index (args, 1)),
                                      error);

  if (! file)
    return gimp_procedure_get_return_values (procedure, FALSE,
                                             error ? *error : NULL);

  file_proc = gimp_plug_in_manager_file_procedure_find (gimp->plug_in_manager,
                                                        GIMP_FILE_PROCEDURE_GROUP_OPEN,
                                                        file, error);

  if (! file_proc)
    {
      g_object_unref (file);

      return gimp_procedure_get_return_values (procedure, FALSE,
                                               error ? *error : NULL);
    }

  proc = GIMP_PROCEDURE (file_proc);

  new_args = gimp_procedure_get_arguments (proc);

  g_value_transform (gimp_value_array_index (args, 0),
                     gimp_value_array_index (new_args, 0));

  if (file_proc->handles_uri)
    g_value_take_string (gimp_value_array_index (new_args, 1),
                         g_file_get_uri (file));
  else
    g_value_transform (gimp_value_array_index (args, 1),
                       gimp_value_array_index (new_args, 1));

  g_value_transform (gimp_value_array_index (args, 2),
                     gimp_value_array_index (new_args, 2));

  for (i = 3; i < proc->num_args; i++)
    if (G_IS_PARAM_SPEC_STRING (proc->args[i]))
      g_value_set_static_string (gimp_value_array_index (new_args, i), "");

  return_vals =
    gimp_pdb_execute_procedure_by_name_args (gimp->pdb,
                                             context, progress, error,
                                             gimp_object_get_name (proc),
                                             new_args);

  gimp_value_array_unref (new_args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) ==
      GIMP_PDB_SUCCESS)
    {
      if (gimp_value_array_length (return_vals) > 1 &&
          GIMP_VALUE_HOLDS_IMAGE_ID (gimp_value_array_index (return_vals, 1)))
        {
          GimpImage *image =
            gimp_value_get_image (gimp_value_array_index (return_vals, 1),
                                  gimp);
          gimp_image_set_load_proc (image, file_proc);
        }
    }

  g_object_unref (file);

  return return_vals;
}

static GimpValueArray *
file_load_layer_invoker (GimpProcedure         *procedure,
                         Gimp                  *gimp,
                         GimpContext           *context,
                         GimpProgress          *progress,
                         const GimpValueArray  *args,
                         GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gint32 run_mode;
  GimpImage *image;
  const gchar *filename;
  GimpLayer *layer = NULL;

  run_mode = g_value_get_enum (gimp_value_array_index (args, 0));
  image = gimp_value_get_image (gimp_value_array_index (args, 1), gimp);
  filename = g_value_get_string (gimp_value_array_index (args, 2));

  if (success)
    {
      GFile *file = file_utils_filename_to_file (gimp, filename, error);

      if (file)
        {
          GList             *layers;
          GimpPDBStatusType  status;

          layers = file_open_layers (gimp, context, progress,
                                     image, FALSE,
                                     file, run_mode, NULL, &status, error);

          g_object_unref (file);

          if (layers)
            {
              layer = layers->data;
              g_list_free (layers);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    gimp_value_set_layer (gimp_value_array_index (return_vals, 1), layer);

  return return_vals;
}

static GimpValueArray *
file_load_layers_invoker (GimpProcedure         *procedure,
                          Gimp                  *gimp,
                          GimpContext           *context,
                          GimpProgress          *progress,
                          const GimpValueArray  *args,
                          GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gint32 run_mode;
  GimpImage *image;
  const gchar *filename;
  gint32 num_layers = 0;
  gint32 *layer_ids = NULL;

  run_mode = g_value_get_enum (gimp_value_array_index (args, 0));
  image = gimp_value_get_image (gimp_value_array_index (args, 1), gimp);
  filename = g_value_get_string (gimp_value_array_index (args, 2));

  if (success)
    {
      GFile *file = file_utils_filename_to_file (gimp, filename, error);

      if (file)
        {
          GList             *layers;
          GimpPDBStatusType  status;

          layers = file_open_layers (gimp, context, progress,
                                     image, FALSE,
                                     file, run_mode, NULL, &status, error);

          g_object_unref (file);

          if (layers)
            {
              GList *list;
              gint i;

              num_layers = g_list_length (layers);

              layer_ids = g_new (gint32, num_layers);

              for (i = 0, list = layers;
                   i < num_layers;
                   i++, list = g_list_next (list))
                layer_ids[i] = gimp_item_get_ID (GIMP_ITEM (list->data));

              g_list_free (layers);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    {
      g_value_set_int (gimp_value_array_index (return_vals, 1), num_layers);
      gimp_value_take_int32_array (gimp_value_array_index (return_vals, 2), layer_ids, num_layers);
    }

  return return_vals;
}

static GimpValueArray *
file_save_invoker (GimpProcedure         *procedure,
                   Gimp                  *gimp,
                   GimpContext           *context,
                   GimpProgress          *progress,
                   const GimpValueArray  *args,
                   GError               **error)
{
  GimpValueArray      *new_args;
  GimpValueArray      *return_vals;
  GimpPlugInProcedure *file_proc;
  GimpProcedure       *proc;
  GFile               *file;
  gint                 i;

  file = file_utils_filename_to_file (gimp,
                                      g_value_get_string (gimp_value_array_index (args, 3)),
                                      error);

  if (! file)
    return gimp_procedure_get_return_values (procedure, FALSE,
                                             error ? *error : NULL);

  file_proc = gimp_plug_in_manager_file_procedure_find (gimp->plug_in_manager,
                                                        GIMP_FILE_PROCEDURE_GROUP_SAVE,
                                                        file, NULL);

  if (! file_proc)
    file_proc = gimp_plug_in_manager_file_procedure_find (gimp->plug_in_manager,
                                                          GIMP_FILE_PROCEDURE_GROUP_EXPORT,
                                                          file, error);

  if (! file_proc)
    {
      g_object_unref (file);

      return gimp_procedure_get_return_values (procedure, FALSE,
                                               error ? *error : NULL);
    }

  proc = GIMP_PROCEDURE (file_proc);

  new_args = gimp_procedure_get_arguments (proc);

  g_value_transform (gimp_value_array_index (args, 0),
                     gimp_value_array_index (new_args, 0));
  g_value_transform (gimp_value_array_index (args, 1),
                     gimp_value_array_index (new_args, 1));
  g_value_transform (gimp_value_array_index (args, 2),
                     gimp_value_array_index (new_args, 2));

  if (file_proc->handles_uri)
    g_value_take_string (gimp_value_array_index (new_args, 3),
                         g_file_get_uri (file));
  else
    g_value_transform (gimp_value_array_index (args, 3),
                       gimp_value_array_index (new_args, 3));

  g_value_transform (gimp_value_array_index (args, 4),
                     gimp_value_array_index (new_args, 4));

  for (i = 5; i < proc->num_args; i++)
    if (G_IS_PARAM_SPEC_STRING (proc->args[i]))
      g_value_set_static_string (gimp_value_array_index (new_args, i), "");

  return_vals =
    gimp_pdb_execute_procedure_by_name_args (gimp->pdb,
                                             context, progress, error,
                                             gimp_object_get_name (proc),
                                             new_args);

  gimp_value_array_unref (new_args);

  g_object_unref (file);

  return return_vals;
}

static GimpValueArray *
file_load_thumbnail_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *filename;
  gint32 width = 0;
  gint32 height = 0;
  gint32 thumb_data_count = 0;
  guint8 *thumb_data = NULL;

  filename = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      GdkPixbuf *pixbuf = file_utils_load_thumbnail (filename);

      if (pixbuf)
        {
          width            = gdk_pixbuf_get_width (pixbuf);
          height           = gdk_pixbuf_get_height (pixbuf);
          thumb_data_count = 3 * width * height;
          thumb_data       = g_memdup (gdk_pixbuf_get_pixels (pixbuf),
                                       thumb_data_count);

          g_object_unref (pixbuf);
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    {
      g_value_set_int (gimp_value_array_index (return_vals, 1), width);
      g_value_set_int (gimp_value_array_index (return_vals, 2), height);
      g_value_set_int (gimp_value_array_index (return_vals, 3), thumb_data_count);
      gimp_value_take_int8_array (gimp_value_array_index (return_vals, 4), thumb_data, thumb_data_count);
    }

  return return_vals;
}

static GimpValueArray *
file_save_thumbnail_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  const gchar *filename;

  image = gimp_value_get_image (gimp_value_array_index (args, 0), gimp);
  filename = g_value_get_string (gimp_value_array_index (args, 1));

  if (success)
    {
      success = file_utils_save_thumbnail (image, filename);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
register_magic_load_handler_invoker (GimpProcedure         *procedure,
                                     Gimp                  *gimp,
                                     GimpContext           *context,
                                     GimpProgress          *progress,
                                     const GimpValueArray  *args,
                                     GError               **error)
{
  gboolean success = TRUE;
  const gchar *procedure_name;
  const gchar *extensions;
  const gchar *prefixes;
  const gchar *magics;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));
  extensions = g_value_get_string (gimp_value_array_index (args, 1));
  prefixes = g_value_get_string (gimp_value_array_index (args, 2));
  magics = g_value_get_string (gimp_value_array_index (args, 3));

  if (success)
    {
      gchar *canonical = gimp_canonicalize_identifier (procedure_name);

      success = gimp_plug_in_manager_register_load_handler (gimp->plug_in_manager,
                                                            canonical,
                                                            extensions, prefixes, magics);

      g_free (canonical);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
register_load_handler_invoker (GimpProcedure         *procedure,
                               Gimp                  *gimp,
                               GimpContext           *context,
                               GimpProgress          *progress,
                               const GimpValueArray  *args,
                               GError               **error)
{
  gboolean success = TRUE;
  const gchar *procedure_name;
  const gchar *extensions;
  const gchar *prefixes;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));
  extensions = g_value_get_string (gimp_value_array_index (args, 1));
  prefixes = g_value_get_string (gimp_value_array_index (args, 2));

  if (success)
    {
      gchar *canonical = gimp_canonicalize_identifier (procedure_name);

      success = gimp_plug_in_manager_register_load_handler (gimp->plug_in_manager,
                                                            canonical,
                                                            extensions, prefixes, NULL);

      g_free (canonical);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
register_save_handler_invoker (GimpProcedure         *procedure,
                               Gimp                  *gimp,
                               GimpContext           *context,
                               GimpProgress          *progress,
                               const GimpValueArray  *args,
                               GError               **error)
{
  gboolean success = TRUE;
  const gchar *procedure_name;
  const gchar *extensions;
  const gchar *prefixes;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));
  extensions = g_value_get_string (gimp_value_array_index (args, 1));
  prefixes = g_value_get_string (gimp_value_array_index (args, 2));

  if (success)
    {
      gchar *canonical = gimp_canonicalize_identifier (procedure_name);

      success = gimp_plug_in_manager_register_save_handler (gimp->plug_in_manager,
                                                            canonical,
                                                            extensions, prefixes);

      g_free (canonical);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
register_file_handler_priority_invoker (GimpProcedure         *procedure,
                                        Gimp                  *gimp,
                                        GimpContext           *context,
                                        GimpProgress          *progress,
                                        const GimpValueArray  *args,
                                        GError               **error)
{
  gboolean success = TRUE;
  const gchar *procedure_name;
  gint32 priority;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));
  priority = g_value_get_int (gimp_value_array_index (args, 1));

  if (success)
    {
      gchar *canonical = gimp_canonicalize_identifier (procedure_name);

      success = gimp_plug_in_manager_register_priority (gimp->plug_in_manager,
                                                        canonical, priority);

      g_free (canonical);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
register_file_handler_mime_invoker (GimpProcedure         *procedure,
                                    Gimp                  *gimp,
                                    GimpContext           *context,
                                    GimpProgress          *progress,
                                    const GimpValueArray  *args,
                                    GError               **error)
{
  gboolean success = TRUE;
  const gchar *procedure_name;
  const gchar *mime_types;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));
  mime_types = g_value_get_string (gimp_value_array_index (args, 1));

  if (success)
    {
      gchar *canonical = gimp_canonicalize_identifier (procedure_name);

      success = gimp_plug_in_manager_register_mime_types (gimp->plug_in_manager,
                                                          canonical, mime_types);

      g_free (canonical);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
register_file_handler_uri_invoker (GimpProcedure         *procedure,
                                   Gimp                  *gimp,
                                   GimpContext           *context,
                                   GimpProgress          *progress,
                                   const GimpValueArray  *args,
                                   GError               **error)
{
  gboolean success = TRUE;
  const gchar *procedure_name;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      gchar *canonical = gimp_canonicalize_identifier (procedure_name);

      success = gimp_plug_in_manager_register_handles_uri (gimp->plug_in_manager,
                                                           canonical);

      g_free (canonical);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
register_file_handler_raw_invoker (GimpProcedure         *procedure,
                                   Gimp                  *gimp,
                                   GimpContext           *context,
                                   GimpProgress          *progress,
                                   const GimpValueArray  *args,
                                   GError               **error)
{
  gboolean success = TRUE;
  const gchar *procedure_name;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      gchar *canonical = gimp_canonicalize_identifier (procedure_name);

      success = gimp_plug_in_manager_register_handles_raw (gimp->plug_in_manager,
                                                           canonical);

      g_free (canonical);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
register_thumbnail_loader_invoker (GimpProcedure         *procedure,
                                   Gimp                  *gimp,
                                   GimpContext           *context,
                                   GimpProgress          *progress,
                                   const GimpValueArray  *args,
                                   GError               **error)
{
  gboolean success = TRUE;
  const gchar *load_proc;
  const gchar *thumb_proc;

  load_proc = g_value_get_string (gimp_value_array_index (args, 0));
  thumb_proc = g_value_get_string (gimp_value_array_index (args, 1));

  if (success)
    {
      gchar *canonical   = gimp_canonicalize_identifier (load_proc);
      gchar *canon_thumb = gimp_canonicalize_identifier (thumb_proc);

      success = gimp_plug_in_manager_register_thumb_loader (gimp->plug_in_manager,
                                                            canonical, canon_thumb);

      g_free (canonical);
      g_free (canon_thumb);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_fileops_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-file-load
   */
  procedure = gimp_procedure_new (file_load_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-file-load");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-file-load",
                                     "Loads an image file by invoking the right load handler.",
                                     "This procedure invokes the correct file load handler using magic if possible, and falling back on the file's extension and/or prefix if not. The name of the file to load is typically a full pathname, and the name entered is what the user actually typed before prepending a directory path. The reason for this is that if the user types https://www.gimp.org/foo.png he wants to fetch a URL, and the full pathname will not look like a URL.",
                                     "Josh MacDonald",
                                     "Josh MacDonald",
                                     "1997",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_enum ("run-mode",
                                                     "run mode",
                                                     "The run mode",
                                                     GIMP_TYPE_RUN_MODE,
                                                     GIMP_RUN_INTERACTIVE,
                                                     GIMP_PARAM_READWRITE));
  gimp_param_spec_enum_exclude_value (GIMP_PARAM_SPEC_ENUM (procedure->args[0]),
                                      GIMP_RUN_WITH_LAST_VALS);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("filename",
                                                       "filename",
                                                       "The name of the file to load",
                                                       TRUE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("raw-filename",
                                                       "raw filename",
                                                       "The name as entered by the user",
                                                       TRUE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_image_id ("image",
                                                             "image",
                                                             "The output image",
                                                             pdb->gimp, FALSE,
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-file-load-layer
   */
  procedure = gimp_procedure_new (file_load_layer_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-file-load-layer");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-file-load-layer",
                                     "Loads an image file as a layer for an existing image.",
                                     "This procedure behaves like the file-load procedure but opens the specified image as a layer for an existing image. The returned layer needs to be added to the existing image with 'gimp-image-insert-layer'.",
                                     "Sven Neumann <sven@gimp.org>",
                                     "Sven Neumann",
                                     "2005",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_enum ("run-mode",
                                                     "run mode",
                                                     "The run mode",
                                                     GIMP_TYPE_RUN_MODE,
                                                     GIMP_RUN_INTERACTIVE,
                                                     GIMP_PARAM_READWRITE));
  gimp_param_spec_enum_exclude_value (GIMP_PARAM_SPEC_ENUM (procedure->args[0]),
                                      GIMP_RUN_WITH_LAST_VALS);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "Destination image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("filename",
                                                       "filename",
                                                       "The name of the file to load",
                                                       TRUE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_layer_id ("layer",
                                                             "layer",
                                                             "The layer created when loading the image file",
                                                             pdb->gimp, FALSE,
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-file-load-layers
   */
  procedure = gimp_procedure_new (file_load_layers_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-file-load-layers");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-file-load-layers",
                                     "Loads an image file as layers for an existing image.",
                                     "This procedure behaves like the file-load procedure but opens the specified image as layers for an existing image. The returned layers needs to be added to the existing image with 'gimp-image-insert-layer'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2006",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_enum ("run-mode",
                                                     "run mode",
                                                     "The run mode",
                                                     GIMP_TYPE_RUN_MODE,
                                                     GIMP_RUN_INTERACTIVE,
                                                     GIMP_PARAM_READWRITE));
  gimp_param_spec_enum_exclude_value (GIMP_PARAM_SPEC_ENUM (procedure->args[0]),
                                      GIMP_RUN_WITH_LAST_VALS);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "Destination image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("filename",
                                                       "filename",
                                                       "The name of the file to load",
                                                       TRUE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("num-layers",
                                                          "num layers",
                                                          "The number of loaded layers",
                                                          0, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32_array ("layer-ids",
                                                                "layer ids",
                                                                "The list of loaded layers",
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-file-save
   */
  procedure = gimp_procedure_new (file_save_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-file-save");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-file-save",
                                     "Saves a file by extension.",
                                     "This procedure invokes the correct file save handler according to the file's extension and/or prefix. The name of the file to save is typically a full pathname, and the name entered is what the user actually typed before prepending a directory path. The reason for this is that if the user types https://www.gimp.org/foo.png she wants to fetch a URL, and the full pathname will not look like a URL.",
                                     "Josh MacDonald",
                                     "Josh MacDonald",
                                     "1997",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("run-mode",
                                                  "run mode",
                                                  "The run mode",
                                                  GIMP_TYPE_RUN_MODE,
                                                  GIMP_RUN_INTERACTIVE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "Input image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "Drawable to save",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("filename",
                                                       "filename",
                                                       "The name of the file to save the image in",
                                                       TRUE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("raw-filename",
                                                       "raw filename",
                                                       "The name as entered by the user",
                                                       TRUE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-file-load-thumbnail
   */
  procedure = gimp_procedure_new (file_load_thumbnail_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-file-load-thumbnail");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-file-load-thumbnail",
                                     "Loads the thumbnail for a file.",
                                     "This procedure tries to load a thumbnail that belongs to the file with the given filename. This name is a full pathname. The returned data is an array of colordepth 3 (RGB), regardless of the image type. Width and height of the thumbnail are also returned. Don't use this function if you need a thumbnail of an already opened image, use 'gimp-image-thumbnail' instead.",
                                     "Adam D. Moss, Sven Neumann",
                                     "Adam D. Moss, Sven Neumann",
                                     "1999-2003",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("filename",
                                                       "filename",
                                                       "The name of the file that owns the thumbnail to load",
                                                       TRUE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("width",
                                                          "width",
                                                          "The width of the thumbnail",
                                                          G_MININT32, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("height",
                                                          "height",
                                                          "The height of the thumbnail",
                                                          G_MININT32, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("thumb-data-count",
                                                          "thumb data count",
                                                          "The number of bytes in thumbnail data",
                                                          0, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int8_array ("thumb-data",
                                                               "thumb data",
                                                               "The thumbnail data",
                                                               GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-file-save-thumbnail
   */
  procedure = gimp_procedure_new (file_save_thumbnail_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-file-save-thumbnail");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-file-save-thumbnail",
                                     "Saves a thumbnail for the given image",
                                     "This procedure saves a thumbnail for the given image according to the Free Desktop Thumbnail Managing Standard. The thumbnail is saved so that it belongs to the file with the given filename. This means you have to save the image under this name first, otherwise this procedure will fail. This procedure may become useful if you want to explicitly save a thumbnail with a file.",
                                     "Josh MacDonald",
                                     "Josh MacDonald",
                                     "1997",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("filename",
                                                       "filename",
                                                       "The name of the file the thumbnail belongs to",
                                                       TRUE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-register-magic-load-handler
   */
  procedure = gimp_procedure_new (register_magic_load_handler_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-register-magic-load-handler");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-register-magic-load-handler",
                                     "Registers a file load handler procedure.",
                                     "Registers a procedural database procedure to be called to load files of a particular file format using magic file information.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The name of the procedure to be used for loading",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("extensions",
                                                       "extensions",
                                                       "comma separated list of extensions this handler can load (i.e. \"jpg,jpeg\")",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE | GIMP_PARAM_NO_VALIDATE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("prefixes",
                                                       "prefixes",
                                                       "comma separated list of prefixes this handler can load (i.e. \"http:,ftp:\")",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE | GIMP_PARAM_NO_VALIDATE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("magics",
                                                       "magics",
                                                       "comma separated list of magic file information this handler can load (i.e. \"0,string,GIF\")",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE | GIMP_PARAM_NO_VALIDATE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-register-load-handler
   */
  procedure = gimp_procedure_new (register_load_handler_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-register-load-handler");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-register-load-handler",
                                     "Registers a file load handler procedure.",
                                     "Registers a procedural database procedure to be called to load files of a particular file format.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The name of the procedure to be used for loading",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("extensions",
                                                       "extensions",
                                                       "comma separated list of extensions this handler can load (i.e. \"jpg,jpeg\")",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE | GIMP_PARAM_NO_VALIDATE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("prefixes",
                                                       "prefixes",
                                                       "comma separated list of prefixes this handler can load (i.e. \"http:,ftp:\")",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE | GIMP_PARAM_NO_VALIDATE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-register-save-handler
   */
  procedure = gimp_procedure_new (register_save_handler_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-register-save-handler");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-register-save-handler",
                                     "Registers a file save handler procedure.",
                                     "Registers a procedural database procedure to be called to save files in a particular file format.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The name of the procedure to be used for saving",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("extensions",
                                                       "extensions",
                                                       "comma separated list of extensions this handler can save (i.e. \"jpg,jpeg\")",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE | GIMP_PARAM_NO_VALIDATE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("prefixes",
                                                       "prefixes",
                                                       "comma separated list of prefixes this handler can save (i.e. \"http:,ftp:\")",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE | GIMP_PARAM_NO_VALIDATE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-register-file-handler-priority
   */
  procedure = gimp_procedure_new (register_file_handler_priority_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-register-file-handler-priority");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-register-file-handler-priority",
                                     "Sets the priority of a file handler procedure.",
                                     "Sets the priority of a file handler procedure. When more than one procedure matches a given file, the procedure with the lowest priority is used; if more than one procedure has the lowest priority, it is unspecified which one of them is used. The default priority for file handler procedures is 0.",
                                     "Ell",
                                     "Ell",
                                     "2018",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The name of the procedure to set the priority of.",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("priority",
                                                      "priority",
                                                      "The procedure priority.",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-register-file-handler-mime
   */
  procedure = gimp_procedure_new (register_file_handler_mime_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-register-file-handler-mime");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-register-file-handler-mime",
                                     "Associates MIME types with a file handler procedure.",
                                     "Registers MIME types for a file handler procedure. This allows GIMP to determine the MIME type of the file opened or saved using this procedure. It is recommended that only one MIME type is registered per file procedure; when registering more than one MIME type, GIMP will associate the first one with files opened or saved with this procedure.",
                                     "Sven Neumann <sven@gimp.org>",
                                     "Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The name of the procedure to associate a MIME type with.",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("mime-types",
                                                       "mime types",
                                                       "A comma-separated list of MIME types, such as \"image/jpeg\".",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-register-file-handler-uri
   */
  procedure = gimp_procedure_new (register_file_handler_uri_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-register-file-handler-uri");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-register-file-handler-uri",
                                     "Registers a file handler procedure as capable of handling URIs.",
                                     "Registers a file handler procedure as capable of handling URIs. This allows GIMP to call the procedure directly for all kinds of URIs, and the 'filename' traditionally passed to file procedures turns into an URI.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2012",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The name of the procedure to enable URIs for.",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-register-file-handler-raw
   */
  procedure = gimp_procedure_new (register_file_handler_raw_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-register-file-handler-raw");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-register-file-handler-raw",
                                     "Registers a file handler procedure as capable of handling raw camera files.",
                                     "Registers a file handler procedure as capable of handling raw digital camera files. Use this procedure only to register raw load handlers, calling it on a save handler will generate an error.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2017",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The name of the procedure to enable raw handling for.",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-register-thumbnail-loader
   */
  procedure = gimp_procedure_new (register_thumbnail_loader_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-register-thumbnail-loader");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-register-thumbnail-loader",
                                     "Associates a thumbnail loader with a file load procedure.",
                                     "Some file formats allow for embedded thumbnails, other file formats contain a scalable image or provide the image data in different resolutions. A file plug-in for such a format may register a special procedure that allows GIMP to load a thumbnail preview of the image. This procedure is then associated with the standard load procedure using this function.",
                                     "Sven Neumann <sven@gimp.org>",
                                     "Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("load-proc",
                                                       "load proc",
                                                       "The name of the procedure the thumbnail loader with.",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("thumb-proc",
                                                       "thumb proc",
                                                       "The name of the thumbnail load procedure.",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
