/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpfloatingsel_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpfloatingsel
 * @title: gimpfloatingsel
 * @short_description: Functions for removing or attaching floating selections.
 *
 * Functions for removing or attaching floating selections.
 **/


/**
 * gimp_floating_sel_remove:
 * @floating_sel_ID: The floating selection.
 *
 * Remove the specified floating selection from its associated
 * drawable.
 *
 * This procedure removes the floating selection completely, without
 * any side effects. The associated drawable is then set to active.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_floating_sel_remove (gint32 floating_sel_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-floating-sel-remove",
                                    &nreturn_vals,
                                    GIMP_PDB_LAYER, floating_sel_ID,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_floating_sel_anchor:
 * @floating_sel_ID: The floating selection.
 *
 * Anchor the specified floating selection to its associated drawable.
 *
 * This procedure anchors the floating selection to its associated
 * drawable. This is similar to merging with a merge type of
 * ClipToBottomLayer. The floating selection layer is no longer valid
 * after this operation.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_floating_sel_anchor (gint32 floating_sel_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-floating-sel-anchor",
                                    &nreturn_vals,
                                    GIMP_PDB_LAYER, floating_sel_ID,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_floating_sel_to_layer:
 * @floating_sel_ID: The floating selection.
 *
 * Transforms the specified floating selection into a layer.
 *
 * This procedure transforms the specified floating selection into a
 * layer with the same offsets and extents. The composited image will
 * look precisely the same, but the floating selection layer will no
 * longer be clipped to the extents of the drawable it was attached to.
 * The floating selection will become the active layer. This procedure
 * will not work if the floating selection has a different base type
 * from the underlying image. This might be the case if the floating
 * selection is above an auxiliary channel or a layer mask.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_floating_sel_to_layer (gint32 floating_sel_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-floating-sel-to-layer",
                                    &nreturn_vals,
                                    GIMP_PDB_LAYER, floating_sel_ID,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_floating_sel_attach:
 * @layer_ID: The layer (is attached as floating selection).
 * @drawable_ID: The drawable (where to attach the floating selection).
 *
 * Attach the specified layer as floating to the specified drawable.
 *
 * This procedure attaches the layer as floating selection to the
 * drawable.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_floating_sel_attach (gint32 layer_ID,
                          gint32 drawable_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-floating-sel-attach",
                                    &nreturn_vals,
                                    GIMP_PDB_LAYER, layer_ID,
                                    GIMP_PDB_DRAWABLE, drawable_ID,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}
