module cubetools_help
  use cubetools_parameters
  use cubetools_messaging
  !---------------------------------------------------------------------
  ! Support module for help
  !---------------------------------------------------------------------
  !
  ! Parameters
  integer(kind=4), parameter :: terminal_max_width=90
  integer(kind=4), parameter :: file_default_width=74  ! for e.g. COLLECT
  !
  ! Dynamic
  integer(kind=4) :: current_width=terminal_max_width
  !
  public :: help_width,strg_dash
  public :: cubetools_help_terminal_width,cubetools_help_file_width
  public :: cubetools_help_print
  private
  !
contains
  !
  function help_width()
    !-------------------------------------------------------------------
    ! Return the help string width adapted to the terminal size.
    ! Leave 2 blank characters to the left and to the right of the
    ! terminal.
    !-------------------------------------------------------------------
    integer(kind=4) :: help_width
    help_width = current_width-4
  end function help_width
  !
  function strg_dash()
    !-------------------------------------------------------------------
    ! Return a string of dashes of length tt_width
    !-------------------------------------------------------------------
    character(len=:), allocatable :: strg_dash
    strg_dash = repeat('-',current_width)  ! Implicit allocation
  end function strg_dash
  !
  subroutine cubetools_help_terminal_width()
    use gkernel_interfaces
    !-------------------------------------------------------------------
    ! Set the current help width so that it is adapted to the current
    ! terminal, if any
    !-------------------------------------------------------------------
    if (sic_isatty().eq.1) then
      ! Interactive session in a terminal
      current_width = min(sic_ttyncol(),terminal_max_width)
    else
      ! Non-interactive session, e.g. batch mode redirected to file
      current_width = file_default_width
    endif
  end subroutine cubetools_help_terminal_width
  !
  subroutine cubetools_help_file_width()
    !-------------------------------------------------------------------
    ! Set the current help width so that it is adapted for ouput to a
    ! file, for e.g. command COLLECT
    !-------------------------------------------------------------------
    current_width = file_default_width
  end subroutine cubetools_help_file_width
  !
  subroutine cubetools_help_print(help_strg,error)
    !-------------------------------------------------------------------
    ! Print an help string, possibly over several lines.
    !-------------------------------------------------------------------
    character(len=*), intent(in)    :: help_strg
    logical,          intent(inout) :: error
    !
    character(len=mess_l) :: mess,word
    integer(kind=4) :: lenword,lenline,lenhelp,ichar
    character(len=*), parameter :: spc = ' '
    character(len=*), parameter :: rname='HELP>PRINT'
    !
    call cubetools_message(toolseve%trace,rname,'Welcome')
    !
    lenhelp = len_trim(help_strg)
    lenline = 0
    lenword = 0
    do ichar=1,lenhelp
       if (help_strg(ichar:ichar).eq.spc) then
          if (lenline+lenword.gt.help_width()) then
             ! message mess
             call cubetools_message(toolseve%help,rname,mess)
             ! write word to begining of mess
             write(mess,'(2x,a)') word(1:lenword)
             lenline = lenword+2
          else if (lenline.eq.0) then
             write(mess,'(2x,a)') word(1:lenword)
             lenline = lenword+2
          else
             ! write word to end of mess
             write(mess,'(a,x,a)') mess(1:lenline),word(1:lenword)
             lenline = lenline+lenword+1
          endif
          lenword=0
       elseif (ichar.eq.lenhelp) then
          lenword=lenword+1
          word(lenword:lenword) = help_strg(ichar:ichar)
          if (lenline+lenword.gt.help_width()) then
             call cubetools_message(toolseve%help,rname,mess)
             write(mess,'(2x,a)') word(1:lenword)
             lenline = lenword+2
          else
             write(mess,'(a,x,a)') mess(1:lenline),word(1:lenword)
             lenline = lenline+lenword+1
          endif
          call cubetools_message(toolseve%help,rname,mess)
       else if (help_strg(ichar:ichar).eq.strg_cr) then
          write(mess,'(a,x,a)') mess(1:lenline),word(1:lenword)
          lenline = lenline+lenword+1
          call cubetools_message(toolseve%help,rname,mess(1:lenline))
          lenline = 0
          lenword = 0
       else
          lenword=lenword+1
          word(lenword:lenword) = help_strg(ichar:ichar)
          ! add char to word
       endif
    enddo
  end subroutine cubetools_help_print
end module cubetools_help
