!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetemplate_subcube
  use cube_types
  use cubetools_structure
  use cubeadm_cubeid_types
  use cubemain_sperange_types
  use cubetemplate_messaging
  !
  public :: subcube
  public :: cubetemplate_subcube_command
  private
  !
  type :: subcube_comm_t
     type(option_t), pointer :: comm  
     type(option_t), pointer :: factor
     type(sperange_opt_t)    :: range
   contains
     procedure, public  :: register => cubetemplate_subcube_register
     procedure, private :: parse    => cubetemplate_subcube_parse
     procedure, private :: main     => cubetemplate_subcube_main
  end type subcube_comm_t
  type(subcube_comm_t) :: subcube
  !
  integer(kind=4), parameter :: icube = 1
  type subcube_user_t
     type(cubeid_user_t)   :: cubeids
     type(sperange_user_t) :: range
     character(len=argu_l) :: factor
   contains
     procedure, private :: toprog => cubetemplate_subcube_user_toprog
  end type subcube_user_t
  type subcube_prog_t
     type(sperange_prog_t) :: range
     real(kind=sign_k)     :: factor
     type(cube_t), pointer :: incube
     type(cube_t), pointer :: oucube
   contains
     procedure, private :: header => cubetemplate_subcube_prog_header
     procedure, private :: data   => cubetemplate_subcube_prog_data
     procedure, private :: loop   => cubetemplate_subcube_prog_loop
     procedure, private :: act    => cubetemplate_subcube_prog_act
  end type subcube_prog_t
  !
contains
  !
  subroutine cubetemplate_subcube_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(subcube_user_t) :: user
    character(len=*), parameter :: rname='SUBCUBE>COMMAND'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call subcube%parse(line,user,error)
    if (error) return
    call subcube%main(user,error)
    if (error) continue
  end subroutine cubetemplate_subcube_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_subcube_register(subcube,error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(subcube_comm_t), intent(inout) :: subcube
    logical,               intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    type(standard_arg_t) :: stdarg
    character(len=*), parameter :: comm_abstract = 'Template command for working with subcubes'
    character(len=*), parameter :: comm_help = &
         'Input and output cube ares real'
    character(len=*), parameter :: rname='SUBCUBE>REGISTER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'SUBCUBE','[cube]',&
         comm_abstract,&
         comm_help,&
         cubetemplate_subcube_command,&
         subcube%comm,error)
    if (error) return
    call cubearg%register(&
         'CUBE',&
         'Signal cube',&
         strg_id,&
         code_arg_optional,&
         [flag_any],&
         error)
    if (error) return
    !
    call subcube%range%register(&
         'RANGE',&
         'Define velocity range(s)',&
         error)
    if (error) return
    !
    call cubetools_register_option(&
         'FACTOR','factor',&
         'Multiply data by a factor',&
         strg_id,&
         subcube%factor,error)
    if (error) return
    call stdarg%register(&
         'factor',&
         'factor',&
         'default is 1',&
         code_arg_mandatory, error)
    if (error) return
  end subroutine cubetemplate_subcube_register
  !
  subroutine cubetemplate_subcube_parse(subcube,line,user,error)
    !----------------------------------------------------------------------
    ! SUBCUBE cubname
    ! /RANGE vfirst vlast
    ! /FACTOR factor
    !----------------------------------------------------------------------
    class(subcube_comm_t), intent(in)    :: subcube
    character(len=*),      intent(in)    :: line
    type(subcube_user_t),  intent(out)   :: user
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='SUBCUBE>PARSE'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,subcube%comm,user%cubeids,error)
    if (error) return
    call subcube%range%parse(line,user%range,error)
    if (error) return
    call cubetemplate_subcube_parse_factor(line,subcube%factor,user%factor,error)
    if (error) return
  end subroutine cubetemplate_subcube_parse
  !
  subroutine cubetemplate_subcube_parse_factor(line,opt,user,error)
    !----------------------------------------------------------------------
    ! /FACTOR factor
    !----------------------------------------------------------------------
    character(len=*),       intent(in)    :: line
    type(option_t),         intent(in)    :: opt
    character(len=*),       intent(out)   :: user
    logical,                intent(inout) :: error
    !
    logical :: present
    integer(kind=4), parameter :: iarg=1
    character(len=*), parameter :: rname='SUBCUBE>PARSE>FACTOR'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call opt%present(line,present,error)
    if (error) return
    if (present) then
       call cubetools_getarg(line,opt,iarg,user,mandatory,error)
       if (error) return
    else
       user = strg_star
    endif
  end subroutine cubetemplate_subcube_parse_factor
  !
  subroutine cubetemplate_subcube_main(subcube,user,error)    
    use cubeadm_timing
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(subcube_comm_t), intent(in)    :: subcube
    type(subcube_user_t),  intent(inout) :: user
    logical,               intent(inout) :: error
    !
    type(subcube_prog_t) :: prog
    character(len=*), parameter :: rname='SUBCUBE>MAIN'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call user%toprog(prog,error)
    if (error) return
    call prog%header(error)
    if (error) return
    call cubeadm_timing_prepro2process()
    call prog%data(error)
    if (error) return
    call cubeadm_timing_process2postpro()
  end subroutine cubetemplate_subcube_main
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_subcube_user_toprog(user,prog,error)
    use cubetools_user2prog
    use cubetools_unit
    use cubeadm_get
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(subcube_user_t), intent(in)    :: user
    type(subcube_prog_t),  intent(out)   :: prog
    logical,               intent(inout) :: error
    !
    real(kind=sign_k), parameter :: default=1.0
    type(unit_user_t) :: nounit
    character(len=*), parameter :: rname='SUBCUBE>USER>TOPROG'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_get_header(subcube%comm,icube,user%cubeids,&
         code_access_subset,code_read,prog%incube,error)
    if (error) return
    !
    call user%range%toprog(prog%incube,prog%range,error)
    if (error) return
    !
    call cubetools_unit_get(strg_star,code_unit_unk,nounit,error)
    if (error) return
    call cubetools_user2prog_resolve_star(user%factor,nounit,default,prog%factor,error)
    if (error) return
  end subroutine cubetemplate_subcube_user_toprog
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_subcube_prog_header(prog,error)
    use cubedag_allflags
    use cubeadm_clone
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(subcube_prog_t), intent(inout) :: prog
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='SUBCUBE>PROG>HEADER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_clone_header(prog%incube,flag_template,prog%oucube,error)
    if (error) return
  end subroutine cubetemplate_subcube_prog_header
  !
  subroutine cubetemplate_subcube_prog_data(prog,error)
    use cubeadm_opened
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(subcube_prog_t), intent(inout) :: prog
    logical,               intent(inout) :: error
    !
    type(cubeadm_iterator_t) :: iterentry
    character(len=*), parameter :: rname='SUBCUBE>PROG>DATA'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_datainit_all(iterentry,error)
    if (error) return
    !$OMP PARALLEL DEFAULT(none) SHARED(prog,error) FIRSTPRIVATE(iterentry)
    !$OMP SINGLE
    do while (cubeadm_dataiterate_all(iterentry,error))
       if (error)  exit
       !$OMP TASK SHARED(prog) FIRSTPRIVATE(iterentry,error)
       if (.not.error)  &
         call prog%loop(iterentry,error)
       !$OMP END TASK
    enddo ! ie
    !$OMP END SINGLE
    !$OMP END PARALLEL
  end subroutine cubetemplate_subcube_prog_data
  !   
  subroutine cubetemplate_subcube_prog_loop(prog,iterentry,error)
    use cubeadm_entryloop
    use cubeadm_taskloop
    use cubemain_subcube_real
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(subcube_prog_t),    intent(inout) :: prog
    type(cubeadm_iterator_t), intent(in)    :: iterentry
    logical,                  intent(inout) :: error
    !
    type(subcube_iterator_t) :: itersubcube
    integer(kind=entr_k) :: isubcube
    character(len=*), parameter :: rname='SUBCUBE>PROG>LOOP'
    !
    do isubcube=iterentry%first,iterentry%last
      call cubeadm_entryloop_iterate(isubcube,error)
      if (error)  return
      call itersubcube%init(iterentry,isubcube,error)
      if (error)  return
      call prog%act(itersubcube,error)
      if (error)  return
    enddo
  end subroutine cubetemplate_subcube_prog_loop
  !   
  subroutine cubetemplate_subcube_prog_act(prog,iter,error)
    use cubemain_subcube_real
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(subcube_prog_t),    intent(inout) :: prog
    type(subcube_iterator_t), intent(in)    :: iter
    logical,                  intent(inout) :: error
    !
    integer(kind=data_k) :: i1,i2,i3
    type(subcube_t) :: insub,ousub
    character(len=*), parameter :: rname='SUBCUBE>PROG>ACT'
    !
    ! Subcubes are initialized here as their size (3rd dim) may change from
    ! from one subcube to another.
    call insub%init(prog%incube,error)
    if (error)  return
    call ousub%reallocate(prog%oucube,iter,error)
    if (error)  return
    !
    call insub%get(prog%incube,iter,error)
    if (error)  return
    do i3=1,insub%n3
       do i2=1,insub%n2
          do i1=1,insub%n1
             ousub%data(i1,i2,i3) = prog%factor*insub%data(i1,i2,i3)
          enddo ! i1
       enddo ! i2
    enddo ! i3
    call ousub%put(prog%oucube,iter,error)
    if (error)  return
  end subroutine cubetemplate_subcube_prog_act
end module cubetemplate_subcube
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
