!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeadm_language
  use cubetools_structure
  use cubedag_dagcomm
  use cubeadm_messaging
  use cubeadm_directory
  use cubeadm_find
  use cubeadm_flaglist
  use cubeadm_free
  use cubeadm_history
  use cubeadm_import
  use cubeadm_list
  use cubeadm_memory
  use cubeadm_remove
  use cubeadm_snapshot
  use cubeadm_undo
  use cubeadm_update
  !
  public :: cubeadm_register_language
  private
  !
  integer(kind=lang_k) :: langid
  !
contains
  !
  subroutine cubeadm_register_language(error)
    !----------------------------------------------------------------------
    ! Register the ADM\ language
    !----------------------------------------------------------------------
    logical, intent(inout) :: error
    !
    call cubetools_register_language('ADM',&
         'J.Pety, S.Bardeau, V.deSouzaMagalhaes',&
         'Commands to manage list of cubes',&
         'gag_doc:hlp/cube-help-adm.hlp',&
         cubeadm_execute_command,langid,error)
    if (error) return
    !
    call cubedag_dag_register(error)
    if (error) return
    call directory%register(error)
    if (error) return
    call cubeadm_find_register(error)
    if (error) return
    call flaglist%register(error)
    if (error) return
    call cubeadm_free_register(error)
    if (error) return
    call cubeadm_history_register(error)
    if (error) return
    call cubeadm_import_register(error)
    if (error) return
    call cubeadm_list_register(error)
    if (error) return
    call cubeadm_memory_register(error)
    if (error) return
    call cubeadm_remove_register(error)
    if (error) return
    call cubeadm_snapshot_register(error)
    if (error) return
    call cubeadm_undo_register(error)
    if (error) return
    call cubeadm_update_register(error)
    if (error) return
    !
    call cubetools_register_dict(error)
    if (error) return
  end subroutine cubeadm_register_language
  !
  subroutine cubeadm_execute_command(line,comm,error)
    !----------------------------------------------------------------------
    ! Execute a command of the ADM\ language
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    character(len=*), intent(in)    :: comm
    logical,          intent(inout) :: error
    !
    character(len=*), parameter :: rname='EXECUTE>COMMAND'
    !
    error = .false.
    if (comm.eq.'ADM?') then
       call cubetools_list_language_commands(langid,error)
       if (error) return
    else
       call cubetools_execute_command(line,langid,comm,error)
       if (error) return
       ! There should be no call to cubeadm_finish_all here
    endif
  end subroutine cubeadm_execute_command
end module cubeadm_language
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
