!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module clean_language
  use gbl_message
  !
  public :: init_clean,run_clean
  private
  !
contains
  !
  subroutine init_clean
    use gkernel_interfaces
    use clean_def
    use clean_arrays
    use mapping_default_types
    !----------------------------------------------------------------------
    ! Initialize Mapping Language
    !----------------------------------------------------------------------
    !
    logical, save :: MappingError
    logical :: error
    !
    integer :: mclean
    parameter (mclean=106+1)  ! MFS 
    character(len=16) :: vocab(mclean)
    data vocab /' DUMP',  &
         ' ALMA','/FLUX','/PLOT','/QUERY','/NOISE','/METHOD',&
         ' CLEAN','/FLUX','/PLOT','/QUERY','/NITER','/ARES',&  !No conflict with ALMA ?
         ' CLARK','/FLUX','/PLOT','/QUERY',&
         ' FIT',' FLUX_SCALE',&
         ' HOGBOM','/FLUX',&
         ' LOAD',&
         ' MAP_COMPRESS',' MAP_RESAMPLE',' MAP_INTEGRATE',&
         ' MOSAIC',&
         ' MRC','/FLUX','/PLOT','/QUERY',&
         ' MFS',&
         ' MULTI','/FLUX',&
         ' MX','/FLUX','/PLOT','/QUERY',&
         ' PRIMARY','/TRUNCATE',&
         ' READ','/COMPACT','/FREQUENCY','/PLANE','/RANGE',  '/NOTRAIL','/TELESCOPE',&
         ' SHOW',&
         ' SDI','/FLUX','/PLOT','/QUERY',&
         ' SPECIFY',&
         ' STATISTICS','/WHOLE',&
         ' SUPPORT','/CURSOR','/MASK','/PLOT','/RESET','/THRESHOLD','/VARIABLE',&
         ' UV_BASELINE','/CHANNELS','/FREQUENCY','/RANGE','/WIDTH',&
         ' UV_CHECK',' UV_COMPRESS',' UV_CONTINUUM','/INDEX',&
         ' UV_EXTRACT','/RANGE','/FREQUENCY','/WIDTH',&
         ' UV_FLAG','/ANTENNA','/RESET',&
         ' UV_FILTER','/CHANNELS','/FREQUENCY','/RANGE','/WIDTH','/ZERO',&
         ' UV_MAP','/TRUNCATE',  '/FIELDS',&
         ' UV_RESAMPLE',  ' UV_RESIDUAL',' UV_RESTORE','/COPY','/SLOW',' UV_REWEIGHT', ' UV_RMS',&
         ' UV_SHIFT',' UV_SORT',' UV_STACK',  ' UV_STAT',' UV_STOKES',&
         ' UV_TIME','/WEIGHT',' UV_TRUNCATE',&
         ' VIEW',&
         ' WRITE','/APPEND ','/RANGE','/REPLACE','/TRIM'/
    character(len=40) :: version
    version = '3.3-05 03-Jul-2017 S.Guilloteau, J.Pety'
    !
    call sic_begin('CLEAN','GAG_HELP_CLEAN',mclean,vocab,version,run_clean,gr_error)
    !
    user_method%do_mask = .true.  ! Unclear why ...
    call sic_def_logi('METHOD_DOMASK',user_method%do_mask,.false.,error) ! To check
    nullify(duvr)
    nullify(duvs)
    call define_var(error)
    call omp_define(error)
    if (error) return
    call uvmap_define(error)
    if (error) return
    MappingError = .false.
    call sic_def_logi('MAPPING_ERROR',MappingError,.false.,error)
    call sic_def_inte('MAP_VERSION',map_version,0,0,.false.,error)
  end subroutine init_clean
  !
  subroutine run_clean(line,comm,error)
    use mapping_dump
    use mapping_flux_scale
    use mapping_load
    use mapping_mosaic
    use mapping_primary
    use mapping_read
    use mapping_show_or_view
    use mapping_specify
    use mapping_statistics
    use mapping_support
    use mapping_write
    !
    use uv_baseline
    use uv_check
    use uv_continuum
    use uv_extract
    use uv_filter
    use uv_flag
    use uv_resample
    use uv_reweight
    use uv_rms
    use uv_sort_bis
    use uv_stack
    use uv_statistics
    use uv_stokes
    use uv_time
    use uv_truncate
    !
    use imaging_fit
    use uv_map
    use uv_residual
    use uv_restore
    use uv_shift
    !
    use clean_clark
    use clean_clean
    use clean_hogbom
    use clean_mfs
    use clean_mrc
    use clean_multi
    use clean_sdi
    use clean_arrays
    use mapping_default_types
    !----------------------------------------------------------------------
    ! Call appropriate subroutine according to COMM
    !----------------------------------------------------------------------
    character(len=*), intent(inout) :: line
    character(len=*), intent(in)    :: comm
    logical,          intent(out)   :: error
    !
    ! Local variables
    integer, save :: icall=0
    integer :: i
    !
    if (icall.ne.0) then
       print *,'Rentrant call to RUN_CLEAN ',comm
       read(5,*) i
    endif
    icall = icall+1
    !
    call map_message(seve%c,'CLEAN',line)
    !
    ! Analyze command
    select case (comm)
       !
       ! Administration commands by alphabetical order
       !
    case ('DUMP')
       call dump_comm(line,error)
    case ('FLUX_SCALE')
       call flux_scale_comm(line,error)
    case ('LOAD')
       call load_comm(line,error)
    case ('MAP_RESAMPLE','MAP_COMPRESS','MAP_INTEGRATE') 
       call map_resample_comm(line,comm,error)
    case ('MOSAIC')
       call mosaic_comm(line,error)
    case ('PRIMARY') !***JP: unclear position
       call primary_comm(line,error)
    case ('READ')
       call read_comm(line,error)
    case ('SPECIFY')
       call specify_comm(line,error)
    case ('SHOW','VIEW')
       call show_or_view_comm(comm,line,error)
    case ('STATISTICS')
       call statistics_comm(line,error)
    case ('SUPPORT')
       call support_comm(line,error)
    case ('WRITE')
       call write_comm(line,error)
       !
       ! Commands working on UV tables by alphabetical order
       !
    case ('UV_BASELINE')
       call uv_baseline_comm(line,error)
    case ('UV_CHECK')
       call uv_check_comm(line,error)
    case ('UV_COMPRESS')
       call uv_resample_comm(line,comm,error)
    case ('UV_CONTINUUM')
       call uv_continuum_comm(line,error)
    case ('UV_EXTRACT')
       call uv_extract_comm(line,error)
    case ('UV_FILTER')
       call uv_filter_comm(line,error)
    case ('UV_FLAG')
       call uv_flag_comm(line,error)
    case ('UV_RESAMPLE')
       call uv_resample_comm(line,comm,error)
    case ('UV_REWEIGHT')
       call uv_reweight_comm(line,error)
    case ('UV_RMS')
       call uv_rms_comm(line,error)
    case ('UV_SHIFT')
       call uv_shift_comm(line,error)
    case ('UV_SORT')
       call uv_sort_comm(line,error)
    case ('UV_STACK')
       call uv_stack_comm(line,error)
    case ('UV_STAT')
       call uv_statistics_comm(line,error)
    case ('UV_STOKES')
       call uv_stokes_comm(line,error)       
    case ('UV_TIME')
       if (themap%nfields.ne.0) call map_message(seve%w,comm,'UV data is a Mosaic')
       call uv_time_comm(line,error)
    case ('UV_TRUNCATE')
       call uv_truncate_comm(line,error)
       !
       ! Imaging commands by alphabetical order
       !
    case ('FIT')
       call fit_comm(line,error)
    case ('UV_MAP')
       if (themap%nfields.ne.0) then
          call map_message(seve%i,'UV_MOSAIC','UV data is a Mosaic')
          call uv_shift_comm(line,error)
          call mosaic_uvmap('UV_MOSAIC',line,error)
       else if (map_version.ne.0) then
          ! Old or intermediate version
          call uvmap('OLDUV_MAP',line,error)
       else
          ! New version
          call uvmap_comm('UV_MAP',line,error)
       endif
    case ('UV_RESIDUAL')
       if (themap%nfields.ne.0) then
          call map_message(seve%w,comm,'UV data is a Mosaic - UNDER TESTS !!!')
       endif
       call uv_residual_comm(line,error)
    case ('UV_RESTORE')
       if (themap%nfields.ne.0) then
          call map_message(seve%w,comm,'UV data is a Mosaic, under test...')
          call mosaic_restore(line,error)
       else
          call uvmap_comm('UV_RESTORE',line,error)
       endif
       !
       ! Deconvolution commands by alphabetical order
       !
    case ('ALMA')
       call alma_clean(line,error)
    case ('CLARK')
       call clark_comm(line,error)
    case ('CLEAN')
       call clean_comm(line,error)
    case ('HOGBOM')
       call hogbom_comm(line,error)
    case ('MFS')
       call mfs_comm(line,error)
    case ('MRC')
       call mrc_comm(line,error)
    case ('MULTI')
       call multi_comm(line,error)
    case ('MX')
       if (themap%nfields.ne.0) then
          call map_message(seve%e,comm,'UV data is a Mosaic, not supported')
          error = .true.
       else
          call uvmap('MX',line,error)
       endif
    case ('SDI')
       call sdi_comm(line,error)
    case default
       call map_message(seve%i,'CLEAN',comm//' not yet implemented')
    end select
    icall = icall-1
  end subroutine run_clean
end module clean_language
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
