!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module clean_clark
  use gbl_message
  !
  public :: clark_comm
  private
  !
contains
  !
  subroutine clark_comm(line,error)
    use gkernel_interfaces
    use mapping_interfaces
    use clean_def
    use clean_arrays
    !----------------------------------------------------------------------
    ! Implementation of Barry Clark Clean
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    integer :: iv,na
    character(len=8) :: name,argum,voc1(2)
    data voc1/'CLEAN','RESIDUAL'/
    !
    ! Data checkup
    user_method%method = 'CLARK'
    call clean_data(error)
    if (error) return
    !
    ! Parameter Definitions
    call beam_unit_conversion(user_method)
    call copy_method(user_method,method)
    method%pflux = sic_present(1,0)
    method%pcycle = sic_present(2,0)
    method%qcycle = sic_present(3,0)
    if (method%pcycle) then
       argum = 'RESIDUAL'
       call sic_ke(line,2,1,argum,na,.false.,error)
       if (error) return
       call sic_ambigs('PLOT',argum,name,iv,voc1,2,error)
       if (error) return
       method%pclean = iv.eq.1
    else
       method%pclean = .false.
    endif
    call sub_clean(line,error)
  end subroutine clark_comm
end module clean_clark
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
