!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubecompute_amplitude
  use cubetemplate_visi2image_template
  use cubecompute_messaging  
  !
  public :: amplitude
  private
  !
  type, extends(visi2image_comm_t) :: amplitude_comm_t
   contains
     procedure, public  :: register => cubecompute_amplitude_register
  end type amplitude_comm_t
  type(amplitude_comm_t) :: amplitude
  !
  type, extends(visi2image_user_t) :: amplitude_user_t
  end type amplitude_user_t
  !
  type, extends(visi2image_prog_t) :: amplitude_prog_t
   contains
     procedure, private :: act => cubecompute_amplitude_prog_act
  end type amplitude_prog_t
  !
contains
  !
  subroutine cubecompute_amplitude_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(amplitude_user_t) :: user
    type(amplitude_prog_t) :: prog
    character(len=*), parameter :: rname='AMPLITUDE>COMMAND'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call amplitude%command(line,user,prog,error)
    if (error) return
  end subroutine cubecompute_amplitude_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubecompute_amplitude_register(comm,error)
    use cubetools_structure
    use cubedag_allflags
    use cubeadm_cubeid_types
    use cubeadm_cubeprod_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(amplitude_comm_t), intent(inout) :: comm
    logical,                 intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    type(cube_prod_t) :: cubeprod
    character(len=*), parameter :: comm_abstract='Compute the amplitude from a complex cube'
    character(len=*), parameter :: comm_help=strg_id
    character(len=*), parameter :: rname='AMPLITUDE>REGISTER'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'AMPLITUDE','[cubeid]',&
         comm_abstract,&
         comm_help,&
         cubecompute_amplitude_command,&
         comm%comm,&
         error)
    if (error) return
    call cubearg%register(&
         'CUBE',&
         'Input complex data',&
         strg_id,&
         code_arg_optional,&
         [flag_complex],& ! *** JP: should be flag_any but I should also have the opportunity to ask for a complex cube
         code_read,&
         code_access_imaset,&
         comm%incube,&
         error)
    if (error) return
    !
    ! Products
    call cubeprod%register(&
         'CUBE',&
         'Real amplitude cube',&
         strg_id,&
         [flag_amplitude],&
         comm%oucube,&
         error)
    if (error)  return
  end subroutine cubecompute_amplitude_register
  !
  subroutine cubecompute_amplitude_prog_act(prog,ie,visi,image,error)
    use cubetools_parameters
    use cubeadm_image_types
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(amplitude_prog_t), intent(inout) :: prog
    integer(kind=entr_k),    intent(in)    :: ie
    type(visi_t),            intent(inout) :: visi
    type(image_t),           intent(inout) :: image
    logical,                 intent(inout) :: error
    !
    integer(kind=pixe_k) :: ix,iy
    character(len=*), parameter :: rname='AMPLITUDE>PROG>ACT'
    !
    call visi%get(ie,error)
    if (error) return
    do iy=1,visi%ny
       do ix=1,visi%nx
          image%val(ix,iy) = abs(visi%val(ix,iy))
       enddo ! ix
    enddo ! iy
    call image%put(ie,error)
    if (error) return
  end subroutine cubecompute_amplitude_prog_act
end module cubecompute_amplitude
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
