module cubeadm_remove
  use cubetools_structure
  use cubedag_parameters
  use cubedag_allflags
  use cubetuple_format
  use cubeadm_cubeid_types
  use cubeadm_opened
  use cubeadm_messaging
  !
  public :: remove
  private
  !
  type :: remove_comm_t
    type(option_t),     pointer :: comm
    type(cubeid_arg_t), pointer :: node
  contains
    procedure, public  :: register => cubeadm_remove_register
    procedure, private :: parse    => cubeadm_remove_parse
    procedure, private :: main     => cubeadm_remove_main
  end type remove_comm_t
  type(remove_comm_t) :: remove
  !
  type remove_user_t
    type(cubeid_user_t) :: cubeids
  contains
    procedure, private :: toprog => cubeadm_remove_user_toprog
  end type remove_user_t
  !
  type remove_prog_t
    class(format_t), pointer :: node
  end type remove_prog_t
  !
contains
  !
  subroutine cubeadm_remove_command(line,error)
    !-------------------------------------------------------------------
    ! Support routine for command REMOVE
    !-------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(remove_user_t) :: user
    character(len=*), parameter :: rname='REMOVE>COMMAND'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call remove%parse(line,user,error)
    if (error) return
    call remove%main(user,error)
    if (error) return
  end subroutine cubeadm_remove_command
  !
  subroutine cubeadm_remove_register(remove,error)
    !-------------------------------------------------------------------
    ! Register ADM\REMOVE command and its options
    !-------------------------------------------------------------------
    class(remove_comm_t), intent(in)    :: remove
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: comm_help = strg_id
    type(cubeid_arg_t) :: cubearg
    character(len=*), parameter :: rname='REMOVE>REGISTER'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    ! Command
    call cubetools_register_command(&
         'REMOVE','[cube]',&
         'Remove a cube from the DAG',&
         comm_help,&
         cubeadm_remove_command,&
         remove%comm,error)
    if (error) return
    call cubearg%register( &
         'CUBE', &
         '[CubeID]',  &
         strg_id,&
         code_arg_optional,  &
         [flag_any], &
         code_read_none,&  ! Header not needed
         code_access_any,&
         remove%node,&
         error)
    if (error) return
  end subroutine cubeadm_remove_register
  !
  subroutine cubeadm_remove_parse(remove,line,user,error)
    use cubetools_disambiguate
    !-------------------------------------------------------------------
    ! Parsing facility for command
    !   REMOVE CubeID
    !-------------------------------------------------------------------
    class(remove_comm_t), intent(in)    :: remove
    character(len=*),     intent(in)    :: line
    type(remove_user_t),  intent(out)   :: user
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='REMOVE>PARSE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,remove%comm,user%cubeids,error)
    if (error) return
  end subroutine cubeadm_remove_parse
  !
  subroutine cubeadm_remove_main(remove,user,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(remove_comm_t), intent(in)    :: remove
    type(remove_user_t),  intent(in)    :: user
    logical,              intent(inout) :: error
    !
    type(remove_prog_t) :: prog
    character(len=*), parameter :: rname='REMOVE>MAIN'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call user%toprog(remove,prog,error)
    if (error) return
    call cubeadm_remove_node(prog,error)
    if (error) return
  end subroutine cubeadm_remove_main
  !
  !---------------------------------------------------------------------
  !
  subroutine cubeadm_remove_user_toprog(user,comm,prog,error)
    use cubeadm_get
    !-------------------------------------------------------------------
    ! 
    !-------------------------------------------------------------------
    class(remove_user_t), intent(in)    :: user
    type(remove_comm_t),  intent(in)    :: comm
    type(remove_prog_t),  intent(out)   :: prog
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='REMOVE>USER>TOPROG'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    ! Note that we use the get_header API in order to get the pointer
    ! to the node, but we do not can the header thanks to the code_read_none
    call cubeadm_get_fheader(remove%node,user%cubeids,prog%node,error)
    if (error) return
  end subroutine cubeadm_remove_user_toprog
  !
  subroutine cubeadm_remove_node(prog,error)
    use cubedag_history
    use cubedag_node_type
    use cubedag_dag
    !-------------------------------------------------------------------
    ! 
    !-------------------------------------------------------------------
    type(remove_prog_t), intent(out)   :: prog
    logical,             intent(inout) :: error
    !
    class(cubedag_node_object_t), pointer :: dno
    character(len=*), parameter :: rname='REMOVE>CUBE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    ! Unreference this node from the opened ones: since we will destroy
    ! it right below, the 'opened' module can't do anything with it.
    dno => prog%node
    call cubeadm_parents_children_pop(dno,error)
    if (error) return
    ! Unreference from history
    call cubedag_history_removenode(prog%node%get_id(),error)
    if (error) return
    ! Remove it from DAG
    call cubedag_dag_removenode(prog%node%get_id(),error)
    if (error) return
  end subroutine cubeadm_remove_node
end module cubeadm_remove
