!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module imaging_fit
  use gbl_message
  !
  public :: fit_comm
  private
  !
contains
  !  
  subroutine fit_comm(line,error)
    use gkernel_interfaces
    use mapping_interfaces, only: beam_for_channel,get_clean
    use clean_def
    use clean_arrays
    !---------------------------------------------------------------------------
    ! Support routine for command FIT [ifield]
    !---------------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    integer(kind=4) :: ifield
    character(len=message_length) :: chain
    character(len=*), parameter :: rname = 'FIT'
    !
    if (hbeam%loca%size.eq.0) then
       call map_message(seve%e,rname,'No Dirty Beam')
       error = .true.
       return
    endif
    method%ibeam = beam_for_channel(method%iplane,hdirty,hbeam)
    ifield = 1
    call sic_i4(line,0,1,ifield,.false.,error)
    if (error) return
    ifield = min(hbeam%gil%dim(3),max(1,ifield))
    if (hbeam%gil%dim(3).gt.1) then
       write(chain,'(A,I4,A,I4)') 'Fitting beam # ',ifield,' /',hbeam%gil%dim(3)
       call map_message(seve%i,rname,chain)
    endif
    if (hbeam%gil%dim(4).gt.1) then
       write(chain,'(A,I4,A,I4)') 'Fitting plane # ',method%ibeam,' /',hbeam%gil%dim(4)
       call map_message(seve%i,rname,chain)
    endif
    method%major = 0.0
    method%minor = 0.0
    method%angle = 0.0
    method%thresh = 0.30
    call sic_get_real('THRESHOLD',method%thresh,error)
    !
    call get_clean(method,hbeam,dbeam(:,:,ifield,method%ibeam),error)
  end subroutine fit_comm
end module imaging_fit
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
