!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module clean_mrc
  use gbl_message
  !
  public :: mrc_comm
  private
  !
contains
  !
  subroutine mrc_comm(line,error)
    use gkernel_interfaces
    use mapping_interfaces    
    use clean_def
    use clean_arrays
    !----------------------------------------------------------------------
    ! Implementation of Multi Resolution Clean
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    integer :: ratio,nx,ny
    character(len=3) :: rname='MRC'
    !
    if (user_method%mosaic) then
       call map_message(seve%e,rname,'Not valid for mosaic')
       error = .true.
       return
    endif
    !
    ! Data checkup
    user_method%method = 'MRC'
    call clean_data (error)
    if (error) return
    !
    ! Parameter Definitions
    call beam_unit_conversion(user_method)
    call copy_method(user_method,method)
    !
    ! Smoothing ratio : given by user or 2, 4 or 8 according to image size
    if (method%ratio.ne.0) then
       ratio = method%ratio
       if (power_of_two(ratio).eq.-1) then
          call map_message(seve%e,rname,'Smoothing ratio has to be a power of 2')
          error = .true.
          return
       endif
    else
       nx = hdirty%gil%dim(1)
       ny = hdirty%gil%dim(2)
       if (nx*ny.gt.512*512) then
          ratio = 8
       elseif (nx*ny.gt.128*128) then
          ratio = 4
       else
          ratio = 2
       endif
    endif
    method%ratio = ratio
    method%pflux = sic_present(1,0)
    method%pcycle = sic_present(2,0)
    method%qcycle = .false.
    !
    call sub_clean(line,error)
    user_method%do_mask = .true. ! important sinon CLARK ne marche plus
  end subroutine mrc_comm
end module clean_mrc
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
