module cubefit_parameters
  use cubetools_parameters
  use cubefit_messaging
  !
  ! Kind parameters
  integer(kind=4),  parameter :: para_k = 8
  integer(kind=4),  parameter :: npar_k = 4
  integer(kind=4),  parameter :: grad_k = 8
  integer(kind=4),  parameter :: line_k = 4
  integer(kind=4),  parameter :: chi2_k = 8
  integer(kind=4),  parameter :: flag_k = 4
  !
  ! Miscelania
  character(len=*), parameter :: strg_add = '+' ! Track that unit is to be added
  !
  ! Length parameters
  integer(kind=4),  parameter :: meth_l = 12
  !
  ! Minuit flags
  integer(kind=4), parameter :: minuit_com_flag = 1  ! Tell function to compute Values
  integer(kind=4), parameter :: minuit_rms_flag = 3  ! Tell function to compute RMS
  integer(kind=4), parameter :: minuit_gra_flag = 2  ! Tell function to compute Gradients
  !
  ! Convergence codes
  integer(kind=code_k), parameter :: code_converged =  1
  integer(kind=code_k), parameter :: code_diverged  = -1
  integer(kind=code_k), parameter :: code_not_fitted =  0  
  !
  ! Spectral data format
  integer(kind=chan_k), parameter :: spec_ndaps    = 5 ! Number of preceeding info before fit results in output
  integer(kind=line_k), parameter :: mline    = 10 ! Maximum number of functions
  integer(kind=npar_k), parameter :: mparline = 4  ! Maximum number of parameters per function
  integer(kind=chan_k), parameter :: istatus  = 1
  integer(kind=chan_k), parameter :: imethod  = 2
  integer(kind=chan_k), parameter :: inline   = 3
  integer(kind=chan_k), parameter :: isigbase = 4
  integer(kind=chan_k), parameter :: isigline = 5
  !
  ! Spectral Minimization methods
  integer(kind=4),  parameter :: spec_nmeth = 7
  character(len=*), parameter :: spec_meth(spec_nmeth)  = ["GAUSS     ","NH3(1,1)  ",&
       "NH3(2,2)  ","NH3(3,3)  ","HFS       ","ABSORPTION","SHELL     "]
  !
  integer(kind=code_k), parameter :: igaussian   = 1
  integer(kind=code_k), parameter :: inh31       = 2
  integer(kind=code_k), parameter :: inh32       = 3
  integer(kind=code_k), parameter :: inh33       = 4
  integer(kind=code_k), parameter :: ihfs        = 5
  integer(kind=code_k), parameter :: iabsorption = 6
  integer(kind=code_k), parameter :: ishell      = 7
  !
  integer(kind=code_k), parameter :: code_all_meth = 0
  !
contains
  !
  subroutine cubefit_line2flag(iline,flag,error)
    use cubedag_allflags
    !-------------------------------------------------------------------
    ! Return the proper flag for line #iline
    !-------------------------------------------------------------------
    integer(kind=line_k), intent(in)    :: iline
    type(flag_t),         intent(out)   :: flag
    logical,              intent(inout) :: error
    ! Local
    character(len=*), parameter :: rname='LINE2FLAG'
    !
    select case (iline)
    case (1)
      flag = flag_one
    case (2)
      flag = flag_two
    case (3)
      flag = flag_three
    case (4)
      flag = flag_four
    case (5)
      flag = flag_five
    case (6)
      flag = flag_six
    case (7)
      flag = flag_seven
    case (8)
      flag = flag_eight
    case (9)
      flag = flag_nine
    case (10)
      flag = flag_ten
    case default
      call cubefit_message(seve%e,rname,'Line number not supported')
      error = .true.
      return
    end select
  end subroutine cubefit_line2flag
  !
  subroutine cubefit_flag2line(flag,iline,error)
    use cubedag_allflags
    !-------------------------------------------------------------------
    ! Return the proper line number for given flag
    !-------------------------------------------------------------------
    type(flag_t),         intent(in)    :: flag
    integer(kind=line_k), intent(out)   :: iline
    logical,              intent(inout) :: error
    ! Local
    character(len=*), parameter :: rname='FLAG2LINE'
    !
    if (flag.eq.flag_one) then
      iline = 1
    elseif (flag.eq.flag_two) then
      iline = 2
    elseif (flag.eq.flag_three) then
      iline = 3
    elseif (flag.eq.flag_four) then
      iline = 4
    elseif (flag.eq.flag_five) then
      iline = 5
    elseif (flag.eq.flag_six) then
      iline = 6
    elseif (flag.eq.flag_seven) then
      iline = 7
    elseif (flag.eq.flag_eight) then
      iline = 8
    elseif (flag.eq.flag_nine) then
      iline = 9
    elseif (flag.eq.flag_ten) then
      iline = 10
    else
      iline = 0
      call cubefit_message(seve%e,rname,'Flag is not a line flag')
      error = .true.
      return
    endif
  end subroutine cubefit_flag2line
  !
end module cubefit_parameters
