subroutine get_gildas(rname,cinp,desc,hin,error)
  use gkernel_types
  use gkernel_interfaces
  use gbl_message
  !---------------------------------------------------------------------
  ! IMAGER
  ! @ public
  !   General tool to incarnate the SIC variable into a Gildas 
  !   derived type Fortran variable
  ! 
  !---------------------------------------------------------------------
  character(len=*), intent(in) :: rname         ! Input caller name
  character(len=*), intent(in) :: cinp          ! Input variable name
  type(sic_descriptor_t), intent(out) :: desc   ! Descriptor
  type(gildas), intent(inout) :: hin            ! Gildas header 
  logical, intent(inout) :: error               ! Error flag 
  !
  logical :: found
  !
  ! Look at the SIC variable
  call sic_descriptor(cinp,desc,found)  
  if (.not.found) then
    call map_message(seve%e,rname,'No such SIC variable '//cinp)
    error = .true.
    return
  endif
  !
  ! If the descriptor is here, copy the Header in HIN
  if (.not.associated(desc%head)) then
    call map_message(seve%w,rname,  &
      'Variable '//trim(cinp)//' does not provide a header')
    error = .true.
    return
  endif
  !
  ! Locate the header - data area is given by desc%addr
  if (abs(desc%head%gil%type_gdf).eq.abs(code_gdf_uvt)) then
    call gildas_null(hin,type='UVT')
  else
    call gildas_null(hin)
  endif
  call gdf_copy_header(desc%head,hin,error)
end subroutine get_gildas
!
subroutine extract_comm(line,error)
  use image_def
  use gkernel_interfaces
  use gkernel_types
  use gbl_message
  !---------------------------------------------------------------------
  ! IMAGER
  ! @ private  
  !   Support for command EXTRACT Name BLC TRC
  !	  Extract a subset from an input n-Dim image (n<4) 
  !---------------------------------------------------------------------
  character(len=*), intent(in) :: line
  logical, intent(out) :: error
  !
  include 'gbl_memory.inc'
  character(len=*), parameter :: rname='EXTRACT'
  ! Local
  integer :: i, ier, nc
  integer(kind=index_length) :: iblc(4),itrc(4),iout(4),pin(4)
  integer(kind=index_length) :: oblc(4),otrc(4),pout(4)
  integer(kind=address_length) :: ipnt
  character(len=80) :: cinp
  type(sic_descriptor_t) :: desc
  type(gildas) :: hin
  type(gildas), save :: hou
  real, allocatable, save, target :: extract_data(:,:,:,:)
  !
  ! Input 3-D array
  ! Locate the header and data area
  call sic_ch(line,0,1,cinp,nc,.true.,error)
  if (error) return
  call get_gildas(rname,cinp,desc,hin,error)
  if (error) return
  call gdf_copy_header(desc%head,hin,error)
  if (error) return
  !
  iblc = 1
  call sic_i4(line,0,2,i,.true.,error)
  iblc(1) = i
  call sic_i4(line,0,3,i,.true.,error)
  iblc(2) = i
  call sic_i4(line,0,4,i,.true.,error)
  iblc(3) = i
  itrc = 1
  call sic_i4(line,0,5,i,.true.,error)
  itrc(1) = i
  call sic_i4(line,0,6,i,.true.,error)
  itrc(2) = i
  call sic_i4(line,0,7,i,.true.,error)
  itrc(3) = i
  if (error) return
  !
  if (allocated(extract_data)) then
    deallocate(extract_data)
    call sic_delvariable('EXTRACTED',.false.,error)
  endif
  !
  do i=1,4
    if (iblc(i).eq.0) then
      oblc(i) = 1
      iblc(i) = 1
    else
      oblc(i) = iblc(i)  ! No min-max
      iblc(i) = max(iblc(i),1)
    endif
    if (itrc(i).eq.0) then
      otrc(i) = hin%gil%dim(i)
      itrc(i) = hin%gil%dim(i)
    else
      otrc(i) = itrc(i)  ! No min-max
      itrc(i) = min(itrc(i),hin%gil%dim(i))
    endif
    if (iblc(i).gt.itrc(i)) then
      call map_message(seve%e,rname,'Invalid subset')
      error = .true.
      return
    endif
  enddo
  pin = iblc
  pout = 1
  !
  call gildas_null(hou)
  call gdf_copy_header(hin,hou,error)
  !
  ! IOUT is the place of bottom left corner (IBLC) in output image
  ! Then if PIN=IBLC, IOUT = POUT
  iout = pout-pin+iblc
  hou%gil%dim(1:4) = itrc-iblc+1
  !
  ! Create output image
  hou%gil%extr_words = 0
  !
  ! Put pixel IMIN,JMIN at IOUT of output image
  hou%gil%ref = hin%gil%ref + iout - iblc
  !
  allocate (extract_data(hou%gil%dim(1), hou%gil%dim(2), hou%gil%dim(3), hou%gil%dim(4)), stat=ier)
  if (ier.ne.0) then
    call map_message(seve%e,rname,'Output memory allocation error')
    error = .true.
    return
  endif
  !!
  !! hou%gil%eval = max(hou%gil%eval,0.0)
  hou%r4d => extract_data
  ipnt = gag_pointer(desc%addr,memory)
  call sub_extract (   &
   &      memory(ipnt),hin%gil%dim(1),hin%gil%dim(2),hin%gil%dim(3),hin%gil%dim(4),   &
   &      extract_data,hou%gil%dim(1),hou%gil%dim(2),hou%gil%dim(3),hou%gil%dim(4),   &
   &      iblc,itrc,iout,hou%gil%bval)
  !
  ! Post the result as a SIC Image variable
  if (hou%gil%ndim.eq.2) then
    call sic_mapgildas('EXTRACTED',hou,error,extract_data(:,:,1,1))
  else if (hou%gil%ndim.eq.3) then
    call sic_mapgildas('EXTRACTED',hou,error,extract_data(:,:,:,1))
  else if (hou%gil%ndim.eq.4) then
    call sic_mapgildas('EXTRACTED',hou,error,extract_data)
  endif
end subroutine extract_comm
!
subroutine slice_comm(line,error)
  use image_def
  use gkernel_interfaces
  use gkernel_types
  use gbl_message
  !---------------------------------------------------------------------
  ! IMAGER
  ! @ private  
  !   Support routine for command SLICE
  !
  !   Arbitrary slice in a 3-D data set, using bilinear interpolation
  !---------------------------------------------------------------------
  character(len=*), intent(in) :: line
  logical, intent(out) :: error
  ! Global
  include 'gbl_memory.inc'
  integer, external :: pix_axis
  character(len=*), parameter :: rname='SLICE'
  ! Local
  integer(kind=address_length) :: ipnt
  character(len=256) :: cinp
  integer :: nc
  !
  integer :: axe,ier
  real(4), allocatable :: lgu(:), mgu(:)
  integer :: istart(2), iend(2)
  integer :: npoints
  real(8) :: dstart(2), dend(2), dl, dm, dx, dy,ang
  real(8) :: user1,user2
  character(len=24) :: ra_start, dec_start, ra_end, dec_end
  real(8) :: ustart(2), uend(2)
  type(gildas) :: hin
  type(gildas), save :: hou
  type(sic_descriptor_t) :: desc
  real, allocatable, target, save :: slice_data(:,:)
  type(projection_t) :: proj
  integer :: itype
  character(len=8) :: unit_type(6), ctype, ktype
  data unit_type /'ABSOLUTE','SECONDS','MINUTES','DEGREES','RADIANS','PIXELS'/
  real(kind=8) :: angle_scale(6)
  real(kind=8), parameter :: pi=3.14159265358979323846d0
  !
  ! Code:
  call sic_ch(line,0,1,cinp,nc,.true.,error)
  if (error) return
  ctype = 'ABSOLUTE'
  call sic_ch(line,0,6,ctype,nc,.false.,error)
  call sic_ambigs(rname,ctype,ktype,itype,unit_type,6,error)
  angle_scale = [0.d0,pi/180d0/3600d0,pi/180d0/60d0,pi/180d0,1.d0,-1.d0]  
  !
  if (allocated(slice_data)) then
    call sic_delvariable('SLICE',.false.,error)
    deallocate (slice_data)
  endif
  call gildas_null(hou)
  !
  ! Incarnate the SIC variable into a local header
  call get_gildas(rname,cinp,desc,hin,error)
  if (error) return
  ipnt = gag_pointer(desc%addr,memory)
  !
  ! Prepare the output
  !
  call gwcs_projec(hin%gil%a0,hin%gil%d0,hin%gil%pang,hin%gil%ptyp,proj,error)
  if (error) return
  select case (ktype)
  case ('ABSOLUTE')
    call sic_ch(line,0,2,ra_start,nc,.true.,error)
    call sic_ch(line,0,3,dec_start,nc,.true.,error)
    call sic_ch(line,0,4,ra_end,nc,.true.,error)
    call sic_ch(line,0,5,dec_end,nc,.true.,error)
    if (error) return
    call sic_decode(ra_start,ustart(1),24,error)
    if (error) then
      call map_message(seve%e,rname,'Error in SIC_DECODE RA Start')
      return
    endif
    call sic_decode(dec_start,ustart(2),360,error)
    if (error) then
      call map_message(seve%e,rname,'Error in SIC_DECODE Dec Start')
      return
    endif
    call sic_decode(ra_end,uend(1),24,error)
    if (error) then
      call map_message(seve%e,rname,'Error in SIC_DECODE RA End')
      return
    endif
    call sic_decode(dec_end,uend(2),360,error)
    if (error) then
      call map_message(seve%e,rname,'Error in SIC_DECODE Dec End')
      return
    endif
    call abs_to_rel(proj,ustart(1), ustart(2), user1, user2, 1)
    istart(1) = pix_axis(hin,user1,1)
    istart(2) = pix_axis(hin,user2,2)
    call abs_to_rel(proj,uend(1), uend(2), user1, user2, 1)
    iend(1) = pix_axis(hin,user1,1)
    iend(2) = pix_axis(hin,user2,2)
  case ('PIXELS')
    call sic_i4(line,0,2,istart(1),.true.,error)
    call sic_i4(line,0,3,istart(2),.true.,error)
    call sic_i4(line,0,4,iend(1),.true.,error)
    call sic_i4(line,0,5,iend(2),.true.,error)
  case default
    call sic_r8(line,0,2,user1,.true.,error)
    call sic_r8(line,0,3,user2,.true.,error)
    user1 = user1*angle_scale(itype)
    user2 = user2*angle_scale(itype)
    istart(1) = pix_axis(hin,user1,1)
    istart(2) = pix_axis(hin,user2,2)
    call sic_r8(line,0,4,user1,.true.,error)
    call sic_r8(line,0,5,user2,.true.,error)
    user1 = user1*angle_scale(itype)
    user2 = user2*angle_scale(itype)
    iend(1) = pix_axis(hin,user1,1)
    iend(2) = pix_axis(hin,user2,2)
  end select
  !
  call gdf_copy_header(hin,hou,error)
  !
  dstart(1) = dble(istart(1))
  dstart(2) = dble(istart(2))
  dend(1) = dble(iend(1))
  dend(2) = dble(iend(2))
  !
  ! Define number of points
  if (dstart(1).eq.dend(1)) then
    axe = 2
    dx = 0.
    dy = 1.
    npoints = dabs(dend(2) - dstart(2)) + 1.
  elseif (dstart(2).eq.dend(2)) then
    axe = 1
    dx = 1.
    dy = 0.
    npoints = dabs(dend(1) - dstart(1)) + 1.
  else
    axe = 0
    dl = dabs(dend(1)-dstart(1)) + 1.
    dm = dabs(dend(2)-dstart(2)) + 1.
    npoints = sqrt(dl*dl + dm*dm)
    dx = dl/dble(npoints)
    dy = dm/dble(npoints)
    ang = atan2(dx*hin%gil%inc(1),dy*hin%gil%inc(2))
  endif
  !
  allocate (lgu(npoints), mgu(npoints), stat=ier)
  if (ier.ne.0) then
    call map_message(seve%e,rname,'Memory allocation error')
    error = .true.
    return
  endif
  if (dend(1).lt.dstart(1)) then
    dx = -dx
  endif
  if (dend(2).lt.dstart(2)) then
    dy = -dy
  endif
  !
  !     Allocate arrays for slice coordinates
  call fill_gu(lgu, dstart(1), dx, npoints)
  call fill_gu(mgu, dstart(2), dy, npoints)
  !
  ! Prepare the header
  hou%gil%dim(1) = npoints
  hou%gil%dim(2) = hin%gil%dim(3)
  hou%gil%dim(3) = 1
  hou%gil%ndim = 2
  hou%loca%size = hou%gil%dim(1)*hou%gil%dim(2)
  hou%char%code(2) = hin%char%code(3)
  hou%gil%yaxi = 3
  hou%gil%faxi = 2
  hou%char%code(3) = 'UNKNOWN'
  !
  hou%gil%convert(:,2) = hin%gil%convert(:,3)
  hou%gil%convert(1,1) = 1.D0
  hou%gil%convert(2,1) = 0.D0
  if (axe.ne.0) then
    hou%char%code(1) = hin%char%code(axe)
    hou%gil%inc(1) =  hin%gil%inc(axe)
    hou%gil%xaxi = hin%gil%xaxi
  else
    hou%char%code(1) = 'ANGLE'
    hou%gil%xaxi = 1
    hou%gil%pang = ang
    ! The pixel size is also different - pixels have orthogonal sides,
    ! and this is the hypotenuse of the right-angled triangle.
    hou%gil%inc(1) = sqrt((dx*hin%gil%inc(1))**2 + (dy*hin%gil%inc(2))**2)
  endif
  hou%gil%ref(1) = 1.
  hou%gil%val(1) = 0.
  hou%gil%extr_words = 0
  !
  user1 = (lgu(1)-hin%gil%ref(1))*hin%gil%inc(1) + hin%gil%val(1)
  user2 = (mgu(1)-hin%gil%ref(2))*hin%gil%inc(2) + hin%gil%val(2)
  call rel_to_abs(proj,user1, user2, hou%gil%a0, hou%gil%d0, 1)
  hou%gil%convert(:,3) = 1.0d0
  !
  ! Allocate the data
  allocate(slice_data(hou%gil%dim(1),hou%gil%dim(2)), stat=ier)
  if (ier.ne.0) then
    call map_message(seve%e,rname,'Output memory allocation error')
    error = .true.
    return
  endif
  hou%r2d => slice_data
  !
  ! Compute the slice
  call do_sliceb(memory(ipnt), hin%gil%dim(1), hin%gil%dim(2), hin%gil%dim(3),   &
   &      lgu, mgu,   &
   &      hou%r2d, npoints, hin%gil%bval, hin%gil%eval)
  hou%gil%eval = max(hin%gil%eval,0.)
  !
  ! Post the result as a SIC Image variable
  call sic_mapgildas('SLICE',hou,error,hou%r2d)
  !
end subroutine slice_comm
!
subroutine do_sliceb(in, nx, ny, nc, x, y, out, np, blank, eblank)
  use gildas_def
  integer(kind=index_length), intent(in) :: nx  ! Number of X pixels
  integer(kind=index_length), intent(in) :: ny  ! Number of Y pixels
  integer(kind=index_length), intent(in) :: nc  ! Number of channels
  real, intent(in) :: in(nx,ny,nc)              ! Input cube
  integer :: np                                 ! Number of points
  real, intent(in) :: x(np)                     ! X coordinates
  real, intent(in) :: y(np)                     ! Y coordinates
  real, intent(out) :: out(np,nc)               ! Output slice
  real, intent(in) :: blank                     ! Blanking
  real, intent(in) :: eblank                    ! and tolerance
  ! Local
  real :: dx,dy,coeff(4)
  integer :: ic,n,i,j
  !
  if (eblank.lt.0.) then
    do n=1,np
      i = int(x(n))
      j = int(y(n))
      dx = x(n) - float(i)
      dy = y(n) - float(j)
      if((i.lt.1).or.(j.lt.1).or.(i.ge.nx).or.(j.ge.ny))then
        !              Interpolated point outside input image
        out(n, 1:nc) = blank
      else
        do ic=1,nc
              out(n,ic) = dx * dy * in(i+1, j+1, ic)   &
           &          + (1.0 - dx) * dy * in(i, j+1, ic)   &
           &          + (1.0 - dx) * (1.0 - dy) * in(i, j, ic)   &
           &          + dx * (1.0 - dy) * in(i+1, j, ic)
        enddo
      endif
    enddo
  else  
    do n=1,np
      i = int(x(n))
      j = int(y(n))
      dx = x(n) - float(i)
      dy = y(n) - float(j)
      if((i.lt.1).or.(j.lt.1).or.(i.ge.nx).or.(j.ge.ny))then
        !             Interpolated point outside input image
        out(n, 1:nc) = blank
      else
        do ic=1,nc
          coeff = 1.0
          if (abs(in(i, j, ic)-blank).ge.eblank) then
            if ((dx.le.0.5).and.(dy.le.0.5)) then
              out(n, ic) = blank
            else
              coeff(1) = 0.
            endif
          endif
          if (abs(in(i+1, j, ic)-blank).ge.eblank) then
            if ((dx.gt.0.5).and.(dy.le.0.5)) then
              out(n, ic) = blank
            else
              coeff(2) = 0.
            endif
          endif
          if (abs(in(i, j+1, ic)-blank).ge.eblank) then
            if ((dx.le.0.5).and.(dy.gt.0.5)) then
              out(n, ic) = blank
            else
              coeff(3) = 0.
            endif
          endif
          if (abs(in(i+1, j+1, ic)-blank).ge.eblank) then
            if ((dx.gt.0.5).and.(dy.gt.0.5)) then
              out(n, ic) = blank
            else
              coeff(4) = 0.
            endif
          endif
          out(n,ic) =   &
       &          (1.0 - dx) * (1.0 - dy) * coeff(1) * in(i, j, ic)   &
       &          + dx * (1.0 - dy) * coeff(2) * in(i+1, j, ic)   &
       &          + (1.0 - dx) * dy * coeff(3) * in(i, j+1, ic)   &
       &          + dx * dy * coeff(4) * in(i+1, j+1, ic)
        enddo
      endif
    enddo
  endif
end subroutine do_sliceb
!
subroutine fill_gu(ipgu, ds, dt, np)
  integer, intent(in) :: np                      ! Number of points
  real, intent(out) :: ipgu(np)                  ! Output grid
  real(8), intent(in) :: ds                      ! Starting value
  real(8), intent(in) :: dt                      ! Step
  ! Local
  integer :: n
  real(8) :: t
  !
  t = ds
  do n=1,np
    ipgu(n) = t
    t = t + dt
  enddo
end subroutine fill_gu
!
function pix_axis (head, user, iaxis)
  use image_def
  real(8), intent(in) :: user       ! User coordinates
  type(gildas), intent(in) :: head  ! Image header
  integer, intent(in) :: iaxis      ! Axis
  integer :: pix_axis ! intent(out) ! corresponding pixel 
  !
  ! Test error...
  if ((iaxis.lt.1).or.(iaxis.gt.gdf_maxdims)) then
    pix_axis = 0
  else
    pix_axis = nint( (user - head%gil%val(iaxis)) /  &
        head%gil%inc(iaxis) + head%gil%ref(iaxis) )
  endif
end function pix_axis
!
!
subroutine sub_extract(a,na1,na2,na3,na4,   &
     &    b,nb1,nb2,nb3,nb4,ni,nu,np,blank)
  use gildas_def
  integer(kind=index_length) :: na1                    !
  integer(kind=index_length) :: na2                    !
  integer(kind=index_length) :: na3                    !
  integer(kind=index_length) :: na4                    !
  real, intent(in) :: a(na1,na2,na3,na4)               !
  integer(kind=index_length) :: nb1                    !
  integer(kind=index_length) :: nb2                    !
  integer(kind=index_length) :: nb3                    !
  integer(kind=index_length) :: nb4                    !
  real, intent(inout) :: b(nb1,nb2,nb3,nb4)            !
  integer(kind=index_length) :: ni(4)                  !
  integer(kind=index_length) :: nu(4)                  !
  integer(kind=index_length) :: np(4)                  !
  real, intent(in) :: blank                            !
  ! Local
  integer :: ia,ja,ka,la, ib,jb,kb,lb
  !
  do lb=1,nb4
    la = lb+ni(4)-np(4)
    if (la.ge.ni(4) .and. la.le.nu(4)) then
      do kb=1,nb3
        ka = kb+ni(3)-np(3)
        if (ka.ge.ni(3) .and. ka.le.nu(3)) then
          do jb=1,nb2
            ja = jb+ni(2)-np(2)
            if (ja.ge.ni(2) .and. ja.le.nu(2)) then
              do ib=1,nb1
                ia = ib+ni(1)-np(1)
                if (ia.ge.ni(1) .and. ia.le.nu(1)) then
                  b(ib,jb,kb,lb) = a(ia,ja,ka,la)
                else
                  b(ib,jb,kb,lb) = blank
                endif
              enddo
            else
              do ib=1,nb1
                b(ib,jb,kb,lb) = blank
              enddo
            endif
          enddo
        else
          do jb=1,nb2
            do ib=1,nb1
              b(ib,jb,kb,lb) = blank
            enddo
          enddo
        endif
      enddo
    else
      do kb=1,nb3
        do jb=1,nb2
          do ib=1,nb1
            b(ib,jb,kb,lb) = blank
          enddo
        enddo
      enddo
    endif
  enddo
end subroutine sub_extract 
!
