!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubecompute_product
  use cubecompute_two2one_template
  use cubecompute_messaging
  !
  public :: cubecompute_product_register
  private
  !
  type(two2one_comm_t) :: product
  !
contains
  !
  subroutine cubecompute_product_register(error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    logical, intent(inout) :: error
    !
    character(len=*), parameter :: rname='PRODUCT>REGISTER'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call product%register_syntax(&
         'PRODUCT','factor1','factor2',&
         [flag_product],cubecompute_product_command,error)
    if (error) return
    call product%act%register_r4r4(cubecompute_product_prog_act_r4r4,error)
    if (error) return
    call product%act%register_r4c4(cubecompute_product_prog_act_r4c4,error)
    if (error) return
    call product%act%register_c4r4(cubecompute_product_prog_act_c4r4,error)
    if (error) return
    call product%act%register_c4c4(cubecompute_product_prog_act_c4c4,error)
    if (error) return
  end subroutine cubecompute_product_register
  !
  subroutine cubecompute_product_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(two2one_user_t) :: user
    character(len=*), parameter :: rname='PRODUCT>COMMAND'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call product%parse(line,user,error)
    if (error) return
    call product%main(user,error)
    if (error) continue
  end subroutine cubecompute_product_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubecompute_product_prog_act_r4r4(ie,factor1,factor2,product,error)
    use cubetools_parameters
    use cubeadm_image_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: ie
    type(image_t),        intent(inout) :: factor1
    type(image_t),        intent(inout) :: factor2
    type(image_t),        intent(inout) :: product
    logical,              intent(inout) :: error
    !
    integer(kind=pixe_k) :: ix,iy
    character(len=*), parameter :: rname='PRODUCT>PROG>ACT>R4R4'
    !
    call factor1%get(ie,error)
    if (error) return
    call factor2%get(ie,error)
    if (error) return
    do iy=1,product%ny
       do ix=1,product%nx
          product%val(ix,iy) = factor1%val(ix,iy)*factor2%val(ix,iy)
       enddo ! ix
    enddo ! iy
    call product%put(ie,error)
    if (error) return
  end subroutine cubecompute_product_prog_act_r4r4
  !
  subroutine cubecompute_product_prog_act_r4c4(ie,factor1,factor2,product,error)
    use cubetools_parameters
    use cubeadm_image_types
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: ie
    type(image_t),        intent(inout) :: factor1
    type(visi_t),         intent(inout) :: factor2
    type(visi_t),         intent(inout) :: product
    logical,              intent(inout) :: error
    !
    integer(kind=pixe_k) :: ix,iy
    character(len=*), parameter :: rname='PRODUCT>PROG>ACT>R4C4'
    !
    call factor1%get(ie,error)
    if (error) return
    call factor2%get(ie,error)
    if (error) return
    do iy=1,product%ny
       do ix=1,product%nx
          product%val(ix,iy) = factor1%val(ix,iy)*factor2%val(ix,iy)
       enddo ! ix
    enddo ! iy
    call product%put(ie,error)
    if (error) return
  end subroutine cubecompute_product_prog_act_r4c4
  !
  subroutine cubecompute_product_prog_act_c4r4(ie,factor1,factor2,product,error)
    use cubetools_parameters
    use cubeadm_image_types
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: ie
    type(visi_t),         intent(inout) :: factor1
    type(image_t),        intent(inout) :: factor2
    type(visi_t),         intent(inout) :: product
    logical,              intent(inout) :: error
    !
    integer(kind=pixe_k) :: ix,iy
    character(len=*), parameter :: rname='PRODUCT>PROG>ACT>C4R4'
    !
    call factor1%get(ie,error)
    if (error) return
    call factor2%get(ie,error)
    if (error) return
    do iy=1,product%ny
       do ix=1,product%nx
          product%val(ix,iy) = factor1%val(ix,iy)*factor2%val(ix,iy)
       enddo ! ix
    enddo ! iy
    call product%put(ie,error)
    if (error) return
  end subroutine cubecompute_product_prog_act_c4r4
  !
  subroutine cubecompute_product_prog_act_c4c4(ie,factor1,factor2,product,error)
    use cubetools_parameters
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: ie
    type(visi_t),         intent(inout) :: factor1
    type(visi_t),         intent(inout) :: factor2
    type(visi_t),         intent(inout) :: product
    logical,              intent(inout) :: error
    !
    integer(kind=pixe_k) :: ix,iy
    character(len=*), parameter :: rname='PRODUCT>PROG>ACT>C4C4'
    !
    call factor1%get(ie,error)
    if (error) return
    call factor2%get(ie,error)
    if (error) return
    do iy=1,product%ny
       do ix=1,product%nx
          product%val(ix,iy) = factor1%val(ix,iy)*factor2%val(ix,iy)
       enddo ! ix
    enddo ! iy
    call product%put(ie,error)
    if (error) return
  end subroutine cubecompute_product_prog_act_c4c4
end module cubecompute_product
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
