!
!     $Id: modulePakoGlobalVariables.f90,v 1.2 2005/06/22 14:46:29 ungerech Exp $
!     
!----------------------------------------------------------------------
!     PAKO 
!
! <DOCUMENTATION name="moduleGlobalVariables">
!
! 
! 
!
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
!
! 
!
! </DOCUMENTATION> <!-- name="moduleGlobalVariables" -->
!
Module modulePakoGlobalVariables
  !
  Use modulePakoMessages
  Use modulePakoLimits
  Use modulePakoUtilities
  Use modulePakoXML
  Use modulePakoDisplayText
  Use modulePakoGlobalParameters 
!!$  Use modulePakoGlobalParameters -- careful: linked to ifc 70 internal error
  !
  Implicit None
  Save
  Private
  !
  Public :: GVsourceCatalog, GVlineCatalog
  !
  Public :: GVtype,                 GV
  Public :: pointingCorrectionType, GVpCorr
  Public :: focusCorrectionType,    GVfCorr
  !
  Public :: pakoSet
  Public :: pakoShow
!!$  Public :: pakoSaveSet
  Public :: writeXMLset
  !
  Include 'inc/parameters/sizes2.inc'
  !
  Integer, Parameter ::             nDimCatalog  = 1
  Character(len=lenVar), Dimension (nDimCatalog) :: GVsourceCatalog = GPnone2
  Character(len=lenVar), Dimension (nDimCatalog) :: GVlineCatalog   = GPnone2
  !
  Type :: GVtype
     !
     Real(Kind=4)                ::  tRecord                  =  GPnone2R4
     Character(len=lenCh2)        ::  project                  =  GPnone2
     Character(len=lenCh2)        ::  PI                       =  GPnone2
     Character(len=lenCh2)        ::  observer                 =  GPnone2
     Character(len=lenCh2)        ::  oper                     =  GPnone2
     !
     Character(len=lenCh2)        ::  topology                 =  GPnone2
     !
     Integer                     ::  iPstdio                  =  GPnone2I   ! message priority
     Integer                     ::  iPfile                   =  GPnone2I       
     !
     Character(len=lenCh2)        ::  sessionMode              =  GPnone2   ! e.g., to flag VLBI session 
     Character(len=lenCh2)        ::  observingMode            =  GPnone2
     Character(len=lenCh2)        ::  switchingMode            =  GPnone2
     !
     Real(Kind=4), Dimension(2)  ::  wOffset                  =  GPnone2I   ! wobbler offsets
     !
     !     angle unit specified by user with command: SET angleUnit 
     Integer                      ::  iAU                      =  iarcsec
     Character(len=lenCh2)        ::  angleUnitSetC            =  au%arcsec
     Real(Kind=8)                ::  angleUnitSet             =     arcsec
     Character(len=lenCh2)        ::  speedUnitSetC            =  su%arcsec
     Real(Kind=8)                ::  speedUnitSet             =     arcsec
     !
     !     angle unit in which angles are stored internally
     Character(len=lenCh2)        ::  angleUnitC               =  au%arcsec
     Real(Kind=8)                ::  angleUnit                =     arcsec
     Character(len=lenCh2)        ::  speedUnitC               =  su%arcsec
     Real(Kind=8)                ::  speedUnit                =     arcsec
     !
     !     factors to convert from SET units to stored values
     Real(Kind=8)                ::  angleFactorD             = 1.0
     Real(Kind=4)                ::  angleFactorR             = 1.0
     !
     Real(Kind=8)                ::  speedFactorD             = 1.0
     Real(Kind=4)                ::  speedFactorR             = 1.0
     !
     !     frequency unit in which resolution, bandwidth, etc.
     !     are stored internally
     Character(len=lenCh2)        ::  frequencyUnitC           =  "MHz"
     Real(Kind=8)                ::  frequencyUnit            =   MHz
     !
  End Type GVtype
  Type (GVtype)  ::  GV
  !
  Type :: pointingCorrectionType
     Real(Kind=4)                ::  azimuth                  =  GPnone2R4
     Real(Kind=4)                ::  elevation                =  GPnone2R4
     Real(Kind=4), Dimension(10) ::  pointingP                =  GPnone2R4
     Real(Kind=4)                ::  azimuthCorrection        =  GPnone2R4
     Real(Kind=4)                ::  azimuthCorrectionError   =  GPnone2R4
     Real(Kind=4)                ::  elevationCorrection      =  GPnone2R4
     Real(Kind=4)                ::  elevationCorrectionError =  GPnone2R4
  End Type pointingCorrectionType
  Type (pointingCorrectionType)  ::  pCorr
  Type (pointingCorrectionType)  ::  GVpCorr
  Type (pointingCorrectionType)  ::  pCorrDefault
  Namelist / pCorrNML / pCorr
  !
  Type :: focusCorrectionType
     Real(Kind=4)                ::  azimuth                  =  GPnone2R4
     Real(Kind=4)                ::  elevation                =  GPnone2R4
     Real(Kind=4)                ::  focusCorrection          =  GPnone2R4
     Real(Kind=4)                ::  focusCorrectionError     =  GPnone2R4
  End Type focusCorrectionType
  Type (focusCorrectionType)     ::  fCorr
  Type (focusCorrectionType)     ::  GVfCorr
  Type (focusCorrectionType)     ::  fCorrDefault
  Namelist / fCorrNML / fCorr
  !
  ! TBD: NOTE: OBSERVINGMODE, SWITCHINGMODE ARE DEPRECATED, USE: GV%*MODE ABOVE
  Character(len=lenCh2)      :: observingMode = "NONE"
  Character(len=lenCh2)      :: switchingMode = "NONE"
  !
Contains
!!$!!!
!!$!!!
  Subroutine pakoSet(programName,line,command,                       &
       &        error)
    !
    ! *** Arguments ***
    Include 'inc/variables/headerForCommandHandler2.inc'
    !
    ! *** standard working variables ***
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    Logical                 ::  isInitialized  = .False.
    Character (len=lenCh)   ::  keyword        = GPnone2
    Character (len=lenCh)   ::  valueC         = GPnone2
    Character (len=lenVar)  ::  displayLine    = GPnone2
    !
    Integer                 ::  ier, sic_getlun
    !
    Logical                 ::  logicalF1      = .False.
    Logical                 ::  logicalF2      = .False.
    Logical                 ::  errorTopology  = .False.
    Logical                 ::  errorAngleUnit = .False.
    !
    !D      Write (6,*) "   --> SR pakoSet "
    !D      Write (6,*) "       line: "
    !D      Write (6,*) "->",line(1:lenc(line)),"<-"
    !
    ! *** initialize:   ***
    !
    ! TBD: defaults, limits
    !
    If (.Not.isInitialized) Then
       isInitialized = .True.
    Endif
    !
    ! *** set In-values = previous Values ***
    !TBD    If (.Not.ERROR) Then
    !TBD        vars(iIn) = vars(iValue)
    !TBD   End If
    !TBD   !
    ! *** check N of Parameters: 0, n --> at  most n allowed  ***
    Call checkNofParameters(command,                              &
         &     2, 3,                                              &
         &     nArguments,                                        &
         &     errorNumber)
    ERROR = ERROR .Or. errorNumber
    !
    ! *** read Parameters, Options (to detect errors)            
    !     and check for validity and ranges                      
    If (.Not. ERROR) Then
       Include 'inc/parameters/parametersSetKeywordValue.inc'
    End If
    !
    ! *** display values ***
    !     (Note: this is done indepenently of the Error status)
    Call displaySet
    !
  End Subroutine pakoSet
!!!
!!!
  Subroutine displaySet
    !
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    Character(len=lenCh)  :: command
    !
    Character (len=lenVar2) ::  displayLine   = GPnone2
    !
    Include 'inc/display/commandDisplaySet.inc'
    !
  End Subroutine displaySet
!!!
!!!
  Subroutine pakoShow(programName,line,command,                       &
       &        error)
    !
    ! *** Arguments ***
    Include 'inc/variables/headerForCommandHandler2.inc'
    !
    ! *** standard working variables ***
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    Logical                 ::  isInitialized = .False.
    Character (len=lenCh2)   ::  keyword = GPnone2
    Character (len=lenVar2)  ::  valueC  = GPnone2
    !
    !D      Write (6,*) "   --> SR pakoShow "
    !D      Write (6,*) "       line: "
    !D      Write (6,*) "->",line(1:lenc(line)),"<-"
    !
    ! *** initialize:   ***
    If (.Not.isInitialized) Then
       isInitialized = .True.
    Endif
    !
    ! *** set In-values = previous Values ***
    If (.Not.ERROR) Then
!!
    End If
    !
    ! *** check N of Parameters: 0, n --> at  most n allowed  ***
    Call checkNofParameters(command,                                 &
         &     0, 0,                                                       &
         &     nArguments,                                                 &
         &     errorNumber)
    ERROR = ERROR .Or. errorNumber
    !
    ! *** read Parameters, Options (to detect errors)            
    !     and check for validity and ranges                      
    If (.Not. ERROR) Then
       !!         Include 
    End If
    !
    Call pakoMessage_level(0)           ! message level 0 so that
    !                               ! the following show
    !
    Write (messageText,*) 'Level. For standard output: ', GV%iPstdio, '. For file: ', GV%iPfile
    Call PakoMessage(priorityI,severityI,command,messageText)
    !
    messageText = ' Project    "'//GV%project(1:Len_trim(GV%project))//'"'
    Call PakoMessage(priorityI,severityI,command,messageText)
    !
    messageText = ' PI         "'//GV%PI(1:Len_trim(GV%PI))//'"'
    Call PakoMessage(priorityI,severityI,command,messageText)
    !
    messageText = ' Observer   "'//GV%observer(1:Len_trim(GV%observer))//'"'
    Call PakoMessage(priorityI,severityI,command,messageText)
    !
    messageText = ' Operator   "'//GV%oper    (1:Len_trim(GV%oper    ))//'"'
    Call PakoMessage(priorityI,severityI,command,messageText)
    !
    messageText = ' Topology   "'//GV%topology(1:Len_trim(GV%topology))//'"'
    Call PakoMessage(priorityI,severityI,command,messageText)
    !
    messageText = ' angle Unit set: "'//GV%angleUnitSetC(1:Len_trim(GV%angleUnitSetC))//'"'
    Call PakoMessage(priorityI,severityI,command,messageText)
    !
!D    messageText = ' angle Unit stored: "'//GV%angleUnitC(1:Len_trim(GV%angleUnitC))//'"'
!D    Call PakoMessage(priorityI,severityI,command,messageText)
    !
    messageText = ' speed Unit set: "'//GV%speedUnitSetC(1:Len_trim(GV%speedUnitSetC))//'"'
    Call PakoMessage(priorityI,severityI,command,messageText)
    !
!D    messageText = ' speed Unit stored: "'//GV%speedUnitC(1:Len_trim(GV%speedUnitC))//'"'
!D    Call PakoMessage(priorityI,severityI,command,messageText)
    !
    !
    Write (messageText,*) 'Pointing. azimuth:             ', GVpCorr%azimuth
    Call PakoMessage(priorityI,severityI,command,messageText)
    !
    Write (messageText,*) 'Pointing. elevation:           ', GVpCorr%elevation
    Call PakoMessage(priorityI,severityI,command,messageText)
    !
    Write (messageText,*) 'Pointing. P(1):                ', GVpCorr%pointingP(1)
    Call PakoMessage(priorityI,severityI,command,messageText)
    !
    Write (messageText,*) 'Pointing. P(2):                ', GVpCorr%pointingP(2)
    Call PakoMessage(priorityI,severityI,command,messageText)
    !
    Write (messageText,*) 'Pointing. P(7):                ', GVpCorr%pointingP(7)
    Call PakoMessage(priorityI,severityI,command,messageText)
    !
    Write (messageText,*) 'Pointing. azimuthCorrection:   ', GVpCorr%azimuthCorrection
    Call PakoMessage(priorityI,severityI,command,messageText)
    !
    Write (messageText,*) 'Pointing. azimuthCorrectionError: ', GVpCorr%azimuthCorrectionError
    Call PakoMessage(priorityI,severityI,command,messageText)
    !
    Write (messageText,*) 'Pointing. elevationCorrection: ', GVpCorr%elevationCorrection
    Call PakoMessage(priorityI,severityI,command,messageText)
    !
    Write (messageText,*) 'Pointing. elevationCorrectionError:', GVpCorr%elevationCorrectionError
    Call PakoMessage(priorityI,severityI,command,messageText)
    !
    !
    Write (messageText,*) 'Focus.    focusCorrection:     ', GVfCorr%focusCorrection
    Call PakoMessage(priorityI,severityI,command,messageText)
    !
    Write (messageText,*) 'Focus.    focusCorrectionError: ', GVfCorr%focusCorrectionError
    Call PakoMessage(priorityI,severityI,command,messageText)
    !
    !
    Call pakoMessage_level(GV%iPstdio)  ! reset message level
    !
  End Subroutine pakoShow
!!!
!!!
  Subroutine pakoSaveSet(programName,LINE,commandToSave,             &
       &           modeSelected, iUnit, ERROR)
    !
    ! *** Variables   ***
    Include 'inc/variables/headerForSaveMethods2.inc'
    !
    ERROR = .False.
    !
    contC = contNN
    !
    B = '\'   ! '
    S = ' '
    CMD =  programName//B//"SET"
    lCMD = lenc(CMD)
    !
    Include 'inc/parameters/saveSetLevel.inc'
    Include 'inc/parameters/saveSetProject.inc'
    Include 'inc/parameters/saveSetPI.inc'
    Include 'inc/parameters/saveSetObserver.inc'
    Include 'inc/parameters/saveSetOperator.inc'
    Include 'inc/parameters/saveSetTopology.inc'
    !
    Write (iUnit,*) "!"
    !
    Return
    !
  End Subroutine pakoSaveSet
!!!
!!!
  Subroutine writeXMLset(programName,LINE,commandToSave,              &
       &        iUnit, ERROR)
    !
    ! *** Variables   ***
    Include 'inc/variables/headerForSaveMethods.inc'
    !
    Logical                :: errorXML
    Logical                :: errorNotFound, errorNotUnique
    !
    Integer                :: ii, jj
    Character (len=lenCh2)  :: valueC
    Character (len=lenVar2) :: valueComment
    !
    ERROR = .False.
    !
    !D    write (6,*)  "      moduleGlobalVariables --> SR: writeXMLset "
    !
    valueC = GV%project
    call pakoXMLwriteElement("PARAM","project",valueC,                &
         &                         dataType="char",                   &
         &                         error=errorXML)
    !
    valueC = GV%PI
    call pakoXMLwriteElement("PARAM","PI",valueC,                     &
         &                         dataType="char",                   &
         &                         error=errorXML)
    !
    valueC = GV%observer
    call pakoXMLwriteElement("PARAM","observer",valueC,               &
         &                         dataType="char",                   &
         &                         error=errorXML)
    !
    valueC = GV%oper
    call pakoXMLwriteElement("PARAM","operator",valueC,               &
         &                         dataType="char",                   &
         &                         error=errorXML)
    !
    valueC = angleChoicesXML(GV%iAU)
    call pakoXMLwriteElement("PARAM","angleUnit",valueC,              &
         &                         dataType="char",                   &
         &                         space="after",                     &
         &                         error=errorXML)
    !
    Return
  End Subroutine writeXMLset
!!!
!!!
End Module modulePakoGlobalVariables






