!
! $Id: modulePakoBackend.f90,v 1.1 2005/03/23 14:26:00 pety Exp $
!     
! <DOCUMENTATION name="modulePakoBackend">
!   <PROGRAM>
!                Pako
!   <\PROGRAM>
!   <FAMILY>
!                Backend
!   </FAMILY>
!   <SIBLINGS>
!
!   </SIBLINGS>        
!
!   Pako module for command: Backend
!
! </DOCUMENTATION> <!-- name="modulePakoBackend" -->
!
Module modulePakoBackend
  !
  Use modulePakoMessages
  Use modulePakoGlobalParameters
  Use modulePakoLimits
  Use modulePakoDisplayText
  Use modulePakoUtilities
  Use modulePakoReceiver, Only: listRX, varReceiver
  Use modulePakoXML
  !
  Implicit None
  Save
  Private
  Public :: backend, saveBackend, writeXMLbackend
  !     
  ! *** Variables for backend ***
  Include 'inc/variables/variablesBackend.inc'
!!!   
!!!   
Contains
!!!   
!!!
  Subroutine backend(programName,line,command,ERROR)
    !
    ! *** arguments: ***
    Include 'inc/variables/headerForCommandHandler.inc'
    !
    ! *** standard working variables   ***
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    Integer               :: iOption2, iOption3
    Logical               :: shortSyntax
    Logical               :: doCCD              !  do clear, connect, or disconnect
    Logical               :: doReceiver         !  option /RECEIVER is present
!!$    Logical               :: newValues
    Real(Kind=kindSingle) :: VESPApercentUsed
    !
    ! TBD: the following shall be replaced by a SR reading from XML:
    Include 'inc/ranges/rangesBackend.inc'
    !
    ERROR       = .False.
    !
    doCCD       = .False.
    doReceiver  = .False.
    shortSyntax = .False.
    !
    !D    Write (6,*) " module backend ---> SR: backend "
    !D    Write (6,*) "                                 "
    !
    ! *** initialize:   ***
    If (.Not.isInitialized) Then
       Include 'inc/variables/backendSetDefaults.inc'
       isInitialized = .True.
    Endif
    !
    ! *** set In-values = previous Values   ***
    If (.Not.ERROR) Then
       vars(iIn,:) = vars(iValue,:)
    End If
    !
    ! *** check N of Parameters: 0, n --> at  most n allowed  ***
    ! *** read Parameters, Options (to detect errors)         ***
    ! *** and check for validity and ranges                   ***
    Call checkNofParameters(command,                                  &
         &     0, 7,                                                  &
         &     nArguments,                                            &
         &     errorNumber)
    ERROR = ERROR .Or. errorNumber
    If (.Not. ERROR) Then
       Include 'inc/parameters/parametersBackend.inc'      
       Include 'inc/options/readOptionsBackend.inc'
    End If
    !
    ! *** set defaults   ***
    If (.Not. ERROR) Then
       option = 'DEFAULTS'
       Call indexCommmandOption                                       &
            &        (command,option,commandFull,optionFull,          &
            &        commandIndex,optionIndex,iCommand,iOption,       &
            &        errorNotFound,errorNotUnique)
       setDefaults = SIC_PRESENT(iOption,0)
       If (setDefaults) Then
          Include 'inc/variables/backendSetDefaults.inc'
       End If
    End If
    !
    ! *** read Parameters, Options (again, after defaults!)   ***
    ! *** and check for validity and ranges                   ***
    If (.Not. ERROR) Then
       Include 'inc/parameters/parametersBackend.inc'
       Include 'inc/options/readOptionsBackend.inc'
    End If
    !
    ! *** check consistency and                           ***
    ! *** store into temporary (intermediate) variables   ***
    If (.Not.ERROR) Then
       errorInconsistent = .False.
!!$         Include 'Parameters/checkConsistentBackend.inc'
       ! TBD:   more consistency checks
       If (.Not. errorInconsistent) Then
          vars(iTemp,iBack) = vars(iIn,iBack)
       End If
    End If
    !
    ERROR = ERROR .Or. errorInconsistent
    !
    ! *** store from Temp into persistent variables   ***
    !
    If (.Not.ERROR) Then
       vars(iValue,iBack) = vars(iTemp,iBack)
       iPart = vars(iValue,iBack)%nPart
       If (.Not. doCCD) Then
          listBe(iBack,iPart) = vars(iValue,iBack)
       End If
    End If
    !
    Call  checkVespa (listRX,                                         &
         &  listBe(iVESPA,:),                                         &
         &  errorInconsistent, errorCode, VESPApercentUsed)
    !D    Write (6,*) "      errorInconsistent ", errorInconsistent
    !D    Write (6,*) "      errorCode       ->", errorCode(1:Len_trim(errorCode)),"<-"
    !D    Write (6,*) "      VESPApercentUsed  ", VESPApercentUsed
    !
    Write (messageText,*) " VESPA percentage used: ", VESPApercentUsed
    Call pakoMessage(priorityI,severityI,command,messageText)
    !
    If (errorInconsistent) Then
       ERROR = .True.
       listBe(iBack,iPart) = beReset
       If (Len_trim(errorCode) .Ge. 1) Then
          messageText = " VESPA error. "//errorCode(1:Len_trim(errorCode))
       Else
          messageText = " VESPA error. "
       End If
       Call pakoMessage(priorityE,severityE,command,messageText)
    End If
    !
    ! *** display values ***
    !     (Note: this is done independantly of the Error status)
    Call displayBackends
    !
    ! *** list backends in coimmand line screen ***
    If (.Not.error) Then
       !
       If (iBack.Ge.1 .And. iBack.Le.nDimBackends) Then
          backendCommand(iBack) = line(1:lenc(line))
          !D          Write (6,*) "   iBack:                  ", iBack
          !D          Write (6,*) "   backendCommand(iBack) ->",                  &
          !D               &                   backendCommand(iBack)(1:lenc(line))
       End If
       !
       Do jj = 1,nDimBackends,1
          Do ii = 1,nDimParts,1
             l1 = lenc(listBe(jj,ii)%name)
             l2 = lenc(listBe(jj,ii)%receiverName)
             If (listBe(jj,ii)%isConnected) Then
                Write (messageText, '(A,I,3F10.3,4A,F10.1)' )         & 
                     &        listBe(jj,ii)%name,                     &
                     &        listBe(jj,ii)%nPart,                    &
                     &        listBe(jj,ii)%resolution,               &
                     &        listBe(jj,ii)%bandwidth,                &
                     &        listBe(jj,ii)%fShift,                   &
                     &        " connected to ",                       &
                     &        listBe(jj,ii)%receiverName,             &
                     &        listBe(jj,ii)%receiverName2,            &
                     &        listBe(jj,ii)%mode,                     &
                     &        listBe(jj,ii)%percentage
                Call pakoMessage(priorityI,severityI,command,messageText)
             Else If (listBe(jj,ii)%wasConnected) Then
                Write (messageText, '(A,I,3F10.3,4A,F10.1)' )         & 
                     &        listBe(jj,ii)%name,                     &
                     &        listBe(jj,ii)%nPart,                    &
                     &        listBe(jj,ii)%resolution,               &
                     &        listBe(jj,ii)%bandwidth,                &
                     &        listBe(jj,ii)%fShift,                   &
                     &        " DISCONNECTED FROM ",                  &
                     &        listBe(jj,ii)%receiverName,             &
                     &        listBe(jj,ii)%receiverName2,            &
                     &        listBe(jj,ii)%mode,                     &
                     &        listBe(jj,ii)%percentage
                Call pakoMessage(priorityI,severityI,command,messageText)
             End If
          End Do
       End Do
       !
    End If
    !
    Return
  End Subroutine backend
!!!
!!!
  Subroutine displayBackends
!
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    Character(len=24)  :: command
    !
    Include 'inc/display/commandDisplayBackends.inc'
!
  End Subroutine displayBackends
!!!
!!!
  Subroutine saveBackend(programName,LINE,commandToSave,       &
       &        modeSelected, iUnit, ERROR)

    ! *** Variables   ***
    Include 'inc/variables/headerForSaveMethods2.inc'
    !
!!$        Integer       :: ii, jj, l, lCMD
!!$        Character*512 :: messageText
!!$!
    ERROR = .False.
    !
!!$!D        write (6,*) '   --> SR: saveBackend '
!!$!
!!$        Include 'Commands/saveCommandClear.inc'
!!$!
!!$!
!!$      B = "\"   ! "
!!$      S = " "
!!$      CMD =  programName//B//"BACKEND"
!!$      lCMD = lenc(CMD)
!!$!
!!$      ERROR = .False.
!!$!
!!$      contC = contNN
!!$!
!!$      Write (iUnit,*) "! "
!!$      Write (iUnit,*) "! ", CMD(1:lCMD)
!!$!
!!$      Write (iUnit,*) CMD(1:lCMD), " /clear"
!!$!
!!$        Do jj = 1,nDimBackends,1
!!$           Do ii = 1,nDimParts,1
!!$              If (listBe(jj,ii)%isConnected) Then
!!$                 Write (messageText,*)                                   & 
!!$     &               ' saving Backend: ', listBe(jj,ii)%name,            &
!!$     &               ' Part: ', listBe(jj,ii)%nPart
!!$                 Call pakoMessage(priorityI,severityI,                       &
!!$     &                         commandToSave,messageText)
!!$                 contC = contNC
!!$                 Include 'Parameters/saveBackend.inc'
!!$                 contC = contCC
!!$                 Include 'Parameters/saveBackendPart.inc'
!!$                 Include 'Parameters/saveBackendResolution.inc'
!!$                 Include 'Parameters/saveBackendBandwidth.inc'
!!$                 Include 'Parameters/saveBackendFshift.inc'
!!$                 contC = contCN
!!$                 Include 'Parameters/saveBackendReceiver.inc'
!!$! TBD:           Include 'Options/saveOptionReceiver.inc'
!!$              End If
!!$           End Do
!!$        End Do
    !
    Return
  End Subroutine saveBackend
!!!
!!!
  Subroutine writeXMLbackend(programName,LINE,commandToSave,         &
       &        iUnit, ERROR)
    !
    ! *** Variables   ***
    Include 'inc/variables/headerForSaveMethods.inc'
    !
    Logical :: errorXML
    Logical :: errorNotFound, errorNotUnique
    !
    Integer :: ii, jj
    Character (len=24) :: valueC
    Character (len=48) :: valueComment
    !
    ERROR = .False.
    !
    Write (6,*)  "      moduleBackend --> SR: writeXMLbackend "
    !
    Include 'inc/startXML/backend.inc'
    !
    Return
  End Subroutine writeXMLbackend
!!!
!!!
  Subroutine checkVespa (listRX, listVESPA,                           &
       &                 error,  errorCode, percentUsed)
    !
    Type (varReceiver),        Dimension(:), Intent(IN)  ::           &
         &               listRX         !! list of all Receivers
    Type (varBackend),         Dimension(:), Intent(IN)  ::           &
         &               listVESPA      !! list of all VESPA parts    
    !
    Logical,                Intent(OUT)            ::  error
    Character(len=*),       Intent(OUT), Optional  ::  errorCode
    Real(Kind=kindSingle),  Intent(OUT), Optional  ::  percentUsed
    !
    Integer :: lBoundRX, uBoundRX
    Integer :: lBoundBE, uBoundBE
    Integer :: ii, jj
    !
!D    Write (6,*) "   --> checkVespa "
    !
    error        = .False.
    errorCode    = "OK"
    percentUsed  = 0.0
    !
    lBoundRX = Lbound(listRX,1)
    uBoundRX = Ubound(listRX,1)
    !
!D    Write (6,*) "      lBoundRX ", lBoundRX
!D    Write (6,*) "      uBoundRX ", uBoundRX
    !
    !
    lBoundBE = Lbound(listVESPA,1)
    uBoundBE = Ubound(listVESPA,1)
    !
    jj = 0
    Do ii = lBoundRX,uBoundRX,1
       If (listRX(ii)%isConnected) Then
!D          Write (6,*) " ii ", ii
          l1 = Len_trim(listRX(ii)%name)
!D          Write (6,*)                                                                 & 
!D               &          listRX(ii)%name(1:l1)," ",                                  &
!D               &          listRX(ii)%lineName(1:Len_trim(listRX(ii)%lineName))," ",   &
!D               &          listRX(ii)%frequency%value,                                 &
!D               &          listRX(ii)%offset%value,                                    &
!D               &          listRX(ii)%sideBand(1:Len_trim(listRX(ii)%sideBand))," ",   &
!D               &          listRX(ii)%frequency%doppler (1:Len_trim(listRX(ii)%frequency%doppler)), " ",   &
!D               &          listRX(ii)%width(1:Len_trim(listRX(ii)%width))," ",         &
!D               &          listRX(ii)%gainImage%value,                                 &
!D               &          listRX(ii)%tempCold,                                        & 
!D               &          listRX(ii)%tempAmbient,                                     &
!D               &          listRX(ii)%effForward,                                      &
!D               &          listRX(ii)%effBeam,                                         &
!D               &          listRX(ii)%scale(1:Len_trim(listRX(ii)%scale))," ",         &
!D               &          listRX(ii)%iPixel,                                          &
!D               &          listRX(ii)%nPixels,                                         &
!D               &          listRX(ii)%centerIf,                                        &
!D               &          listRX(ii)%bandWidth,                                       &
!D               &          listRX(ii)%disBoxInput,                                     &
!D               &          listRX(ii)%IF2,                                             &
!D               &          listRX(ii)%isFlippingIF2,                                   &
!D               &          listRX(ii)%polarization(1:len_trim(listRX(ii)%polarization))," ",  &
!D               &          listRX(ii)%useSpecialLO
       End If
    End Do
    !
    jj = 0
    Do ii = lBoundBE,uBoundBE,1
       If (listVESPA(ii)%isConnected) Then
!D          Write (6,*) " ii ", ii
          jj = jj+1
          l1 = Len_trim(listVESPA(ii)%name)
          l2 = Len_trim(listVESPA(ii)%receiverName)
!D          Write (6,*)                                                 & 
!D               &          listVESPA(ii)%name(1:l1)," ",               &
!D               &          listVESPA(ii)%nPart,                        &
!D               &          listVESPA(ii)%resolution,                   &
!D               &          listVESPA(ii)%bandwidth,                    &
!D               &          listVESPA(ii)%fShift,                       &
!D               &     " ", listVESPA(ii)%receiverName(1:l2)," ",       &
!D               &          listVESPA(ii)%receiverName2," ",            &
!D               &          listVESPA(ii)%mode," ",                     &
!D               &          listVESPA(ii)%percentage,                   &
!D               &          " "
       End If
    End Do
    !
    If (jj .Lt. 7) Then
       percentUsed = jj/10.0*100.0
    Else 
       error = .True.
       If (Len(errorCode).Ge.10) Then
          errorCode = "demo error"
       End If
       percentUsed = 110.0
    End If
    !
    Return
    !
  End Subroutine checkVespa
!!!
!!!
End Module modulePakoBackend
