program p_uv_hybrid
  use image_def
  use gkernel_interfaces
!
! Compute the fidelity distribution in the UV plane
!
  character*256 name1,name2,name3
  real uvradius
  logical error
!
  call gildas_open
  call gildas_char ('ALMA$',name1)
  call gildas_char ('ACA$',name2)
  call gildas_char ('ALL$',name3)
  call gildas_real ('UVRADIUS$',uvradius,1)
  call gildas_close
!
  error = .false.
  call s_uv_hybrid (name1,name2,name3,uvradius,error)
  if (error) call sysexi (fatale)
end program p_uv_hybrid
!
subroutine s_uv_hybrid(name1,name2,name3,uvradius,error)
  use image_def
  use gkernel_interfaces, no_interface=>fourt
  ! Take ALMA map
  ! Take ACA  map
  ! Make oversampled Fourier Transform of boths
  ! Compute the truncation function f(r)
  ! Make the Truncated compact Fourier Transform, f(r) x T(ACA)
  ! Make the complement long baseline Fourier Transform, (1-f(r)) x T(ALMA)
  ! Sum them T(ALL) = f(r) x T(ACA) + (1-f(r)) x T(ALMA)
  ! Make the inverse Fourier Transform
  ! Truncate the resulting image to original size
  ! Done...
  !
  character(len=*) name1,name2,name3
  real uvradius
  logical error
  !
  type (gildas) :: alma,aca,all
  real, allocatable :: dalma(:,:,:),daca(:,:,:),dout(:,:,:)
  real, allocatable :: f(:,:), x(:), y(:)
  complex, allocatable :: calma(:,:),caca(:,:), wfft(:), cout(:,:), cbig(:,:)
  integer nx,ny,nc,ic,nn,dim(2),ier,mx,my,i,j, expand
  real(8) lambda
  real uinc, vinc
  logical equal
  !
  call gildas_null(alma)
  call gildas_null(aca)
  call gildas_null(all)
  !
  ! Read Headers Model & Image 
  call sic_parsef (name1,alma%file,' ','.lmv-clean')
  call gdf_read_header (alma,error)
  if (error) return
  call sic_parsef (name2,aca%file,' ','.lmv-clean')
  call gdf_read_header (aca,error)
  if (error) return
  call gdf_compare_shape (alma,aca,equal)
  if (.not.equal) then
     call gagout('W-UV_HYBRID,  images do not match')
!     error = .true.
!     return
  endif
  nx = alma%gil%dim(1)
  ny = alma%gil%dim(2)
  nc = alma%gil%dim(3)
  !
  ! Read Data Model & Image
  allocate (dalma(nx,ny,nc),stat=ier)
  call gdf_read_data (alma,dalma,error)
  if (error) return
  !
  mx = aca%gil%dim(1)
  my = aca%gil%dim(2)
  allocate (daca(mx,my,nc),stat=ier)
  call gdf_read_data (aca,daca,error)
  if (error) return
  !
  ! Skip blanking
  where (abs(dalma-alma%gil%bval).le.alma%gil%eval) dalma = 0.0
  where (abs(daca-aca%gil%bval).le.aca%gil%eval) daca = 0.0
  ! 
  ! Allocate output image
  allocate (dout(nx,ny,nc),stat=ier)
  !
  ! Define output image
  ! It must take the header of the high angular resolution image
  ! (since angular resolution has little influence on the inner part
  ! or the UV plane)
  call gdf_copy_header (ALMA,ALL, error)
  all%gil%ndim = 3
  all%gil%dim(1) = nx
  all%gil%dim(2) = ny
  all%gil%dim(3) = nc
  call sic_parsef (name3,all%file,' ','.lmv-clean')
!
! Get the user units in "m"...
! Oops, quite a difficult problem, isn't it ?
  lambda = 299792458.d-6/all%gil%freq
  Print *,'Lambda ',lambda
  !
  ! Allocate Fourier space
  allocate(calma(nx,ny),stat=ier)
  allocate(caca(mx,my),stat=ier)
  allocate(wfft(max(nx,ny)),stat=ier)
  allocate(cout(nx,ny),f(nx,ny),stat=ier)
  allocate(x(nx),y(ny),stat=ier)
  allocate(cbig(nx,ny),stat=ier)
  nn = 2
  dim = (/nx,ny/)
  !
  ! Compute the combination factor F
  uinc = lambda / (all%gil%inc(1) * nx) 
  vinc = lambda / (all%gil%inc(2) * ny) 
  Print *,'UV Cell size ',uinc,vinc,uvradius
  uinc = uinc / uvradius
  do i=1,nx/2
     x(i) = (i-1)*uinc
  enddo
  do i=nx/2+1,nx
     x(i) = (i-nx-1)*uinc
  enddo
  x = x**2
  !
  vinc = vinc / uvradius
  do i=1,ny/2
     y(i) = (i-1)*vinc
  enddo
  do i=ny/2+1,ny
     y(i) = (i-ny-1)*vinc
  enddo
  y = y**2
  !	
  do j=1,ny
     do i=1,nx
        f(i,j) = x(i) + y(j)
        if (f(i,j).lt.20) then
           f(i,j) = exp(-f(i,j)**16) 
        else
           f(i,j) = 0.0
        endif
     enddo
  enddo
  expand = (nx*ny)/(mx*my)
  !
  ! Get the beams and rescale the data accordingly
  Print *,'Computed F, Expand ',expand
  !
  do ic = 1,nc
    Print *,'IC ',ic
    calma = cmplx(dalma(:,:,ic),0.0)
    caca = cmplx(daca(:,:,ic),0.0)
    dim = (/nx,ny/)
    call fourt (calma,dim,2,1,1,wfft)
!
! ACA
    dim = (/mx,my/)
    call fourt (caca,dim,2,1,1,wfft)
!
! Divide by its own beam
    call mulgau(caca,mx,my, &
    aca%gil%majo,aca%gil%mino,aca%gil%posa, &
    aca%gil%inc(1),aca%gil%inc(2),1) 
!
! Multiply by the other beam
    call mulgau(caca,mx,my, &
    alma%gil%majo,alma%gil%mino,alma%gil%posa, &
    aca%gil%inc(1),aca%gil%inc(2),-1) 
    caca = caca / (aca%gil%majo*aca%gil%mino)*(alma%gil%majo*alma%gil%mino)
!
! Expansion part
    if (expand.ne.1) then
       cbig = 0
! Load inner quarter
       do j=1,my/2
          cbig(1:mx,j) = caca(1:mx,j)
          cbig(1+nx-mx/2:nx,j) = caca(mx/2+1:mx,j)
       enddo
       do j=my/2+1,my
          cbig(1:mx,j+ny-my) = caca(1:mx,j)
          cbig(1+nx-mx/2:nx,j+ny-my) = caca(mx/2+1:mx,j)
       enddo
       cbig = cbig*expand ! rescale to appropriate units
       cout = f * cbig + (1.0-f) * calma
    else
       cout = f * caca + (1.0-f) * calma
    endif
!
! Back transform
    dim = (/nx,ny/) 
    call fourt (cout,dim,2,-1,1,wfft)
    dout(:,:,ic) = real(cout)
  enddo
  !
  dout = dout / (nx*ny)
  call gdf_write_image(all,dout,error)
  deallocate (calma,caca,cout,wfft)
  deallocate (dalma,daca,dout,f)
end subroutine s_uv_hybrid
!
subroutine plunge_real (r,nx,ny,c,mx,my)
  !-----------------------------------------------------------------
  !     Plunge a Real array into a larger Complex array
  !-----------------------------------------------------------------
  integer nx,ny                      ! size of input array
  real r(nx,ny)                      ! input real array
  integer mx,my                      ! size of output array
  complex c(mx,my)                   ! output complex array
  !
  integer kx,ky,lx,ly
  integer i,j
  !
  kx = nx/2+1
  lx = mx/2+1
  ky = ny/2+1
  ly = my/2+1
  !
  c = 0.0
  do j=1,ny
     do i=1,nx
        c(i-kx+lx,j-ky+ly) = cmplx(r(i,j),0.0)
     enddo
  enddo
end subroutine plunge_real
!
subroutine extract_real (c,mx,my,r,nx,ny)  ! check with cmtore ...
  !-----------------------------------------------------------------
  !     Extract a Real array from a larger Complex array
  !-----------------------------------------------------------------
  integer nx,ny                      ! size of input array
  real r(nx,ny)                      ! input real array
  integer mx,my                      ! size of output array
  complex c(mx,my)                    ! output complex array
  !
  integer kx,ky,lx,ly
  integer i,j
  !
  kx = nx/2+1
  lx = mx/2+1
  ky = ny/2+1
  ly = my/2+1
  !
  do j=1,ny
     do i=1,nx
        r(i,j) = real(c(i-kx+lx,j-ky+ly)) 
     enddo
  enddo
end subroutine extract_real
!
subroutine mulgau(data,nx,ny,bmaj,bmin,pa,x_inc1,x_inc2,isign)
  !----------------------------------------------------------------------
  ! GDF	Multiply the TF of an image by the TF of
  !	a convolving gaussian function. BMAJ and BMIN are the
  !	widths of the original gaussian. PA is the position angle of major
  !	axis (from north towards east)
  !----------------------------------------------------------------------
  integer nx,ny
  real(4) bmaj,bmin,pa
  real(8) x_inc1,x_inc2
  complex data(nx,ny)
  integer i,j,nx1,nx2
  integer isign
  real amaj,amin,fact,cx,cy,sx,sy
  logical norot,rot90
  real(8) rpa
  real(8), parameter :: pi=3.141592653589793d0
  real(4), parameter :: eps=1.e-7
  !
  rpa = pa*180.0/pi ! in degrees
  norot = ( abs(mod(rpa,180.d0)).le.eps)
  rot90 = ( abs(mod(rpa,180.d0)-90.d0).le.eps)
  amaj = bmaj*pi/(2.*sqrt(log(2.)))
  amin = bmin*pi/(2.*sqrt(log(2.)))
  rpa = pa ! in radians here...  pa*pi/180.d0
  print *,'major & minor ',bmaj*3600*180/pi,bmin*3600*180/pi
  print *,'position angle ',pa*180/pi
  print *,'isign ',isign
  !
  cx = cos(rpa)/nx*amin
  cy = cos(rpa)/ny*amaj
  sx = sin(rpa)/nx*amaj
  sy = sin(rpa)/ny*amin
  !
  ! convert map units to pixels
  cx = cx / x_inc1
  cy = cy / x_inc2
  sx = sx / x_inc1
  sy = sy / x_inc2
  nx2 = nx/2
  nx1 = nx2+1
  !
  ! optimised code for position angle 0 degrees
  if (norot) then
     do j=1,ny/2
        do i=1,nx2
           fact = (float(j-1)*cy)**2 + (float(i-1)*cx)**2
           if (fact.lt.80.) then
              fact = exp (isign*fact)
              data(i,j) = data(i,j)*fact
           else
              data(i,j) = 0.
           endif
        enddo
        do i=nx1,nx
           fact = (float(j-1)*cy)**2 + (float(i-nx-1)*cx)**2
           if (fact.lt.80.) then
              fact = exp (isign*fact)
              data(i,j) = data(i,j)*fact
           else
              data(i,j) = 0.
           endif
        enddo
     enddo
     do j=ny/2+1,ny
        do i=1,nx2
           fact = (float(j-ny-1)*cy)**2 + (float(i-1)*cx)**2
           if (fact.lt.80.) then
              fact = exp (isign*fact)
              data(i,j) = data(i,j)*fact
           else
              data(i,j) = 0.
           endif
        enddo
        do i=nx1,nx
           fact = (float(j-ny-1)*cy)**2 + (float(i-nx-1)*cx)**2
           if (fact.lt.80.) then
              fact = exp (isign*fact)
              data(i,j) = data(i,j)*fact
           else
              data(i,j) = 0.
           endif
        enddo
     enddo
     !
     ! optimised code for position angle 90 degrees
  elseif (rot90) then
     do j=1,ny/2
        do i=1,nx2
           fact = (float(i-1)*sx)**2 +(float(j-1)*sy)**2
           if (fact.lt.80.) then
              fact = exp (isign*fact)
              data(i,j) = data(i,j)*fact
           else
              data(i,j) = 0.
           endif
        enddo
        do i=nx1,nx
           fact = (float(i-nx-1)*sx)**2 + (float(j-1)*sy)**2
           if (fact.lt.80.) then
              fact = exp (isign*fact)
              data(i,j) = data(i,j)*fact
           else
              data(i,j) = 0.
           endif
        enddo
     enddo
     do j=ny/2+1,ny
        do i=1,nx2
           fact = (float(i-1)*sx)**2 + (float(j-ny-1)*sy)**2
           if (fact.lt.80.) then
              fact = exp (isign*fact)
              data(i,j) = data(i,j)*fact
           else
              data(i,j) = 0.
           endif
        enddo
        do i=nx1,nx
           fact = (float(i-nx-1)*sx)**2 + (float(j-ny-1)*sy)**2
           if (fact.lt.80.) then
              fact = exp (isign*fact)
              data(i,j) = data(i,j)*fact
           else
              data(i,j) = 0.
           endif
        enddo
     enddo
     !
     ! general case of a rotated elliptical gaussian
  else
     do j=1,ny/2
        do i=1,nx2
           fact = (float(i-1)*sx + float(j-1)*cy)**2 + &
                (-float(i-1)*cx + float(j-1)*sy)**2
           if (fact.lt.80.) then
              fact = exp (isign*fact)
              data(i,j) = data(i,j)*fact
           else
              data(i,j) = 0.
           endif
        enddo
        do i=nx1,nx
           fact = (float(i-nx-1)*sx + float(j-1)*cy)**2 + &
                ( -float(i-nx-1)*cx + float(j-1)*sy)**2
           if (fact.lt.80.) then
              fact = exp (isign*fact)
              data(i,j) = data(i,j)*fact
           else
              data(i,j) = 0.
           endif
        enddo
     enddo
     do j=ny/2+1,ny
        do i=1,nx2
           fact = (float(i-1)*sx + float(j-ny-1)*cy)**2 + &
                ( -float(i-1)*cx + float(j-ny-1)*sy)**2
           if (fact.lt.80.) then
              fact = exp (isign*fact)
              data(i,j) = data(i,j)*fact
           else
              data(i,j) = 0.
           endif
        enddo
        do i=nx1,nx
           fact = (float(i-nx-1)*sx & 
                + float(j-ny-1)*cy)**2 + &
                ( -float(i-nx-1)*cx + float(j-ny-1)*sy)**2
           if (fact.lt.80.) then
              fact = exp (isign*fact)
              data(i,j) = data(i,j)*fact
           else
              data(i,j) = 0.
           endif
        enddo
     enddo
  endif
end subroutine mulgau





