!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
! *** JP: This one should be turn in a command by itself.
!
module cubemain_copy
  use cube_types
  use cubemain_messaging
  !
  public :: cubemain_copy_data
  private
  !
contains
  !
  subroutine cubemain_copy_data(in,ou,error)
    use cubeadm_opened
    !-------------------------------------------------------------------
    ! 
    !-------------------------------------------------------------------
    type(cube_t), intent(inout) :: in
    type(cube_t), intent(inout) :: ou
    logical,      intent(inout) :: error
    !
    type(cubeadm_iterator_t) :: iter
    character(len=*), parameter :: rname='COPY>DATA'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubeadm_datainit_all(iter,error)
    if (error) return
    !$OMP PARALLEL DEFAULT(none) SHARED(in,ou,error) FIRSTPRIVATE(iter)
    !$OMP SINGLE
    do while (cubeadm_dataiterate_all(iter,error))
       if (error)  exit
       !$OMP TASK SHARED(in,ou) FIRSTPRIVATE(iter,error)
       if (.not.error)  call cubemain_copy_data_case(iter%first,iter%last,in,ou,error)
       !$OMP END TASK
    enddo ! ie
    !$OMP END SINGLE
    !$OMP END PARALLEL
  end subroutine cubemain_copy_data
  !
  subroutine cubemain_copy_data_case(first,last,in,ou,error)
    !-------------------------------------------------------------------
    ! 
    !-------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: first
    integer(kind=entr_k), intent(in)    :: last
    type(cube_t),         intent(inout) :: in
    type(cube_t),         intent(inout) :: ou
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='COPY>DATA>CASE'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    select case (in%order())
    case (code_cube_imaset)
      if (in%iscplx()) then
        call cubemain_copy_data_image_cplx_loop(first,last,in,ou,error)
        if (error) return
      else
        call cubemain_copy_data_image_real_loop(first,last,in,ou,error)
        if (error) return
      endif
    case (code_cube_speset)
      if (in%iscplx()) then
        call cubemain_copy_data_spectrum_cplx_loop(first,last,in,ou,error)
        if (error)  return
      else
        call cubemain_copy_data_spectrum_real_loop(first,last,in,ou,error)
        if (error) return
      endif
    case default
       call cubemain_message(seve%e,rname,'Unsupported file access')
       error = .true.
       return
    end select
  end subroutine cubemain_copy_data_case
  !
  subroutine cubemain_copy_data_image_real_loop(first,last,in,ou,error)
    use cubeadm_entryloop
    use cubemain_image_real
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: first
    integer(kind=entr_k), intent(in)    :: last
    type(cube_t),         intent(inout) :: in
    type(cube_t),         intent(inout) :: ou
    logical,              intent(inout) :: error
    !
    integer(kind=entr_k) :: ie
    type(image_t) :: image
    character(len=*), parameter :: rname='COPY>DATA>IMAGE>REAL>LOOP'
    !
    call image%init(in,error)
    if (error) return
    !
    do ie = first,last
       call cubeadm_entryloop_iterate(ie,error)
       if (error) return
       call image%get(in,ie,error)
       if (error) return
       call image%put(ou,ie,error)
       if (error) return
    enddo ! ie
  end subroutine cubemain_copy_data_image_real_loop
  !
  subroutine cubemain_copy_data_image_cplx_loop(first,last,in,ou,error)
    use cubeadm_entryloop
    use cubemain_image_cplx
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: first
    integer(kind=entr_k), intent(in)    :: last
    type(cube_t),         intent(inout) :: in
    type(cube_t),         intent(inout) :: ou
    logical,              intent(inout) :: error
    !
    integer(kind=entr_k) :: ie
    type(image_cplx_t) :: image
    character(len=*), parameter :: rname='COPY>DATA>IMAGE>CPLX>LOOP'
    !
    call image%init(in,error)
    if (error) return
    !
    do ie = first,last
       call cubeadm_entryloop_iterate(ie,error)
       if (error) return
       call image%get(in,ie,error)
       if (error) return
       call image%put(ou,ie,error)
       if (error) return
    enddo ! ie
  end subroutine cubemain_copy_data_image_cplx_loop
  !
  subroutine cubemain_copy_data_spectrum_real_loop(first,last,in,ou,error)
    use cubeadm_entryloop
    use cubemain_spectrum_real
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: first
    integer(kind=entr_k), intent(in)    :: last
    type(cube_t),         intent(inout) :: in
    type(cube_t),         intent(inout) :: ou
    logical,              intent(inout) :: error
    !
    integer(kind=entr_k) :: ie
    type(spectrum_t) :: spectrum
    character(len=*), parameter :: rname='COPY>DATA>SPECTRUM>REAL>LOOP'
    !
    call spectrum%reassociate_and_init(in,error)
    if (error) return
    !
    do ie = first,last
       call cubeadm_entryloop_iterate(ie,error)
       if (error) return
       call spectrum%get(in,ie,error)
       if (error) return
       call spectrum%put(ou,ie,error)
       if (error) return
    enddo ! ie
  end subroutine cubemain_copy_data_spectrum_real_loop
  !
  subroutine cubemain_copy_data_spectrum_cplx_loop(first,last,in,ou,error)
    use cubeadm_entryloop
    use cubemain_spectrum_cplx
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: first
    integer(kind=entr_k), intent(in)    :: last
    type(cube_t),         intent(inout) :: in
    type(cube_t),         intent(inout) :: ou
    logical,              intent(inout) :: error
    !
    integer(kind=entr_k) :: ie
    type(spectrum_cplx_t) :: spectrum
    character(len=*), parameter :: rname='COPY>DATA>SPECTRUM>CPLX>LOOP'
    !
    call spectrum%reassociate_and_init(in,error)
    if (error) return
    !
    do ie = first,last
       call cubeadm_entryloop_iterate(ie,error)
       if (error) return
       call spectrum%get(in,ie,error)
       if (error) return
       call spectrum%put(ou,ie,error)
       if (error) return
    enddo ! ie
  end subroutine cubemain_copy_data_spectrum_cplx_loop
end module cubemain_copy
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
