!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeio_header_iodesc
  use cubetools_header_types
  use cubetools_header_interface
  use cubeio_desc
  use cubeio_interface
  use cubeio_messaging
  !
  public :: cubeio_header_put_toiodesc
  public :: cubeio_iodesc_import
  public :: cubeio_iodesc_unrecognized
  private
  !
contains
  !
  subroutine cubeio_header_put_toiodesc(head,order,iodesc,verbose,error)
    !-------------------------------------------------------------------
    ! From type(cube_header_t) to type(cubeio_desc_t) with desired order
    !-------------------------------------------------------------------
    type(cube_header_t),   intent(in)    :: head
    integer(kind=code_k),  intent(in)    :: order  ! code_order_*
    type(cubeio_desc_t),   intent(inout) :: iodesc
    logical,               intent(in)    :: verbose
    logical,               intent(inout) :: error
    !
    type(cube_header_interface_t) :: interface
    character(len=*), parameter :: rname='HEADER>PUT'
    !
    call cubeio_message(ioseve%trace,rname,'Welcome')
    !
    call cubetools_header_export(head,interface,error)
    if (error) return
    call cubeio_interface_transpose(interface,order,error)
    if (error) return
    call cubeio_iodesc_import(interface,iodesc,error)
    if (error) return
  end subroutine cubeio_header_put_toiodesc
  !
  !---------------------------------------------------------------------
  !
  subroutine cubeio_iodesc_import(in,iodesc,error)
    use gbl_format
    !-------------------------------------------------------------------
    ! From type(cube_header_interface_t) to type(cubeio_desc_t)
    !-------------------------------------------------------------------
    type(cube_header_interface_t), intent(in)    :: in
    type(cubeio_desc_t),           intent(inout) :: iodesc
    logical,                       intent(inout) :: error
    !
    character(len=*), parameter :: rname='IODESC>IMPORT'
    !
    call cubeio_message(ioseve%trace,rname,'Welcome')
    !
    iodesc%iscplx = in%array_type.eq.fmt_c4
    iodesc%n1 = max(in%axset_dim(1),1)
    iodesc%n2 = max(in%axset_dim(2),1)
    iodesc%n3 = max(in%axset_dim(3),1)
    if (in%axset_ix.eq.1 .and. in%axset_iy.eq.2) then
      iodesc%order = code_cube_imaset
      iodesc%nx = iodesc%n1
      iodesc%ny = iodesc%n2
      iodesc%nc = iodesc%n3
    elseif (in%axset_ic.eq.1) then
      iodesc%order = code_cube_speset
      iodesc%nx = iodesc%n2
      iodesc%ny = iodesc%n3
      iodesc%nc = iodesc%n1
    else
      call cubeio_message(seve%w,rname,'Unrecognized order')
      call cubeio_iodesc_unrecognized(iodesc,error)
      if (error)  return
    endif
  end subroutine cubeio_iodesc_import
  !
  subroutine cubeio_iodesc_unrecognized(iodesc,error)
    !-------------------------------------------------------------------
    ! Set the descriptor as unrecognized order. Mostly unusable, except
    ! for basic operations like HEADER command
    !-------------------------------------------------------------------
    type(cubeio_desc_t), intent(inout) :: iodesc
    logical,             intent(inout) :: error
    !
    iodesc%order = code_cube_unkset
    iodesc%nx = 1
    iodesc%ny = 1
    iodesc%nc = 1
  end subroutine cubeio_iodesc_unrecognized
  !
end module cubeio_header_iodesc
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
