!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeadm_init
  use cubetools_header_types
  use cubedag_types
  use cube_types
  use cubeadm_messaging
  use cubeadm_snapshot
  use cubeadm_timing
  !
  integer(kind=4) :: code_ftype_cube=0  ! cube_t identifier in the DAG (initialized at init)
  integer(kind=4) :: code_ftype_uv=0    ! uv_t identifier in the DAG (initialized at init)
  !
  public :: code_ftype_cube,code_ftype_uv
  public :: cubeadm_library_init
  private
  !
contains
  !
  subroutine cubeadm_library_init(error)
    use gkernel_interfaces
    use cubedag_library
    use cubedag_type
    use cubeadm_directory_type
    !---------------------------------------------------------------------
    ! Initialize the ADM library
    !---------------------------------------------------------------------
    logical, intent(inout) :: error
    ! Local
    integer(kind=4) :: ier
    logical :: autoreimport
    !
    ! Initialization of Directories list buffer
    call dir%init(error)
    if (error) return
    call dir%sicdef(error)
    if (error) return
    !
    ! *** JP I don't understand why the cubedag_init is here and
    ! *** JP cubedag_exit is in lib/cube/package.f90?
    call cubedag_init(error)
    if (error)  return
    call cubedag_type_register('CUBE','cube',cubeadm_cube_allocate,&
                               cubeadm_cube_deallocate,code_ftype_cube,error)
    if (error)  return
    call cubedag_type_register('UV','uv',cubeadm_uv_allocate,&
                               cubeadm_uv_deallocate,code_ftype_uv,error)
    if (error)  return
    !
    ! Implicit import of the previous snapshot, if any
    autoreimport = .true.
    ier = sic_getlog('CUBE_REIMPORT_AUTO',autoreimport)
    if (autoreimport) then
      call cubeadm_snapshot_reimport(cubeadm_snapshot_dagname(),  &
                                    cubeadm_snapshot_histname(),  &
                                    .true.,error)
      if (error) then
        ! We should not stop the program initialization...
        error = .false.
      endif
    endif
    !
    call cubeadm_timing_variables(error)
    if (error)  return
    !
  end subroutine cubeadm_library_init
  !
  subroutine cubeadm_cube_allocate(object,error)
    use cube_types
    use cubeadm_setup
    !---------------------------------------------------------------------
    ! Allocate and initialize a 'cube_t' in memory
    !---------------------------------------------------------------------
    class(cubedag_node_object_t), pointer       :: object
    logical,                      intent(inout) :: error
    !
    object => cube_allocate_new(cubset,error)
    if (error)  return
  end subroutine cubeadm_cube_allocate
  !
  subroutine cubeadm_cube_deallocate(object,error)
    !-------------------------------------------------------------------
    ! Finalize and deallocate a 'cube_t' in memory
    !-------------------------------------------------------------------
    class(cubedag_node_object_t), pointer       :: object
    logical,                      intent(inout) :: error
    ! Local
    character(len=*), parameter :: rname='ADM>DEALLOCATE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    if (.not.associated(object)) then
      call cubeadm_message(seve%e,rname,'Internal error: object is not allocated')
      error = .true.
      return
    endif
    deallocate(object)  ! NB: deallocation is polymorphic: we are deallocating
                        ! a cube_t, which invokes implicitly its FINAL procedure
  end subroutine cubeadm_cube_deallocate
  !
  subroutine cubeadm_uv_allocate(object,error)
    use cubetuple_uv
    use cubeadm_setup
    !---------------------------------------------------------------------
    ! Allocate and initialize a 'uv_t' in memory
    !---------------------------------------------------------------------
    class(cubedag_node_object_t), pointer       :: object
    logical,                      intent(inout) :: error
    !
    object => uv_allocate_new(cubset,error)
    if (error)  return
  end subroutine cubeadm_uv_allocate
  !
  subroutine cubeadm_uv_deallocate(object,error)
    !-------------------------------------------------------------------
    ! Finalize and deallocate a 'uv_t' in memory
    !-------------------------------------------------------------------
    class(cubedag_node_object_t), pointer       :: object
    logical,                      intent(inout) :: error
    ! Local
    character(len=*), parameter :: rname='ADM>DEALLOCATE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    if (.not.associated(object)) then
      call cubeadm_message(seve%e,rname,'Internal error: object is not allocated')
      error = .true.
      return
    endif
    deallocate(object)  ! NB: deallocation is polymorphic: we are deallocating
                        ! a uv_t, which invokes implicitly its FINAL procedure
  end subroutine cubeadm_uv_deallocate

end module cubeadm_init
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
