!
!     $Id: modulePakoLimits.f90,v 1.2 2005/06/22 14:46:29 ungerech Exp $
!     
!----------------------------------------------------------------------
!     PAKO 
!
! <DOCUMENTATION name="moduleGlobalVariables">
!
! 
! 
!
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
! 
!
! 
!
! </DOCUMENTATION> <!-- name="moduleGlobalVariables" -->
!
Module modulePakoLimits
  !
  Use modulePakoMessages
  Use modulePakoGlobalParameters
  !
  Implicit None
  Save
  Private
  !
  Public :: checkNofParameters
  Public :: checkI4
  Public :: checkI4co
  Public :: checkR4, checkR4angle
  Public :: checkR8
  Public :: checkR4co
  Public :: checkR8co
  !
Contains
!!!
!!!
  Subroutine checkNofParameters(command,  &
    &     minNo,  &
    &     maxNo,  &
    &     nArguments,  &
    &     error)
    !
    Character   command*12
    Integer     minNo, maxNo
    Integer     nArguments
    Logical     error
    !
    Integer     SIC_NARG
    !
    Character  messageText*128
    !
    error = .False.
    !
    nArguments = SIC_NARG(0)
    !
    If (minNo.Eq.0 .And. maxNo.Eq.0 &
       &     .And. nArguments.Gt.maxNo) Then
       messageText = "no parameters allowed"
       Call PakoMessage(6,3,command,messageText)
       error = .True.
    Else If (nArguments.Lt.minNo) Then
       If (minNo.Eq.1) Then
          Write (messageText,*)  &
          &           "at least ","one"," parameter required"
       Else If (minNo.Ge.2) Then
          Write (messageText,*)  &
          &           "at least ",minNo," parameters required"
       End If
       Call PakoMessage(6,3,command,messageText)
       error = .True.
    Else If (nArguments.Gt.maxNo) Then
       If (maxNo.Eq.1) Then
          Write (messageText,*)  &
          &           "no more then ","one"," parameter allowed"
       Else If (maxNo.Ge.2) Then
          Write (messageText,*)  &
          &           "no more then ",maxNo," parameters allowed"
       End If
       Call PakoMessage(6,3,command,messageText)
       error = .True.
    End If
    !
    Return
  End Subroutine checkNofParameters
!!!
!!!
  Subroutine checkI4(command,vIn,  &
    &     variable,  &
    &     error)
    !
    !
    Include 'inc/ranges/headerForCheckLimits.inc'
    !
    Integer     vIn                                   
    Integer     variable(nDimValuesI)
    Integer     vStdMin, vStdMax, vLimitMin, vLimitMax
    !
    Include 'inc/ranges/checkLimits.inc'
    !
    Return
  End Subroutine checkI4
!!!
!!!
  Subroutine checkI4co(command,option,vIn,  &
    &     variable,  &
    &     error)
    !
    !
    Include 'inc/ranges/headerForCheckLimits.inc'
    !
    Integer     vIn                                   
    Integer     variable(nDimValuesI)
    Integer     vStdMin, vStdMax, vLimitMin, vLimitMax
    !
    Include 'inc/ranges/checkLimits.inc'
    !
    Return
  End Subroutine checkI4co
!!!
!!!
  Subroutine checkR4(command,vIn,  &
    &     variable,  &
    &     error)
    !
    Include 'inc/ranges/headerForCheckLimits.inc'
    !
    Real(Kind=4)      vIn                                   
    Real(Kind=4)      variable(nDimValuesR)
    Real(Kind=4)      vStdMin, vStdMax, vLimitMin, vLimitMax
    !
    !D    Write (6,*) "   --> SR checkR4: "
    !
    Include 'inc/ranges/checkLimits.inc'
    !
    Return
  End Subroutine checkR4
!!!
!!!
  Subroutine checkR4angle(command,vIn,  &
    &     variable,  &
    &     angleFactor,   &
    &     error)
    !
    Include 'inc/ranges/headerForCheckLimits.inc'
    !
    Real(Kind=4)     angleFactor
    !
    Real(Kind=4)      vIn                                   
    Real(Kind=4)      variable(nDimValuesR)
    Real(Kind=4)      vStdMin, vStdMax, vLimitMin, vLimitMax
    !
    !D    Write (6,*) "   --> SR checkR4angle: "
    !D    Write (6,*) "          angleFactor = ", angleFactor
    !
    vIn = vIn*angleFactor
    !
    Include 'inc/ranges/checkLimitsAngle.inc'
    !
    !D    Write (6,*) "          angleFactor = ", angleFactor
    !
    Return
  End Subroutine checkR4angle
!!!
!!!
  Subroutine checkR8(command,vIn, &
    &     variable, &
    &     error)
    !
    Include 'inc/ranges/headerForCheckLimits.inc'
    !
    Real(Kind=8)        vIn                                   
    Real(Kind=8)        variable(nDimValuesR)
    Real(Kind=8)        vStdMin, vStdMax, vLimitMin, vLimitMax
    !
    Include 'inc/ranges/checkLimits.inc'
    !
    Return
  End Subroutine checkR8
!!!
!!!
  Subroutine checkR4co(command,option,vIn,  &
    &     variable,  &
    &     error)
    !
    Include 'inc/ranges/headerForCheckLimits.inc'
    !
    Real(Kind=4)      vIn                                   
    Real(Kind=4)      variable(nDimValuesR)
    Real(Kind=4)      vStdMin, vStdMax, vLimitMin, vLimitMax
    !
    Include 'inc/ranges/checkLimits.inc'
    !
    Return
  End Subroutine checkR4co
!!!
!!!
  Subroutine checkR8co(command,option,vIn,  &
    &     variable,  &
    &     error)
    !
    Include 'inc/ranges/headerForCheckLimits.inc'
    !
    Real(Kind=8)        vIn                                   
    Real(Kind=8)        variable(nDimValuesR)
    Real(Kind=8)        vStdMin, vStdMax, vLimitMin, vLimitMax
    !
    Include 'inc/ranges/checkLimits.inc'
    !
    Return
  End Subroutine checkR8co
  !
End Module modulePakoLimits
