subroutine class_diff(line,error,user_function)
  use gbl_message
  use classcore_dependencies_interfaces
  use classcore_interfaces, except_this=>class_diff
  use class_data
  !---------------------------------------------------------------------
  ! @ private
  !  Support routine for command
  !    EXPERIM\DIFF [Num1 Num2]
  !  Print the differences between 2 observations
  !---------------------------------------------------------------------
  character(len=*), intent(in)    :: line
  logical,          intent(inout) :: error
  logical,          external      :: user_function
  ! Local
  character(len=*), parameter :: rname='DIFF'
  integer(kind=obsnum_length) :: num
  integer(kind=entry_length) :: kx
  type(observation) :: obs(2)
  integer(kind=4) :: iarg
  logical :: found
  character(len=message_length) :: mess
  !
  if (sic_narg(0).ne.0 .and. sic_narg(0).ne.2) then
    call class_message(seve%e,rname,'Command expects 0 or 2 arguments')
    error = .true.
    return
  endif
  !
  if (sic_narg(0).eq.0) then
    ! 0 argument: use R and T
    if (r%head%xnum.eq.0) then
      call class_message(seve%e,rname,'No R spectrum in memory')
      error = .true.
      return
    endif
    if (t%head%xnum.eq.0) then
      call class_message(seve%e,rname,'No T spectrum in memory')
      error = .true.
      return
    endif
    call class_diff_head(r%head,t%head,error)
    if (error)  return
    !
  else
    ! 2 arguments: observation numbers from current input file
    call init_obs(obs(1))
    call init_obs(obs(2))
    !
    do iarg=1,2
      call sic_i0(line,0,iarg,num,.true.,error)
      if (error)  return
      !
      call get_num_ix(num,0,found,kx,error)
      if (error)  return
      if (.not.found) then
        write(mess,'(A,I0,A)')  'Observation #',num,' not found'
        call class_message(seve%e,rname,mess)
        error = .true.
        return
      endif
      call rheader(obs(iarg),kx,user_function,error)
      if (error)  return
    enddo
    !
    call class_diff_head(obs(1)%head,obs(2)%head,error)
    if (error)  return
    !
    call free_obs(obs(1))
    call free_obs(obs(2))
  endif
  !
end subroutine class_diff
!
subroutine class_diff_head(a,b,error)
  use class_types
  use classcore_interfaces, except_this=>class_diff_head
  !---------------------------------------------------------------------
  ! @ private
  !  Print the differences between 2 observations
  !---------------------------------------------------------------------
  type(header), intent(in)    :: a,b
  logical,      intent(inout) :: error
  !
  call class_diff_gen(a,b,error)
  if (error)  return
  call class_diff_pos(a,b,error)
  if (error)  return
  call class_diff_spe(a,b,error)
  if (error)  return
  call class_diff_cal(a,b,error)
  if (error)  return
  call class_diff_swi(a,b,error)
  if (error)  return
  !
end subroutine class_diff_head
!
subroutine class_diff_gen(a,b,error)
  use gbl_message
  use classcore_interfaces, except_this=>class_diff_gen
  use class_types
  !---------------------------------------------------------------------
  ! @ private
  !  Print the differences between 2 observations (section GENERAL)
  !---------------------------------------------------------------------
  type(header), intent(in)    :: a,b
  logical,      intent(inout) :: error
  ! Local
  character(len=*), parameter :: secname='General'
  logical :: secwarned
  !
  if (class_diff_presec(class_sec_gen_id,secname,a,b))  return
  !
  secwarned = .false.
  ! No diff for NUM
  ! No diff for VERSION
  call class_diff_elem(secname,secwarned,'Telescope names:',a%gen%teles,b%gen%teles)
  call class_diff_elem(secname,secwarned,'Observation dates:',a%gen%cdobs,b%gen%cdobs)
  call class_diff_elem(secname,secwarned,'Reduction dates:',a%gen%cdred,b%gen%cdred)
  call class_diff_elem(secname,secwarned,'Kind of data:',a%gen%kind,b%gen%kind)
  call class_diff_elem(secname,secwarned,'Quality of data:',a%gen%qual,b%gen%qual)
  call class_diff_elem(secname,secwarned,'Scan numbers:',a%gen%scan,b%gen%scan)
  call class_diff_elem(secname,secwarned,'Subscan numbers:',a%gen%subscan,b%gen%subscan)
  call class_diff_elem(secname,secwarned,'Observation UT:',a%gen%ut,b%gen%ut)
  call class_diff_elem(secname,secwarned,'Observation LST:',a%gen%st,b%gen%st)
  call class_diff_elem(secname,secwarned,'Azimuths:',a%gen%az,b%gen%az)
  call class_diff_elem(secname,secwarned,'Elevations:',a%gen%el,b%gen%el)
  call class_diff_elem(secname,secwarned,'Opacities:',a%gen%tau,b%gen%tau)
  call class_diff_elem(secname,secwarned,'System temperature:',a%gen%tsys,b%gen%tsys)
  call class_diff_elem(secname,secwarned,'Integration time:',a%gen%time,b%gen%time)
  call class_diff_elem(secname,secwarned,'Y scale units:',a%gen%yunit,b%gen%yunit)
  !
end subroutine class_diff_gen
!
subroutine class_diff_pos(a,b,error)
  use gbl_message
  use classcore_dependencies_interfaces
  use classcore_interfaces, except_this=>class_diff_pos
  use class_types
  !---------------------------------------------------------------------
  ! @ private
  !  Print the differences between 2 observations (section POSITION)
  !---------------------------------------------------------------------
  type(header), intent(in)    :: a,b
  logical,      intent(inout) :: error
  ! Local
  character(len=*), parameter :: secname='Position'
  logical :: secwarned
  !
  if (class_diff_presec(class_sec_pos_id,secname,a,b))  return
  !
  secwarned = .false.
  call class_diff_elem(secname,secwarned,'Source names:',a%pos%sourc,b%pos%sourc)
  call class_diff_elem(secname,secwarned,'Systems:',obs_system(a%pos%system),obs_system(b%pos%system))
  call class_diff_elem(secname,secwarned,'Equinoxes:',a%pos%equinox,b%pos%equinox)
  call class_diff_elem(secname,secwarned,'Projection kinds:',projnam(a%pos%proj),projnam(b%pos%proj))
  call class_diff_elem(secname,secwarned,'Lambda positions:',a%pos%lam,b%pos%lam)
  call class_diff_elem(secname,secwarned,'Beta positions:',a%pos%bet,b%pos%bet)
  call class_diff_elem(secname,secwarned,'Projection angles:',a%pos%projang,b%pos%projang)
  call class_diff_elem(secname,secwarned,'Lambda offsets:',a%pos%lamof,b%pos%lamof)
  call class_diff_elem(secname,secwarned,'Beta offsets:',a%pos%betof,b%pos%betof)
  !
end subroutine class_diff_pos
!
subroutine class_diff_spe(a,b,error)
  use gbl_message
  use classcore_interfaces, except_this=>class_diff_spe
  use class_types
  !---------------------------------------------------------------------
  ! @ private
  !  Print the differences between 2 observations (section SPECTROSCOPY)
  !---------------------------------------------------------------------
  type(header), intent(in)    :: a,b
  logical,      intent(inout) :: error
  ! Local
  character(len=*), parameter :: secname='Spectroscopic'
  logical :: secwarned
  !
  if (class_diff_presec(class_sec_spe_id,secname,a,b))  return
  !
  secwarned = .false.
  call class_diff_elem(secname,secwarned,'Line names:',a%spe%line,b%spe%line)
  call class_diff_elem(secname,secwarned,'Number of channels:',a%spe%nchan,b%spe%nchan)
  call class_diff_elem(secname,secwarned,'Rest frequencies:',a%spe%restf,b%spe%restf)
  call class_diff_elem(secname,secwarned,'Image frequencies:',a%spe%image,b%spe%image)
  call class_diff_elem(secname,secwarned,'Doppler factors:',a%spe%doppler,b%spe%doppler)
  call class_diff_elem(secname,secwarned,'Reference channels:',a%spe%rchan,b%spe%rchan)
  call class_diff_elem(secname,secwarned,'Frequency resolutions:',a%spe%fres,b%spe%fres)
  call class_diff_elem(secname,secwarned,'Velocity resolutions:',a%spe%vres,b%spe%vres)
  call class_diff_elem(secname,secwarned,'Velocity offsets:',a%spe%voff,b%spe%voff)
  call class_diff_elem(secname,secwarned,'Bad values:',a%spe%bad,b%spe%bad)
  call class_diff_elem(secname,secwarned,'Velocity types:',obs_typev(a%spe%vtype),obs_typev(b%spe%vtype))
  call class_diff_elem(secname,secwarned,'Velocity conventions:',a%spe%vconv,b%spe%vconv)
  !
end subroutine class_diff_spe
!
subroutine class_diff_cal(a,b,error)
  use gbl_message
  use classcore_interfaces, except_this=>class_diff_cal
  use class_types
  !---------------------------------------------------------------------
  ! @ private
  !  Print the differences between 2 observations (section CALIBRATION)
  !---------------------------------------------------------------------
  type(header), intent(in)    :: a,b
  logical,      intent(inout) :: error
  ! Local
  character(len=*), parameter :: secname='Calibration'
  logical :: secwarned
  !
  if (class_diff_presec(class_sec_cal_id,secname,a,b))  return
  !
  secwarned = .false.
  call class_diff_elem(secname,secwarned,'Beam efficiencies:',a%cal%beeff,b%cal%beeff)
  call class_diff_elem(secname,secwarned,'Forward efficiencies:',a%cal%foeff,b%cal%foeff)
  call class_diff_elem(secname,secwarned,'Gain ratios:',a%cal%gaini,b%cal%gaini)
  call class_diff_elem(secname,secwarned,'Water vapor amounts:',a%cal%h2omm,b%cal%h2omm)
  call class_diff_elem(secname,secwarned,'Ambient pressures:',a%cal%pamb,b%cal%pamb)
  call class_diff_elem(secname,secwarned,'Ambient temperatures:',a%cal%tamb,b%cal%tamb)
  call class_diff_elem(secname,secwarned,'Signal atmosp. temperatures:',a%cal%tatms,b%cal%tatms)
  call class_diff_elem(secname,secwarned,'Chopper temperatures:',a%cal%tchop,b%cal%tchop)
  call class_diff_elem(secname,secwarned,'Cold load temperatures:',a%cal%tcold,b%cal%tcold)
  call class_diff_elem(secname,secwarned,'Signal band opacities:',a%cal%taus,b%cal%taus)
  call class_diff_elem(secname,secwarned,'Image band opacities:',a%cal%taui,b%cal%taui)
  call class_diff_elem(secname,secwarned,'Image atmosp. temperatures:',a%cal%tatmi,b%cal%tatmi)
  call class_diff_elem(secname,secwarned,'Receiver temperatures:',a%cal%trec,b%cal%trec)
  call class_diff_elem(secname,secwarned,'Calibration modes:',a%cal%cmode,b%cal%cmode)
  call class_diff_elem(secname,secwarned,'Calibration factors:',a%cal%atfac,b%cal%atfac)
  call class_diff_elem(secname,secwarned,'Site altitudes:',a%cal%alti,b%cal%alti)
  call class_diff_elem(secname,secwarned,'Atmosphere power:',a%cal%count(1),b%cal%count(1))
  call class_diff_elem(secname,secwarned,'Chopper power:',a%cal%count(2),b%cal%count(2))
  call class_diff_elem(secname,secwarned,'Cold load power:',a%cal%count(3),b%cal%count(3))
  call class_diff_elem(secname,secwarned,'Lambda offsets for sky:',a%cal%lcalof,b%cal%lcalof)
  call class_diff_elem(secname,secwarned,'Beta offsets for sky:',a%cal%bcalof,b%cal%bcalof)
  call class_diff_elem(secname,secwarned,'Observatory longitude:',a%cal%geolong,b%cal%geolong)
  call class_diff_elem(secname,secwarned,'Observatory latitude:',a%cal%geolat,b%cal%geolat)
  !
end subroutine class_diff_cal
!
subroutine class_diff_swi(a,b,error)
  use gbl_message
  use classcore_dependencies_interfaces
  use classcore_interfaces, except_this=>class_diff_swi
  use class_types
  !---------------------------------------------------------------------
  ! @ private
  !  Print the differences between 2 observations (section SWITCHING)
  !---------------------------------------------------------------------
  type(header), intent(in)    :: a,b
  logical,      intent(inout) :: error
  ! Local
  character(len=*), parameter :: secname='Switching'
  logical :: secwarned
  character(len=64) :: elname
  integer(kind=4) :: iphas
  !
  if (class_diff_presec(class_sec_swi_id,secname,a,b))  return
  !
  secwarned = .false.
  call class_diff_elem(secname,secwarned,'Switching modes:',a%swi%swmod,b%swi%swmod)
  call class_diff_elem(secname,secwarned,'Number of phases:',a%swi%nphas,b%swi%nphas)
  do iphas=1,min(a%swi%nphas,b%swi%nphas)
    write(elname,'(A,I0,A)') 'Freq. offsets phase #',iphas,':'
    call class_diff_elem(secname,secwarned,elname,a%swi%decal(iphas),b%swi%decal(iphas))
    write(elname,'(A,I0,A)') 'Integ. times phase #',iphas,':'
    call class_diff_elem(secname,secwarned,elname,a%swi%duree(iphas),b%swi%duree(iphas))
    write(elname,'(A,I0,A)') 'Weights phase #',iphas,':'
    call class_diff_elem(secname,secwarned,elname,a%swi%poids(iphas),b%swi%poids(iphas))
    write(elname,'(A,I0,A)') 'Lambda offsets phase #',iphas,':'
    call class_diff_elem(secname,secwarned,elname,a%swi%ldecal(iphas),b%swi%ldecal(iphas))
    write(elname,'(A,I0,A)') 'Beta offsets phase #',iphas,':'
    call class_diff_elem(secname,secwarned,elname,a%swi%bdecal(iphas),b%swi%bdecal(iphas))
  enddo
  !
end subroutine class_diff_swi
!
!--- Generic utilities follow ------------------------------------------
!
function class_diff_presec(secid,secname,a,b)
  use gbl_message
  use classcore_interfaces, except_this=>class_diff_presec
  use class_types
  !---------------------------------------------------------------------
  ! @ private
  ! Return .true. if the section is absent from 1 or frome the 2 headers
  !---------------------------------------------------------------------
  logical :: class_diff_presec
  integer(kind=4),  intent(in) :: secid    ! Section code
  character(len=*), intent(in) :: secname  !
  type(header),     intent(in) :: a,b      !
  !
  if (.not.a%presec(secid) .and. .not.b%presec(secid)) then
    class_diff_presec = .true.
  elseif (a%presec(secid) .and. .not.b%presec(secid)) then
    call class_message(seve%r,'DIFF','Only in first observation: '//(secname)//' section')
    class_diff_presec = .true.
  elseif (.not.a%presec(secid) .and. b%presec(secid)) then
    call class_message(seve%r,'DIFF','Only in second observation: '//(secname)//' section')
    class_diff_presec = .true.
  else
    class_diff_presec = .false.
  endif
  !
end function class_diff_presec
!
subroutine class_diff_char(secname,secwarned,elemname,a,b)
  use gbl_message
  use classcore_interfaces, except_this=>class_diff_char
  !---------------------------------------------------------------------
  ! @ private-generic class_diff_elem
  !---------------------------------------------------------------------
  character(len=*), intent(in)    :: secname
  logical,          intent(inout) :: secwarned
  character(len=*), intent(in)    :: elemname
  character(len=*), intent(in)    :: a,b
  ! Local
  character(len=message_length) :: mess
  !
  if (a.eq.b)  return
  !
  if (.not.secwarned) then
    call class_message(seve%r,'DIFF',secname//' sections differ')
    secwarned = .true.
  endif
  !
  write(mess,10)  elemname,a,b
  call class_message(seve%r,'DIFF',mess)
  !
10 format(2X,A,T32,A,T52,A)
end subroutine class_diff_char
!
subroutine class_diff_inte(secname,secwarned,elemname,a,b)
  use gbl_message
  use classcore_interfaces, except_this=>class_diff_inte
  !---------------------------------------------------------------------
  ! @ private-generic class_diff_elem
  !---------------------------------------------------------------------
  character(len=*), intent(in)    :: secname
  logical,          intent(inout) :: secwarned
  character(len=*), intent(in)    :: elemname
  integer(kind=4),  intent(in)    :: a,b
  ! Local
  character(len=message_length) :: mess
  !
  if (a.eq.b)  return
  !
  if (.not.secwarned) then
    call class_message(seve%r,'DIFF',secname//' sections differ')
    secwarned = .true.
  endif
  !
  write(mess,10)  elemname,a,b
  call class_message(seve%r,'DIFF',mess)
  !
10 format(2X,A,T32,I0,T52,I0)
end subroutine class_diff_inte
!
subroutine class_diff_long(secname,secwarned,elemname,a,b)
  use gbl_message
  use classcore_interfaces, except_this=>class_diff_long
  !---------------------------------------------------------------------
  ! @ private-generic class_diff_elem
  !---------------------------------------------------------------------
  character(len=*), intent(in)    :: secname
  logical,          intent(inout) :: secwarned
  character(len=*), intent(in)    :: elemname
  integer(kind=8),  intent(in)    :: a,b
  ! Local
  character(len=message_length) :: mess
  !
  if (a.eq.b)  return
  !
  if (.not.secwarned) then
    call class_message(seve%r,'DIFF',secname//' sections differ')
    secwarned = .true.
  endif
  !
  write(mess,10)  elemname,a,b
  call class_message(seve%r,'DIFF',mess)
  !
10 format(2X,A,T32,I0,T52,I0)
end subroutine class_diff_long
!
subroutine class_diff_real(secname,secwarned,elemname,a,b)
  use gbl_message
  use classcore_interfaces, except_this=>class_diff_real
  !---------------------------------------------------------------------
  ! @ private-generic class_diff_elem
  !---------------------------------------------------------------------
  character(len=*), intent(in)    :: secname
  logical,          intent(inout) :: secwarned
  character(len=*), intent(in)    :: elemname
  real(kind=4),     intent(in)    :: a,b
  ! Local
  character(len=message_length) :: mess
  !
  if (a.eq.b)  return
  !
  if (.not.secwarned) then
    call class_message(seve%r,'DIFF',secname//' sections differ')
    secwarned = .true.
  endif
  !
  write(mess,10)  elemname,a,b
  call class_message(seve%r,'DIFF',mess)
  !
10 format(2X,A,T32,1PG12.5,T52,1PG12.5)
end subroutine class_diff_real
!
subroutine class_diff_dble(secname,secwarned,elemname,a,b)
  use gbl_message
  use classcore_interfaces, except_this=>class_diff_dble
  !---------------------------------------------------------------------
  ! @ private-generic class_diff_elem
  !---------------------------------------------------------------------
  character(len=*), intent(in)    :: secname
  logical,          intent(inout) :: secwarned
  character(len=*), intent(in)    :: elemname
  real(kind=8),     intent(in)    :: a,b
  ! Local
  character(len=message_length) :: mess
  !
  if (a.eq.b)  return
  !
  if (.not.secwarned) then
    call class_message(seve%r,'DIFF',secname//' sections differ')
    secwarned = .true.
  endif
  !
  write(mess,10)  elemname,a,b
  call class_message(seve%r,'DIFF',mess)
  !
10 format(2X,A,T32,1PG19.12,T52,1PG19.12)
end subroutine class_diff_dble
