subroutine gfits_getreal(ndat,array,scal,zero,error)
  use gildas_def
  use gio_interfaces
  use gio_fitsdef
  use gbl_message
  !---------------------------------------------------------------------
  ! @ no-interface (rank mismatch for input 'data')
  ! FITS Internal routine
  !      Read NDAT data values from FITS data area, 
  !      with scaling SCALE and offset ZERO
  !---------------------------------------------------------------------
  integer(kind=size_length), intent(in)    :: ndat        ! Number of desired data values
  real(kind=4),              intent(inout) :: array(ndat) ! Data values
  real(kind=4),              intent(in)    :: scal        ! Scale factor
  real(kind=4),              intent(in)    :: zero        ! Offset
  logical,                   intent(out)   :: error       ! Error flag
  ! Local
  integer(kind=size_length) :: nsize,nfill,nbyt
  integer(kind=size_length), save :: mbyt=0
  integer(kind=1), allocatable, save :: mybuf(:)
  integer :: ier
  character(len=60) :: mess
  !
  error = .false.
  !
  select case (nbit)
    case (8)
      nbyt = ndat
    case (16)
      nbyt = 2_8*ndat
    case (32,-32)
      nbyt = 4_8*ndat
    case (-64)
      nbyt = 8_8*ndat
    case default
      write(mess,*) 'BITPIX = ',nbit,' not yet supported'
      call gio_message(seve%e,'GETREAL',mess)
      error = .true.
      return
  end select
  !
  if (nbyt.gt.mbyt) then
    if (mbyt.ne.0) deallocate(mybuf)
    allocate (mybuf(nbyt),stat=ier)
    if (ier.ne.0) then
      write(mess,*) 'Allocation error ',ier,mbyt
      call gio_message(seve%e,'GETREAL',mess)
      error = .true.
      return 
    endif
    mbyt = nbyt
  endif
  !
  call gfits_getbuf(mybuf,nbyt,error)
  if (error) return
  !
  nfill = 0
  nsize = ndat
  !
  select case (nbit)
    case (8)
      call byte_to_real(mybuf,ndat,array,nsize,nfill,scal,zero)
    case (16)
      call int2_to_real(mybuf,ndat,array,nsize,nfill,scal,zero)
    case (32)
      call int4_to_real(mybuf,ndat,array,nsize,nfill,scal,zero)
    case (-32)
      call ieee32_to_real(mybuf,ndat,array,nsize,nfill,scal,zero,bval0)
    case (-64)
      call ieee64_to_real(mybuf,ndat,array,nsize,nfill,scal,zero,bval0)
  end select
end subroutine gfits_getreal
!
subroutine gfits_putbuf(int1,nr,error)
  use gio_interfaces, only : gfits_putrec
  use gio_fitsio
  !---------------------------------------------------------------------
  ! @ public
  ! FITS API routine
  !      Write one row of a binary table to a FITS logical record
  !---------------------------------------------------------------------
  integer, intent(in) :: nr                ! Length of buffer
  integer(kind=1), intent(in) :: int1(nr)  ! Buffer
  logical, intent(out) :: error            ! Error flag
  ! Local
  integer :: j, kb
  !
  error = .false.
  if ((nr+ib).lt.2880) then
    ! fits into current buffer
    call bytoby(int1,buffer(ib+1),nr)
    ib = ib+nr
  else
    ! Would overflow buffer: will have to write to disk or tape
    ! Fill in previous buffer, and dump it to physical medium
    if (ib.ne.0) then
      call bytoby(int1,buffer(ib+1),2880-ib)
      call gfits_putrec(buffer,error)
      kb = 2880-ib
    else
      call gfits_putrec(int1,error)
      kb = 2880
    endif
    if (error) return
    kb = kb+1
    ! Now dump full buffers (double buffering is useless here)
    do j = 2880-ib+1, nr-2880+1, 2880
      call gfits_putrec(int1(kb),error)
      if (error) return
      kb = kb + 2880
    enddo
    ! Store leftover bits
    ib = nr-kb+1
    if (ib.gt.0) call bytoby(int1(kb),buffer(1),ib)
  endif
end subroutine gfits_putbuf
!
subroutine gfits_getbuf(int1,nr,error)
  use gildas_def
  use gio_interfaces, only : gfits_getrec
  use gio_fitsio
  !---------------------------------------------------------------------
  ! @ no-interface (because of argument type mismatch)
  !       Get one row of a binary table from a FITS logical record
  !---------------------------------------------------------------------
  integer(kind=size_length), intent(in)    :: nr        ! Length of buffer
  integer(kind=1),           intent(inout) :: int1(nr)  ! Buffer
  logical,                   intent(inout) :: error     ! Error flag
  ! Local
  integer(kind=size_length) :: j, kb
  !
  if (nr+ib.le.2880) then
    ! Already in prefetch buffer
    call bytoby_sl(buffer(ib+1),int1,nr)
    ib = ib+nr
  else
    ! Will need to read from disk
    ! Empty previous buffer
    if (ib.lt.2880) then 
      call bytoby(buffer(ib+1),int1,2880-ib)
      kb = 2880-ib+1
    else
      kb = 1
    endif
    ! Now read full buffers from physical medium
    do j = 2880-ib+1, nr-2880, 2880
      call gfits_getrec(int1(kb:kb+2880-1),error)
      if (error) return
      kb = kb+2880
    enddo
    ! Read one more buffer, and move part of it.
    call gfits_getrec(buffer,error)
    if (error) return
    ib = nr-kb+1
    if (ib.gt.0) call bytoby(buffer(1),int1(kb),ib)
  endif
end subroutine gfits_getbuf
!
subroutine gfits_skibuf(nb,error)
  use gildas_def
  use gio_interfaces, only : gfits_skirec, gio_message
  use gio_fitsio
  use gbl_message
  !---------------------------------------------------------------------
  ! @ public
  ! FITS API routine
  !      Skip NB bytes on input file
  !---------------------------------------------------------------------
  integer(kind=size_length), intent(in)    :: nb     ! Bytes to skip
  logical,                   intent(inout) :: error  ! Error flag
  ! Local
  integer(kind=record_length) :: nrec
  character(len=message_length) :: mess
  !
  if (nb+ib.le.2880) then
    ! Remains within current buffer
    ib = ib+nb
  else 
    ! Need to skip records on input medium
    nrec = ((nb+ib)/2880)-1
    ! Make sure we can read the last record here
    if (nrec*2880.ge.nb) nrec = nrec-1 ! In case IB = 2880 at start
    call gfits_skirec(nrec,error)
    if (error) return
    ! Read last record, and set pointer
    call gfits_getrec(buffer,error)
    if (error) return
    ib = nb+ib-(nrec+1)*2880
    if (ib.lt.1.or.ib.gt.2880) then
      write(mess,*) 'Internal logic error. ',ib,nrec
      call gio_message(seve%e,'FSKIBUF',mess)
    endif
  endif
end subroutine gfits_skibuf
!
subroutine gfits_skidat (ndat,error)
  use gildas_def
  use gio_interfaces, only : gfits_skibuf, gio_message
  use gio_fitsdef
  use gbl_message
  !---------------------------------------------------------------------
  ! @ public
  ! FITS API routine
  !      Skip NDAT data values from FITS data area, 
  !---------------------------------------------------------------------
  integer(kind=size_length), intent(in) :: ndat  ! Number of desired data values
  logical, intent(out) :: error              ! Error flag
  ! Local
  integer(kind=size_length) :: nbyt
  character(len=60) :: mess
  !------------------------------------------------------------------------
  ! Code:
  error = .false.
  !
  select case (nbit)
    case (8)
      nbyt = ndat
    case (16)
      nbyt = 2*ndat
    case (32,-32)
      nbyt = 4*ndat
    case (-64)
      nbyt = 8*ndat
    case default
      write(mess,*) 'BITPIX = ',nbit,' not yet supported'
      call gio_message(seve%e,'FSKIDAT',mess)
      error = .true.
      return
  end select
  !
  call gfits_skibuf(nbyt,error)
end subroutine gfits_skidat
