!
!D      write (6,*)  "      receiver.f90 "
!
!D      If (vars(iValue,iBolo)%isConnected) Then
!D         Write (6,*) "      receiver.f90: Bolometer"
!D      End If
!
      Call pakoXMLwriteStartElement("RESOURCE","receivers",              &
     &                         comment="generated by paKo",              &
     &                         space ="before",                          &
     &                         error=errorXML)
!
      Call pakoXMLwriteStartElement("TABLE","receivers",                 &
     &                         error=errorXML)
!
      Call pakoXMLwriteElement("FIELD","receiverName",                   &
     &                         dataType="char",                          &
     &                         error=errorXML)
!
      If (vars(iValue,iBolo)%isConnected) Then
!
         Call pakoXMLwriteElement("FIELD","bolometerName",               &
              &                         dataType="char",                 &
              &                         error=errorXML)
!
         Call pakoXMLwriteElement("FIELD","nChannels",                   &
              &                         dataType="int",                  &
              &                         unit="--",                       &
              &                         error=errorXML)
!
         Call pakoXMLwriteElement("FIELD","gainBolometer",               &
              &                         dataType="float",                &
              &                         unit="--",                       &
              &                         error=errorXML)
!
         Call pakoXMLwriteElement("FIELD","channel",                     &
              &                         dataType="int",                  &
              &                         unit="--",                       &
              &                         error=errorXML)
!
      Else
!
      Call pakoXMLwriteElement("FIELD","lineName",                       &
     &                         dataType="char",                          &
     &                         error=errorXML)
!
      Call pakoXMLwriteElement("FIELD","frequency",                      &
     &                         dataType="double",                        &
     &                         unit="GHz",                               &
     &                         error=errorXML)
!
      Call pakoXMLwriteElement("FIELD","sideBand",                       &
     &                         dataType="char",                          &
     &                         error=errorXML)
!
      Call pakoXMLwriteElement("FIELD","doppler",                        &
     &                         dataType="char",                          &
     &                         error=errorXML)
!
      Call pakoXMLwriteElement("FIELD","width",                          &
     &                         dataType="char",                          &
     &                         error=errorXML)
!
      Call pakoXMLwriteElement("FIELD","gainImage",                      &
     &                         dataType="float",                         &
     &                         unit="--",                                &
     &                         error=errorXML)
!
      Call pakoXMLwriteElement("FIELD","tempCold",                       &
     &                         dataType="float",                         &
     &                         unit="K",                                 &
     &                         error=errorXML)
!
      Call pakoXMLwriteElement("FIELD","tempAmbient",                       &
     &                         dataType="float",                         &
     &                         unit="K",                                 &
     &                         error=errorXML)
!
      Call pakoXMLwriteElement("FIELD","effForward",                     &
     &                         dataType="float",                         &
     &                         unit="--",                                &
     &                         error=errorXML)
!
      Call pakoXMLwriteElement("FIELD","effBeam",                        &
     &                         dataType="float",                         &
     &                         unit="--",                                &
     &                         error=errorXML)
!
      Call pakoXMLwriteElement("FIELD","scale",                          &
     &                         dataType="char",                          &
     &                         error=errorXML)
!
      valueComment = "selected pixel"
      Call pakoXMLwriteElement("FIELD","iPixel",                          &
     &                         comment=valueComment,                     &
     &                         dataType="int",                          &
     &                         unit="--",                               &
     &                         error=errorXML)
!
      valueComment = "number of mulibeam pixels"
      Call pakoXMLwriteElement("FIELD","nPixels",                          &
     &                         comment=valueComment,                     &
     &                         dataType="int",                          &
     &                         unit="--",                               &
     &                         error=errorXML)
!
      Call pakoXMLwriteElement("FIELD","centerIF",                      &
     &                         dataType="double",                        &
     &                         unit="GHz",                               &
     &                         error=errorXML)
!
      Call pakoXMLwriteElement("FIELD","bandWidth",                      &
     &                         dataType="double",                        &
     &                         unit="GHz",                               &
     &                         error=errorXML)
!
      Call pakoXMLwriteElement("FIELD","distributionBoxInput",          &
     &                         dataType="int",                          &
     &                         unit="--",                               &
     &                         error=errorXML)
!
      Call pakoXMLwriteElement("FIELD","IF2",                            &
     &                         dataType="double",                        &
     &                         unit="GHz",                               &
     &                         error=errorXML)
!
      Call pakoXMLwriteElement("FIELD","isFlippingIF2",                            &
     &                         dataType="boolean",                        &
     &                         error=errorXML)
!
      Call pakoXMLwriteElement("FIELD","polarization",                   &
     &                         dataType="char",                          &
     &                         error=errorXML)
!
      Call pakoXMLwriteElement("FIELD","useSpecialLO",                    &
     &                         dataType="boolean",                        &
     &                         error=errorXML)
!
      End If
!
      Call pakoXMLwriteStartElement("DATA",                              &
     &                         error=errorXML)
!
      Call pakoXMLwriteStartElement("TABLEDATA",                         &
     &                         comment="generated by paKo",              &
     &                         error=errorXML)
!
! **
!
      If (vars(iValue,iBolo)%isConnected) Then
!
         ii = iBolo
!
                  Call pakoXMLwriteStartElement("TR",                    &
     &                         error=errorXML)
!
                  valueC = vars(iValue,ii)%name
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         error=errorXML)
!
                  valueC = vars(iValue,ii)%bolometerName
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         error=errorXML)
!
                  Write (valueC,'(I10)')                               &
     &                   vars(iValue,ii)%nChannels
                  valueComment = ''
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         comment=valueComment,                     &
     &                         error=errorXML)
!
                  Write (valueC,'(F20.6)')                               &
     &                   vars(iValue,ii)%gainBolometer
                  valueComment = ''
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         comment=valueComment,                     &
     &                         error=errorXML)
!
                  Write (valueC,'(I10)')                               &
     &                   vars(iValue,ii)%channel
                  valueComment = ''
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         comment=valueComment,                     &
     &                         error=errorXML)
!
                  Call pakoXMLwriteEndElement("TR",                      &
     &                         error=errorXML)
!
      Else
!
         Do ii = 1,nDimReceivers,1
            If (vars(iValue,ii)%isConnected) Then
                  Call pakoXMLwriteStartElement("TR",                    &
     &                         error=errorXML)
!
                  valueC = vars(iValue,ii)%name
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         error=errorXML)
!
                  valueC = vars(iValue,ii)%lineName
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         error=errorXML)
!
                  Write (valueC,'(F20.6)')                               &
     &                   vars(iValue,ii)%frequency%value
                  valueComment = 'GHz'
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         comment=valueComment,                     &
     &                         error=errorXML)
!
                  valueC = vars(iValue,ii)%sideBand
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         error=errorXML)
!
                  valueC = vars(iValue,ii)%frequency%doppler
                  Call pakoXMLcase(valueC,error=errorXML)
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         error=errorXML)
!
                  valueC = vars(iValue,ii)%width
                  Call pakoXMLcase(valueC,error=errorXML)
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         error=errorXML)
!
                  Write (valueC,'(F20.6)')                               &
     &                   vars(iValue,ii)%gainImage%value
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         error=errorXML)
!
                  Write (valueC,'(F20.6)')                               &
     &                   vars(iValue,ii)%tempCold
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         error=errorXML)
!
                  Write (valueC,'(F20.6)')                               &
     &                   vars(iValue,ii)%tempAmbient
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         error=errorXML)
!
                  Write (valueC,'(F20.6)')                               &
     &                   vars(iValue,ii)%effForward
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         error=errorXML)
!
                  Write (valueC,'(F20.6)')                               &
     &                   vars(iValue,ii)%effBeam
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         error=errorXML)
!
                  valueC = vars(iValue,ii)%scale
                  Call pakoXMLcase(valueC,error=errorXML)
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         error=errorXML)
!
                  Write (valueC,'(I5)')                               &
     &                   vars(iValue,ii)%iPixel
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         error=errorXML)
!
                  Write (valueC,'(I5)')                               &
     &                   vars(iValue,ii)%nPixels
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         error=errorXML)
!
                  Write (valueC,'(F20.6)')                               &
     &                   vars(iValue,ii)%centerIF
                  valueComment = 'GHz'
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         comment=valueComment,                     &
     &                         error=errorXML)
!
                  Write (valueC,'(F20.6)')                               &
     &                   vars(iValue,ii)%bandWidth
                  valueComment = 'GHz'
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         comment=valueComment,                     &
     &                         error=errorXML)
!
                  Write (valueC,'(I5)')                               &
     &                   vars(iValue,ii)%disBoxInput
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         error=errorXML)
!
                  Write (valueC,'(F20.6)')                               &
     &                   vars(iValue,ii)%IF2
                  valueComment = 'GHz'
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         comment=valueComment,                     &
     &                         error=errorXML)
!
                  Write (valueC,*)                               &
     &                   vars(iValue,ii)%isFlippingIF2
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         error=errorXML)
!
                  valueC = vars(iValue,ii)%polarization
                  Call pakoXMLcase(valueC,error=errorXML)
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         error=errorXML)
!
                  Write (valueC,*)                               &
     &                   vars(iValue,ii)%useSpecialLO
                  Call pakoXMLwriteElement("TD",                         &
     &                         content=valueC,                              &
     &                         error=errorXML)
!
                  Call pakoXMLwriteEndElement("TR",                      &
     &                         error=errorXML)
            End If
         End Do
!
      End If
!
!!$         Do jj = 1,nDimReceivers,1
!!$            Do ii = 1,nDimParts,1
!!$               If (listBe(jj,ii)%isConnected) Then
!!$                  write (valueC,*)                                       &
!!$     &                  listBe(jj,ii)%nPart
!!$                  call pakoXMLwriteElement("TD",                         &
!!$     &                         text=valueC,                              &
!!$     &                         error=errorXML)
!!$!
!!$                  write (valueC,'(ES20.6)')                              &
!!$     &                  listBe(jj,ii)%resolution/1.0D3
!!$                  write (valueComment,*) listBe(jj,ii)%resolution,'MHz' 
!!$                  call pakoXMLwriteElement("TD",                         &
!!$     &                         text=valueC,                              &
!!$     &                         comment=valueComment,                     &
!!$     &                         error=errorXML)
!!$!
!!$                  write (valueC,'(ES20.6)')                              &
!!$     &                  listBe(jj,ii)%bandwidth/1.0D3
!!$                  write (valueComment,*) listBe(jj,ii)%bandwidth,'MHz' 
!!$                  call pakoXMLwriteElement("TD",                         &
!!$     &                         text=valueC,                              &
!!$     &                         comment=valueComment,                     &
!!$     &                         error=errorXML)
!!$!
!!$                  write (valueC,'(ES20.6)')                              &
!!$     &                  listBe(jj,ii)%fShift/1.0D3
!!$                  write (valueComment,*) listBe(jj,ii)%fShift,'MHz' 
!!$                  call pakoXMLwriteElement("TD",                         &
!!$     &                         text=valueC,                              &
!!$     &                         comment=valueComment,                     &
!!$     &                         error=errorXML)
!!$!
!!$                  valueC = listBe(jj,ii)%receiverName
!!$                  call pakoXMLwriteElement("TD",                         &
!!$     &                         text=valueC,                              &
!!$     &                         error=errorXML)
!!$!
!!$               End If
!!$            End Do
!!$         End Do
!
! **
!
      Call pakoXMLwriteEndElement  ("TABLEDATA",                         &
     &                         error=errorXML)
!
      Call pakoXMLwriteEndElement  ("DATA",                              &
     &                         error=errorXML)
!
      Call pakoXMLwriteEndElement  ("TABLE","receivers",                  &
     &                         error=errorXML)
!
      Call pakoXMLwriteEndElement  ("RESOURCE","receivers",               &
     &                         space="after",                            &
     &                         error=errorXML)
!



