!
! TBD: support segment types: track, linear, circle, curve
!
!D     Write (6,*) "      --> parametersSegment.f90 "
!
! *** segment type
!
      iOption   = 0
      iArgument = 1
!
      If (SIC_PRESENT(iOption,iArgument)) Then
         Call SIC_CH(LINE,iOption,iArgument,                            &
     &        cInput,lengthInput,.True.,errorC)
         cInputUpper = cInput
         Call SIC_UPPER(cInputUpper)
      Else
         errorL = .True.
         messageText =                                                  &
     &        "no segment type specified"
         Call pakoMessage(priorityI,severityI,command,messageText)
      End If
!
      If (errorC) Then
         messageText =                                                  &
     &     "segment type invalid"
         Call pakoMessage(priorityE,severityE,command,messageText)
      End If
!
      error = error .Or. errorC
!
! *** Check against valid segment types
!
      If (SIC_PRESENT(iOption,iArgument) .And. .Not. error) Then
!
         errorNotFound         = .False.
         errorNotUnique        = .False.
         choiceIndex = 0
!
         Do ii = 1,nDimSegmentTypes,1
            c12 = segmentTypeChoices(ii)
            call SIC_UPPER(c12)
            If (      c12(1:lengthInput) .eq.                            &
      &               cInputUpper(1:lengthInput)  ) Then
!!$            If (Index(c12,                                              &
!!$      &               cInputUpper(1:lengthInput)).Ge.1 ) Then
               If (choiceIndex .Eq. 0) Then
                  choiceIndex = ii
               Else
                  errorNotUnique = .True.
               End If
            End If
         End Do
         errorNotFound =  choiceIndex .Eq. 0
!
         If (errorNotFound) Then
            messageText =                                               &
     &     "segment type not found: "//cInputUpper(1:lengthInput)
            Call pakoMessage(priorityE,severityE,command,messageText)
         End If
!
         If (errorNotUnique) Then
            messageText =                                               &
     &     "segment type not unique: "//cInputUpper(1:lengthInput)
            Call pakoMessage(priorityE,severityE,command,messageText)
         End If
!
         If (.Not. (errorNotUnique .Or. errorNotFound)) Then
            vars(iIn)%segType  = segmentTypeChoices(choiceIndex)
!D            write (6,*) "      vars(iIn)%segType: ->",                  &
!D     &               vars(iIn)%segType(1:lenc(vars(iIn)%segType)), "<-"
         end if
!
      End If
!
      error = error .Or. errorNotUnique .Or. errorNotFound
!
! *** 
      if (.not. error) then
         include 'parametersStart.f90'
      end if
!
      if (.not. error) then
         If (  vars(iIn)%segType.Eq.seg%linear                           &
     &    .Or. vars(iIn)%segType.Eq.seg%circle                           &
     &    .Or. vars(iIn)%segType.Eq.seg%curve) Then
            include 'parametersEnd.f90'
         else
            vars(iIn)%pEnd = vars(iIn)%pStart
         end if
      end if
!
      if (.not. error) then
         If (  vars(iIn)%segType.Eq.seg%circle) Then
            include 'parametersTurnAngle.f90'
         end if
      end if
!
      if (.not. error) then
         If (  vars(iIn)%segType.Eq.seg%curve) Then
            include 'parametersCPStartEnd.f90'
         end if
      end if
!
      if (.not. error) then
         If (  vars(iIn)%segType.Eq.seg%linear                           &
     &      .Or.vars(iIn)%segType.Eq.seg%track) Then
            include 'parametersLengthOtf.f90'
         Else If (vars(iIn)%segType.Eq.seg%circle) Then
            include 'parametersLengthOtfCircle.f90'
         Else If (vars(iIn)%segType.Eq.seg%curve) Then
            include 'parametersLengthOtfCurve.f90'
         Else 
            include 'parametersLengthOtfCurve.f90'
         end if
      end if
!




