program make_primary
  use gildas_def
  use gkernel_interfaces
  !---------------------------------------------------------------------
  ! 	Make an image cube from a set of original CLEAned images
  ! OR from a single CLEANed image by dividing by the primary beam.
  !
  ! Adapted from MAKE_MOSAIC to TAKE properly into account the .weight
  !
  ! The original images are assumed to have the same phase tracking center
  ! and hence the same map characterictics (pixel, size, coordinates)
  ! This program compute several images (rather data cubes) :
  !
  !	'NAME'.LMV-SKY	a 3-d cube containing the uniform noise
  !			combined mosaic, i.e. the sum of the product
  !			of the fields by the .weight.
  !
  ! All images have the same X,Y sizes
  ! It is assumed that the names of the original field images follow
  ! the simple sequence 'NAME'-I.LMV-CLEAN
  !---------------------------------------------------------------------
  ! Local
  integer :: nf
  real :: bsize,bmin
  character(len=80) :: generic,gtype
  logical :: error
  !
  call gildas_open
  call gildas_inte('FIELDS$',nf,1)
  call gildas_char('NAME$',generic)
  call gildas_char('TYPE$',gtype)
  call gildas_real('BEAM$',bsize,1)
  call gildas_real('BMIN$',bmin,1)
  call gildas_close
  !
  call sub_primary(generic,nf,gtype,bsize,bmin,error)
  if (error) call sysexi(fatale)
  !
  call gagout('I-PRIMARY,  Successful completion')
end program make_primary
!
subroutine sub_primary(generic,nf,gtype,bsize,bmin,error)
  use gildas_def
  use gkernel_interfaces
  use mapping_interfaces
  use image_def
  use gbl_message
  !
  character(len=*), intent(in) :: generic
  character(len=*), intent(in) :: gtype
  integer, intent(in) :: nf
  real, intent(in) :: bsize,bmin
  logical, intent(out) :: error
  !
  character(len=*), parameter :: rname = 'PRIMARY'
  type(gildas) :: field
  type(gildas) :: sky
  !
  real, allocatable :: dsky(:,:,:) ! Corrected data cube 
  real, allocatable :: dprimary(:,:)   ! Current primary beam 
  real, allocatable :: dtmp(:,:)   ! Temporary work space
  real, allocatable :: dweight(:,:)   ! Weight array
  !
  character(len=80) :: name
  integer :: nx,ny,nv, nn,ier
  integer :: if,iv
  real :: thre, rmin, rmax
  integer(kind=size_length) :: nelem, imin, imax
  character(len=3) :: chain
  !
  call gildas_null(field)
  call gildas_null(sky)
  !
  error = .false.
  nn = len_trim(generic)
  !
  name = generic
  name(nn+1:) = '-1'
  call sic_parsef (name,field%file,' ',gtype)
  call gdf_read_header(field,error)
  if (error) then
    call map_message(seve%e,rname,'Cannot open '//trim(field%file))
    return
  endif
  nx = field%gil%dim(1)
  ny = field%gil%dim(2)
  nv = field%gil%dim(3)
  !
  allocate (dtmp(nx,ny),dprimary(nx,ny),dweight(nx,ny),dsky(nx,ny,nv),stat=ier)
  if (ier.ne.0) then
    error = .true.
    call map_message(seve%e,rname,'Cannot create '//trim(sky%file))
    return 
  endif
  !
  !
  ! Create the .LMV-SKY cube in "sky", and use "field" to
  ! loop over the various fields. 
  call gdf_copy_header(field,sky,error)
  name = generic
  call sic_parsef (name,sky%file,' ','.lmv-sky')
  sky%gil%ra = sky%gil%a0
  sky%gil%dec  = sky%gil%d0
  !
  ! Loop over fields.
  dsky = 0
  do if=1,nf
    write(chain,'(I2)') if
    if (chain(1:1).eq.' ') then
      name(nn+1:) = '-'//chain(2:)
    else
      name(nn+1:) = '-'//chain
    endif
    call sic_parsef (name,field%file,' ',gtype)
    call gdf_read_header(field,error)
    if (error) then
      write(6,*) 'F-'//rname//',  Cannot open ',field%file
      return
    endif
    call mos_primary (field,dprimary,bsize) 
    dweight(:,:) = dweight + dprimary**2  ! Sum of square of weights
    !
    ! Make it Plane by Plane to save Memory ...
    do iv=1,nv
      field%blc(3) = iv
      field%trc(3) = iv
      call gdf_read_data(field,dtmp,error)
      if (error) return
      dsky(:,:,iv) = dsky(:,:,iv) + dtmp*dprimary  ! Apply primary beam to this channel 
    enddo
  enddo
  !
  thre = bmin**2
  call mos_inverse (nx*ny,dweight,thre)
  !
  ! Divide .LMV-SKY by .WEIGHT for each channel
  !
  do iv=1,nv
    dsky(:,:,iv) = dsky(:,:,iv) * dweight 
  enddo
  nelem = nx*ny*nv
  call gr4_extrema (nelem,dsky,sky%gil%bval,sky%gil%eval,   &
                    rmin,rmax,imin,imax)
  call t_setextrema(sky,rmin,imin,rmax,imax)
  call gdf_write_image(sky,dsky,error)
  deallocate (dsky)
  deallocate (dtmp,dprimary,dweight) 
end subroutine sub_primary
