subroutine keepfi(obs,error)
  use gildas_def
  use gbl_message
  use classcore_interfaces, except_this=>keepfi
  use class_types
  !---------------------------------------------------------------------
  ! @ private
  ! CLASS support routine for command KEEP
  ! Save profile fit results in the output file.
  ! (Modifies an observation in R onto the output file)
  !---------------------------------------------------------------------
  type(observation), intent(inout) :: obs
  logical,           intent(inout) :: error  ! Error flag
  ! Local
  character(len=*), parameter :: rname='KEEP'
  character(len=message_length) :: mess
  !
  if (.not.filein_is_fileout()) then
     call class_message(seve%e,rname,'Input file must equal output file')
     error = .true.
     return
  endif
  !
  call mobs(obs,error)   ! Open an obs. of output file to modify it
  if(error) return
  !
  call wgaus(obs,error)  ! Save Gaussian fit parameters
  if (error) return
  !
  call class_write_close(obs,error)
  if (error) return
  !
  write(mess,'(A,I0,A,I0,A)')  &
    'Observation #',obs%head%gen%num,';',obs%head%gen%ver,' successfully updated'
  call class_message(seve%i,rname,mess)
  !
end subroutine keepfi
