program histo_table
  use gildas_def
  use image_def
  use gkernel_interfaces
  use gbl_format
  !---------------------------------------------------------------------
  ! GDF	Main program for making a cross Histogram from two columns
  !	of a table
  !
  ! S. Guilloteau 	Oct 1985
  !
  ! Subroutines	HISTO004
  !---------------------------------------------------------------------
  ! Local
  character(len=filename_length) :: namey,namex
  logical :: error
  real :: hzmin,hzmax,hzstep, hymin,hymax,hystep
  integer :: n, nhz,nhy, nco(2), ier
  real, allocatable :: xdata(:,:), yd1(:), yd2(:)
  type(gildas) :: x,y
  !
  call gildas_open
  call gildas_char('Y_NAME$',namey)
  call gildas_inte('Y_COLUMNS$',nco,2)
  call gildas_inte('BINS$1',nhz,1)
  call gildas_real('MIN$1',hzmin,1)
  call gildas_real('MAX$1',hzmax,1)
  call gildas_inte('BINS$2',nhy,1)
  call gildas_real('MIN$2',hymin,1)
  call gildas_real('MAX$2',hymax,1)
  call gildas_char('X_NAME$',namex)
  call gildas_close
  !
  ! Map input table
  call gildas_null(y)
  y%gil%ndim = 2
  call sic_parsef(namey,y%file,' ','.tab')
  call gdf_read_header(y,error)
  if (error) goto 100
  if (nco(1).lt.1 .or. nco(1).gt.y%gil%dim(2) .or. nco(2).lt.1   &
     &    .or. nco(2).gt.y%gil%dim(2)) then
    write(6,*) 'Input columns out of range 1 -',y%gil%dim(2)
    goto 100
  endif
  !
  ! Define output histogram
  call gildas_null(x)
  n = lenc(namex)
  if (n.eq.0) goto 100
  call sic_parsef(namex(1:n),x%file,' ','.gdf')
  hzstep = (hzmax-hzmin)/(nhz-1)
  hystep = (hymax-hymin)/(nhy-1)
  !
  x%gil%ndim = 2
  x%gil%dim(1) = nhz
  x%gil%dim(2) = nhy
  x%gil%dim(3) = 1
  x%gil%dim(4) = 1
  x%gil%coor_words = 6*gdf_maxdims
  x%gil%convert(1,1) = 1.0
  x%gil%convert(2,1) = hzmin
  x%gil%convert(3,1) = hzstep
  x%gil%convert(1,2) = 1.0
  x%gil%convert(2,2) = hymin
  x%gil%convert(3,2) = hystep
  x%gil%extr_words = 0
  x%gil%spec_words = 0
  x%gil%blan_words = 2
  x%gil%desc_words = def_desc_words !
  x%gil%proj_words = 0
  x%gil%bval = 0.d0
  x%gil%eval = -1.d0
  x%char%code(1) = 'UNKNOWN     '
  x%char%code(2) = 'UNKNOWN     '
  x%char%code(3) = 'UNKNOWN     '
  x%char%code(4) = 'UNKNOWN     '
  x%char%unit    = 'PIXELS      '
  !
  ! Change boundaries
  hzmin = hzmin - 0.5*hzstep
  hzmax = hzmax + 0.5*hzstep
  hymin = hymin - 0.5*hystep
  hymax = hymax + 0.5*hystep
  allocate (xdata(x%gil%dim(1),x%gil%dim(2)), stat=ier)
  !
  y%blc(2) = nco(1)
  y%trc(2) = nco(1) 
  allocate (yd1(x%gil%dim(1)), stat=ier)
  call gdf_read_data(y,yd1,error)
  y%blc(2) = nco(2)
  y%trc(2) = nco(2)
  allocate (yd2(x%gil%dim(1)), stat=ier)
  call gdf_read_data(y,yd2,error)
  call histo004(yd1,yd2,                         &
     &    y%gil%dim(1),0.0,-1.0,                 &
     &    hzmin,hzstep,hzmax,hymin,hystep,hymax, &
     &    x%gil%dim(1),x%gil%dim(2),xdata) 
  !
  call gdf_write_image(x,xdata,error)
  call gagout('S-HISTO_TABLE,  Successful completion')
  !
100 call sysexi (fatale)
end program histo_table
!
subroutine histo004 (z,y,nl,bval,eval,   &
     &    pzmin,pzstep,pzmax,pymin,pystep,pymax,   &
     &    nhz,nhy,h)
  use gildas_def
  !---------------------------------------------------------------------
  ! GDF	Computes the crossed histogram map of two columns of
  !	a table.
  !
  ! S.Guilloteau 	Jan 1987
  !
  ! Arguments :
  !	Z	R*4(*)	First input column address
  !	Y	R*4(*)	Second input column address
  !	NL	I	Number of lines
  !	BVAL	R*4	Blanking value
  !	EVAL	R*4	Tolerance on blanking
  !	PZMIN	R*4	Low threshold for Z input array
  !	PZSTEP	R*4	Histogram step for Z input array
  !	PYMIN	R*4	Low threshold for Y input array
  !	PYSTEP	R*4	Histogram step for Y input array
  !	NHZ	I	First dimension for histogram array
  !	NHY	I	Second dimension for histogram array
  !	H	R*4(*)	Histogram array
  !---------------------------------------------------------------------
  integer(kind=index_length) :: nl                   !
  real(4) :: z(nl)                   !
  real(4) :: y(nl)                   !
  real(4) :: bval                    !
  real(4) :: eval                    !
  real(4) :: pzmin                   !
  real(4) :: pzstep                  !
  real(4) :: pzmax                   !
  real(4) :: pymin                   !
  real(4) :: pystep                  !
  real(4) :: pymax                   !
  integer(kind=index_length) :: nhz                  !
  integer(kind=index_length) :: nhy                  !
  real(4) :: h(nhz,nhy)              !
  ! Local
  integer :: i,iz,jy,nin,nout,nblank,ntot
  !
  h = 0.0
  nin = 0
  nout = 0
  nblank = 0
  !
  if (eval.ge.0.0) then
    !
    do i=1,nl
      if (abs(z(i)-bval).gt.eval .and.   &
     &        abs(y(i)-bval).gt.eval) then
        if (z(i).ge.pzmin .and. z(i).lt.pzmax) then
          iz = int((z(i)-pzmin)/pzstep) + 1
          if (y(i).ge.pymin .and. y(i).lt.pymax) then
            jy = int((y(i)-pymin)/pystep) + 1
            h(iz,jy) = h(iz,jy)+1.0
            nin = nin+1
          else
            nout = nout+1
          endif
        else
          nout = nout+1
        endif
      else
        nblank = nblank+1
      endif
    enddo
    !
  else
    !
    do i=1,nl
      if (z(i).ge.pzmin .and. z(i).lt.pzmax) then
        iz = int((z(i)-pzmin)/pzstep) + 1
        if (y(i).ge.pymin .and. y(i).le.pymax) then
          jy = int((y(i)-pymin)/pystep) + 1
          h(iz,jy) = h(iz,jy)+1.0
          nin = nin+1
        else
          nout = nout+1
        endif
      else
        nout = nout+1
      endif
    enddo
    !
  endif
  !
  ntot = nin+nout+nblank
  write(6,100) nin,float(nin)/float(ntot)*1.e2,   &
     &    nout,float(nout)/float(ntot)*1.e2,   &
     &    nblank,float(nblank)/float(ntot)*1.e2,   &
     &    ntot
100 format(1x,'Number of points in histogram ',i12,4x,f5.1,' %',   &
     &    /,'   "    "    "    out of  "    ',i12,4x,f5.1,' %',   &
     &    /,'   "    "    "    blanked      ',i12,4x,f5.1,' %',   &
     &    /,'                  Total      = ',i12)
end subroutine histo004
