!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module gio_fitsio
  use gildas_def
  !--------------------------------------------------------------------
  ! GIO global variables for FITS I/O support
  !--------------------------------------------------------------------
  integer :: ifile                     ! Current location on sequential device
  integer :: unit                      ! Fortran LUN, C file pointer, or RMS channel
  integer :: dev_type                  ! Type of physical device (tape, CDrom,...)
  integer :: ldev                      ! Length of device name
  integer :: fid                       ! File identifier on CD
  integer :: ib                        ! Pointer within FITS I/O buffer
  integer(kind=record_length) :: irec  ! Next record for direct access (block mode +CD)
  integer :: ibbl                      ! Pointer within blocked mode buffer
  integer, parameter :: disk=0         !
  integer, parameter :: cdrom=1        !
  integer, parameter :: tape=2         !
  !
  integer(kind=1) :: buffer(2880)   ! I/O buffer
  logical :: end_of_tape            !
  logical :: end_of_file            !
  logical :: read                   !
  ! To be returned in a calling sequence
  logical :: sequential             ! FITS medium doesn't have a directory structure
  logical :: removable              ! FITS medium is removable
  logical :: stdio                  !
  !
  character(len=80) :: dev_name     !
end module gio_fitsio
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module gio_fitsdef
  !--------------------------------------------------------------------
  ! GIO global variables used to define FITS or UV FITS files
  !--------------------------------------------------------------------
  integer, parameter :: mcount=9    ! Must handle all cases of 1 digit
  !
  !--------------------------------------------------------------------
  ! FITS01  Variables for fits file
  integer(kind=1) :: buffer(2880)      ! I/O buffer
  !
  integer(kind=2) :: i2buf(1440)       ! Moved from fitreal.fpp and touvt.fpp
  integer(kind=4) :: i4buf(720)        ! because equivalence could not be
  equivalence (buffer,i2buf,i4buf)     ! done there
  !
  integer(kind=2) :: ibuffer(1440)     ! Moved from read_fits.fpp because
  integer(kind=4) :: jbuffer(720)      ! equivalence could not be done there
  equivalence (buffer,ibuffer,jbuffer) !
  !
  character(len=2880) :: cbuf          ! Moved from to_uvfits.fpp because
  equivalence (buffer,cbuf)            ! equivalence could not be done there
  !
  real(kind=4) :: bscal                ! Tape scaling factor
  real(kind=4) :: bzero                ! Map offset
  real(kind=4) :: datamin              ! Minimum map value
  real(kind=4) :: datamax              ! Maximum map value
  integer :: nbit                      ! Number of bits per value in current file
  integer :: snbit                     ! Number of bits per value for FITS writing
  integer :: nfile                     ! Current location on tape
  integer :: chan                      ! RMS channel for tape I/O or fortran LUN (disk)
  integer :: nb                        ! Pointer within I/O buffer
  logical :: mounted                   ! Tape is mounted
  logical :: disk                      ! Switch between Tape and disk mode
  logical :: lwrite                    ! Controls if file is used as input or output
  !
  !--------------------------------------------------------------------
  ! FITS02  Variables for UV fits file
  real(kind=4) ::  cscal,czero                  ! Complex visibilities scale
  real(kind=4) ::  uscal,uzero                  ! U       scale
  real(kind=4) ::  vscal,vzero                  ! V        and
  real(kind=4) ::  wscal,wzero                  ! W       zero
  real(kind=4) ::  tscal,tzero                  ! Time scale and zero
  real(kind=4) ::  dscal,dzero                  ! Date scale and zero
  real(kind=4) ::  pscal(mcount),pzero(mcount)  ! Scale and Zero for Pgroup
  real(kind=4) ::  wps                          ! Weight scaling factor
  real(kind=8) :: crval(mcount),cdelt(mcount),crpix(mcount)  ! Axis conversion
  integer :: luu,lvv,lww,lbase,ldate,ltime,lsour,linte,lfreq
  !
  !--------------------------------------------------------------------
  ! FITS definitions
  ! Constants
  integer(kind=4), parameter :: code_fits_standard=0
  integer(kind=4), parameter :: code_fits_cpc=1
  integer(kind=4), parameter :: code_fits_spline=2
  integer(kind=4), parameter :: code_fits_uvfits=3
  integer(kind=4), parameter :: code_fits_aips=4
  integer(kind=4), parameter :: code_fits_sorted=5
  integer(kind=4), parameter :: code_fits_casa=6
  ! Variables
  real :: bval0                  ! Default blanking value
  integer :: a_style             ! Style of processed FITS-tape
  logical :: question            ! Prompt when unrecognized axis type ?
  logical :: sort                ! Sort aips++ fits file ?
  logical :: no_degen            ! Get rid of last degenerated dimensions?
  !
  character(len=8) :: ptype(mcount), ctype(mcount)
  character(len=256) :: gdfname  ! Image name
end module gio_fitsdef
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
