subroutine fits_gildas_sub(iname,oname,style,blc,trc,check,error,getsymbol,wpr)
  use gio_dependencies_interfaces
  use gio_interfaces, except_this=>fits_gildas_sub
  use gio_params
  use gio_xy
  use gio_fitsdef
  use gbl_message
  !--------------------------------------------------------------------
  ! @ public
  ! GIO FITS interface
  ! Convert a FITS file to a GDF file
  !--------------------------------------------------------------------
  character(len=*),           intent(in)    :: iname      ! Input FITS file
  character(len=*),           intent(in)    :: oname      ! Output GILDAS file
  character(len=*),           intent(in)    :: style      ! FITS style
  integer(kind=index_length), intent(in)    :: blc(:)     ! Bottom Left Corner
  integer(kind=index_length), intent(in)    :: trc(:)     ! Top Right Corner
  logical,                    intent(in)    :: check      ! Echo keywords ?
  logical,                    intent(inout) :: error      ! Returned error code
  external                                  :: getsymbol  ! Translate FITS keyword
  external                                  :: wpr        ! Ask a question if unknown
  ! Local
  character(len=*), parameter :: rname='FITS'
  character(len=filename_length) :: name
  logical :: subset,end_of_tape,err
  integer, parameter :: mstyle=7
  character(len=16) :: styles(mstyle),argum,comm
  integer :: ncom,i,ier, pcount, a_stoke
  ! Data
  data styles /'STANDARD','CPC','SPLINE','UVFITS','AIPSFITS','SORTED_AIPSFITS','CASA_UVFITS'/
  !
  ! Default: no blanking
  call gag_notanum(bval0)
  !
  gdfname = oname
  name = iname
  argum = style
  !
  if (argum.eq.' ') then
    a_style = 0
  else
    ncom = 0
    call sic_ambigs('STYLE',argum,comm,ncom,styles,mstyle,error)
    if (error) return
    a_style = ncom-1
  endif
  question = .false.
  !
  if (a_style.lt.code_fits_uvfits) then
    ier = 0                    ! "normal" FITS
  else
    ier = 1                    ! "UV" Fits
  endif
  !
  if (ier.eq.0) then
    chan = 1
    lwrite = .false.
    call gfits_open(name,'IN',error)
    if (error) return
    ier = togdf(fits,a_style,question,check,error,getsymbol,wpr)
    if (error) then
      call gio_message(seve%e,rname,'Error reading file '//name)
      call gfits_close(err)
      return
    endif
    if (ier.eq.0) then
      subset = .false.
      do i=1,4
        if (blc(i).ne.0) then
          subset = .true.
        elseif (trc(i).ne.0) then
          subset = .true.
        endif
      enddo
      if (subset) then
        call read_sub(fits,error,end_of_tape,blc,trc)
      else
        call read_all(fits,error,end_of_tape)
      endif
      if (error) then
        call gfits_close(err)
        return
      endif
    elseif  (ier.eq.1) then
      !
      ! Try a UVFITS as a fall back. Sorry, cannot be AIPSFITS if not specified
      name = iname                         ! Reset name ...
      a_style = code_fits_uvfits           ! by default, not AIPSFITS
    endif
    call gfits_close(error)
  endif
  !
  if (ier.eq.1) then
    chan = 1
    lwrite = .false.
    error = .false.
    call gfits_open(name,'IN',error)
    if (error) return
    call touvt(fits,a_style,question,check,error,pcount,getsymbol)
    if (error) then
      call gio_message(seve%e,rname,'Error reading UVFITS header')
      call gfits_close(err)
      return
    endif
    if (a_style.eq.code_fits_casa) then
      a_stoke = 0   ! Get all Stokes parameters
    else
      a_stoke = 1   ! Only get unpolarized signal
    endif
    call read_uvfits(fits,a_stoke,error,end_of_tape,pcount)
    if (error) then
      call gio_message(seve%e,rname,'Error reading UVFITS data')
      call gfits_close(err)
      return
    endif
    call gfits_close(error)
  endif
  !
end subroutine fits_gildas_sub
