subroutine map_continuum(line,error)
  use image_def
  use gkernel_interfaces
  use imager_interfaces, except_this => map_continuum 
  use gbl_message
  use clean_arrays
  !---------------------------------------------------------------------
  ! @ private
  !---------------------------------------------------------------------
  character(len=*), intent(in) :: line
  logical, intent(inout) :: error
  ! Local
  character(len=*), parameter :: rname='MAP_CONTINUUM'
  logical :: debug=.false.
  character(len=16) :: name
  character(len=80) :: chain
  integer :: n, nchan, ier
  integer(kind=index_length) :: nhist, mhist
  real :: clip_value 
  type(gildas) :: hmap
  type(gildas), save :: hcont
  !
  call sic_delvariable('CONTINUUM',.false.,error)
  error = .false.
  call gildas_null(hmap)
  call gildas_null(hcont)
  !
  name = 'CLEAN'
  call sic_ke(line,0,1,name,n,.false.,error)
  select case (name)
  case ('CLEAN')
    if (hclean%loca%size.eq.0) then
      call map_message(seve%e,rname,'No CLEAN data loaded')
      error = .true.
      return
    endif
    call gdf_copy_header(hclean,hmap,error)
    hmap%r3d => dclean
  case ('DIRTY')
    if (hdirty%loca%size.eq.0) then
      call map_message(seve%e,rname,'No DIRTY data loaded')
      error = .true.
      return
    endif
    call gdf_copy_header(hdirty,hmap,error)
    hmap%r3d => ddirty
  case default
    call map_message(seve%e,rname,'Only work on CLEAN or DIRTY images')
    error = .true.
    return
  end select
  !
  call gdf_copy_header(hmap,hcont,error)
  !
  hcont%gil%ndim = 2
  hcont%gil%dim(3) = 1
  allocate(hcont%r2d(hcont%gil%dim(1),hcont%gil%dim(2)),stat=ier)
  !
  clip_value = 2.5
  call sic_r4(line,0,2,clip_value,.false.,error)
  if (clip_value.lt.1.0 .or. clip_value.gt.5.0) then
    call map_message(seve%e,rname,'Clipping value outside of recommended [1-5] range')
    error = .true.
    return
  endif
  !
  nchan = hmap%gil%dim(3)
  !
  mhist = max(8,nint(sqrt(real(nchan))))
  mhist = min(mhist,32)
  nhist = max(8,mhist)
  call sic_i8(line,0,3,nhist,.false.,error) 
  if (nchan.lt.32) then
    write(chain,'(A,I0,A)') 'Too few channels [',nchan,'], display only'
    call map_message(seve%w,rname,chain)
    nhist = 1
  else if (nhist.lt.8 .or. nhist.gt.max(8,nchan/8)) then
    write(chain,'(A,I0,A)') 'Histogram size out of allowed range [8-',nchan/8,']'
    call map_message(seve%e,rname,chain)
    error = .true.
    return
  else if (nhist.gt.mhist)  then
    write(chain,'(A,I0,A)') 'Histogram size out of recommended range [8-',mhist,']'
    call map_message(seve%w,rname,chain)
  endif
  ! 
  call compute_continuum(hmap,hcont,nhist,clip_value,error)
  if (error) return  
  hcont%loca%addr = locwrd(hcont%r2d) 
  hcont%loca%size = hcont%gil%dim(1) * hcont%gil%dim(2)
  call gdf_get_extrema (hcont,error)
  !
  call sic_mapgildas('CONTINUUM',hcont,error,hcont%r2d)
  call exec_program('@ p_continuum')   
  !
end subroutine map_continuum
!
subroutine compute_continuum(hmap,hcont,nhist,clip_value,error)
  use image_def
  use gbl_message
  use gkernel_interfaces
  use imager_interfaces, except_this => compute_continuum
  ! @ public
  type(gildas), intent(in) :: hmap
  type(gildas), intent(inout) :: hcont
  integer(kind=index_length), intent(in) :: nhist
  real, intent(in) :: clip_value
  logical, intent(out) :: error
  !
  character(len=*), parameter :: rname='MAP_CONTINUUM'
  real, allocatable, target, save :: spectrum(:,:)
  real, pointer :: clip_data(:)
  integer, allocatable :: mylines(:), good_data(:)
  real, pointer :: rmask(:,:)
  real :: blank, tmp
  integer(kind=index_length) :: nchan, dim(2)
  integer :: nx,ny,ix,iy,ier,ic,kc,ib,nb
  logical :: debug=.false.
  !
  error = .false.
  !
  nchan = hmap%gil%dim(3)
  nx = hmap%gil%dim(1)
  ny = hmap%gil%dim(2)
  !
  if (allocated(spectrum)) then
    deallocate(spectrum)
    call sic_delvariable('CLIPPED',.false.,error)
  endif
  allocate(spectrum(nchan,4),good_data(nchan),mylines(nchan),stat=ier)
  if (ier.ne.0) then
    call map_message(seve%e,rname,'Memory allocation error')
    error = .true.
    return
  endif
  do ic=1,nchan
    spectrum(ic,1) = (ic-hmap%gil%ref(3))*hmap%gil%vres + hmap%gil%voff
  enddo
  ! 
  if (hcont%gil%eval.lt.0) then
    !    
    ! We need to define a Blanking value outside of the range
    blank = minval(hmap%r3d)
    if (blank.gt.0) then
      hcont%gil%bval = -2.0*blank
      hcont%gil%eval = blank
    else if (blank.lt.0) then
      hcont%gil%bval = 3.0*blank
      hcont%gil%eval = -blank
    else
      hcont%gil%bval = -1.0
      hcont%gil%eval = 0.0
    endif
  endif
  !
  ! Compute the mean spectrum
  do ic = 1,nchan
    call gr4_mean(hmap%r3d(:,:,ic),hmap%gil%dim(1)*hmap%gil%dim(2),  &
      & hmap%gil%bval,hmap%gil%eval,spectrum(ic,2)) 
  enddo
  spectrum(:,3) = spectrum(:,2)
  clip_data => spectrum(:,3)
  !
  if (nhist.gt.1) then
    !
    ! Find out the line free regions
    call clip_lineregions(rname,clip_data,nchan,nhist,  &
      & hcont%gil%bval,hcont%gil%eval,clip_value,debug,0.0,tmp)
    call guess_lineregions(clip_data,nchan,       &
      & hcont%gil%bval,hcont%gil%eval,            &
      & mylines,nb)
    !
    ! Expand line regions by continuity
    call clip_expand(mylines,hmap%gil%dim(3),nb)
    !
    ! Compute the continuum image 
    good_data = 0
    spectrum(:,3) = 0
    do ib=1,nb
      good_data(mylines(ib)) = 1
      spectrum(mylines(ib),4) = 1
    enddo
    kc = 0
    do ic=1,nchan
      if (good_data(ic).eq.1) cycle
      kc = kc+1
      if (kc.eq.1) then
        hcont%r2d = hmap%r3d(:,:,ic)
      else
        rmask => hmap%r3d(:,:,ic)
        if (hmap%gil%eval.ge.0) then
          where ( (abs(rmask-hmap%gil%bval).gt.hmap%gil%eval).and. &
            & (abs(hcont%r2d-hmap%gil%bval).gt.hmap%gil%eval) ) &
            & hcont%r2d = hcont%r2d + rmask
        else
          hcont%r2d = hcont%r2d + rmask
        endif
      endif
    enddo
    !
    if (kc.ne.0) then
      where (abs(hcont%r2d-hcont%gil%bval).gt.hcont%gil%eval) hcont%r2d = hcont%r2d/kc
    endif
  endif
  !
  dim(1) = hmap%gil%dim(3)
  dim(2) = 4
  call sic_def_real('CLIPPED',spectrum,2,dim,.false.,error)
end subroutine compute_continuum
