module cubetuple_dag
  use cubetools_parameters
  use cubedag_tuple
  use cube_types

  public :: cubetuple_dag_upsert
  private

contains

  subroutine cubetuple_dag_upsert(cube,error)
    !-------------------------------------------------------------------
    ! Upsert the cube in DAG
    !-------------------------------------------------------------------
    type(cube_t), intent(inout) :: cube
    logical,      intent(inout) :: error
    ! Local
    integer(kind=code_k) :: code_where
    character(len=file_l) :: where
    !
    if (.not.associated(cube%tuple%current)) then
      ! This can happen in error recovery mode
      return
    endif
    !
    if (cube%tuple%trans%do.ne.code_trans_none) then
      ! This can happen if a transposition was prepared at get_header
      ! time, but was not actually performed because no data was
      ! actually accessed (get_image/get_spectrum).
      ! => no upsertion in the DAG as the data is not ready
      return
    endif
    !
    if (cube%tuple%current%desc%buffered.eq.code_buffer_memory) then
      code_where = code_buffer_memory
      where = '<memory>'
    else
      code_where = code_buffer_disk
      where = cube%tuple%current%desc%filename
    endif
    call cubedag_tuple_upsert(cube%node%tuple,  &
                              cube%order(),  &
                              code_where,  &
                              where,error)
    if (error)  return
    !
  end subroutine cubetuple_dag_upsert

end module cubetuple_dag
