module cubeedit_close
  use cubetools_structure
  use cubeedit_messaging
  !
  public :: close
  public :: cubeedit_close_command
  private
  !
  type :: close_comm_t
     type(option_t), pointer :: comm
     type(option_t), pointer :: as
   contains
     procedure, public  :: register => cubeedit_close_register
     procedure, private :: parse    => cubeedit_close_parse
     procedure, private :: parse_as => cubeedit_close_parse_as
     procedure, private :: main     => cubeedit_close_main
  end type close_comm_t
  type(close_comm_t) :: close
  !
  type close_user_t
     character(len=varn_l) :: edid
     logical               :: doas
     character(len=file_l) :: newname
  end type close_user_t
  !
contains
  !
  subroutine cubeedit_close_command(line,error)
    !-------------------------------------------------------------------
    ! Support routine for command CLOSE
    !-------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(close_user_t) :: user
    character(len=*), parameter :: rname='CLOSE>COMMAND'
    !
    call cubeedit_message(edseve%trace,rname,'Welcome')
    !
    call close%parse(line,user,error)
    if (error) return
    call close%main(user,error)
    if (error) return
  end subroutine cubeedit_close_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubeedit_close_register(close,error)
    !-------------------------------------------------------------------
    ! Register EDIT\CLOSE and its options
    !-------------------------------------------------------------------
    class(close_comm_t), intent(inout) :: close
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: comm_abstract = &
         'Close a cube in editing mode'
    character(len=*), parameter :: comm_help = strg_id
    !
    type(standard_arg_t) :: stdarg
    character(len=*), parameter :: rname='CLOSE>REGISTER'
    !
    call cubeedit_message(edseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'CLOSE','[newid]',&
         comm_abstract,&
         comm_help,&
         cubeedit_close_command,&
         close%comm,error)
    if (error) return
    call stdarg%register(&
         'NewId', &
         'Editing Identifier', &
         strg_id,&
         code_arg_optional, error)
    if (error) return
    !
    call cubetools_register_option(&
         'AS','family[:flag1,...,flagn]',&
         'Define the family name of the cube being closed for edition',&
         'String for the new family name may also contain flags. If&
         & option /AS is not given, the default name is the NewId,&
         & and the default flag is edited',&
         close%as,error)
    if (error) return
    call stdarg%register(&
         'family', &
         'New family name', &
         strg_id,&
         code_arg_optional, error)
    if (error) return
    !
  end subroutine cubeedit_close_register
  !
  subroutine cubeedit_close_parse(close,line,user,error)
    !-------------------------------------------------------------------
    ! Parse routine for command CLOSE
    !-------------------------------------------------------------------
    class(close_comm_t), intent(in)    :: close
    character(len=*),    intent(in)    :: line
    type(close_user_t),  intent(out)   :: user
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='CLOSE>PARSE'
    !
    call cubeedit_message(edseve%trace,rname,'Welcome')
    !
    user%edid = strg_star
    call cubetools_getarg(line,close%comm,1,user%edid,.not.mandatory,error)
    if (error) return
    !
    call close%parse_as(line,user,error)
    if (error) return
    !
  end subroutine cubeedit_close_parse
  !
  subroutine cubeedit_close_parse_as(close,line,user,error)
    use cubeedit_cube_buffer
    !-------------------------------------------------------------------
    ! Parse routine for command CLOSE
    !-------------------------------------------------------------------
    class(close_comm_t), intent(in)    :: close
    character(len=*),    intent(in)    :: line
    type(close_user_t),  intent(inout) :: user
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='CLOSE>PARSE>AS'
    !
    call cubeedit_message(edseve%trace,rname,'Welcome')
    !
    call close%as%present(line,user%doas,error)
    if (error) return
    if (user%doas) then
       call cubetools_getarg(line,close%as,1,user%newname,mandatory,error)
       if (error) return
    else
       call cubeedit_bufferlist_get_buffer_name(user%edid,user%newname,error)
       if (error) return
    endif
  end subroutine cubeedit_close_parse_as
  !
  subroutine cubeedit_close_main(close,user,error)
    use cubeedit_cube_buffer
    !-------------------------------------------------------------------
    ! Main routine for command CLOSE
    !-------------------------------------------------------------------
    class(close_comm_t), intent(in)    :: close
    type(close_user_t),  intent(in)    :: user
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='CLOSE>MAIN'
    !
    call cubeedit_message(edseve%trace,rname,'Welcome')
    !
    call cubeedit_bufferlist_close(user%edid,user%newname,error)
    if (error) return
  end subroutine cubeedit_close_main
end module cubeedit_close
