!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubecompute_amplitude
  use cubetools_parameters
  use cubetools_structure
  use cube_types
  use cubeadm_cubeid_types
  use cubecompute_messaging
  !
  public :: amplitude
  public :: cubecompute_amplitude_command
  private
  !
  type :: amplitude_comm_t
     type(option_t), pointer :: comm
   contains
     procedure, public  :: register => cubecompute_amplitude_register
     procedure, private :: parse    => cubecompute_amplitude_parse
     procedure, private :: main     => cubecompute_amplitude_main
  end type amplitude_comm_t
  type(amplitude_comm_t) :: amplitude
  !
  integer(kind=4), parameter :: icube = 1
  type amplitude_user_t
     type(cubeid_user_t)   :: cubeids
   contains
     procedure, private :: toprog => cubecompute_amplitude_user_toprog
  end type amplitude_user_t
  !
  type amplitude_prog_t
     type(cube_t), pointer :: complex
     type(cube_t), pointer :: amplitude
     !
   contains
     procedure, private :: header => cubecompute_amplitude_prog_header
     procedure, private :: data   => cubecompute_amplitude_prog_data
     procedure, private :: loop   => cubecompute_amplitude_prog_loop
     procedure, private :: act    => cubecompute_amplitude_prog_act
  end type amplitude_prog_t
  !
contains
  !
  subroutine cubecompute_amplitude_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(amplitude_user_t) :: user
    character(len=*), parameter :: rname='AMPLITUDE>COMMAND'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    call amplitude%parse(line,user,error)
    if (error) return
    call amplitude%main(user,error)
    if (error) continue
  end subroutine cubecompute_amplitude_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubecompute_amplitude_register(amplitude,error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(amplitude_comm_t), intent(inout) :: amplitude
    logical,                 intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    character(len=*), parameter :: comm_abstract=&
         'Compute the amplitude from a complex cube'
    character(len=*), parameter :: comm_help=strg_id
    character(len=*), parameter :: rname='AMPLITUDE>REGISTER'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'AMPLITUDE','[cubeid]',&
         comm_abstract,&
         comm_help,&
         cubecompute_amplitude_command,&
         amplitude%comm,error)
    if (error) return
    call cubearg%register(&
         'CUBE',&
         'Input complex data',&
         strg_id,&
         code_arg_optional,&
         [flag_any],&
         error)
    if (error) return
  end subroutine cubecompute_amplitude_register
  !
  subroutine cubecompute_amplitude_parse(amplitude,line,user,error)
    use cubetools_parse
    !----------------------------------------------------------------------
    ! AMPLITUDE cubeid
    !----------------------------------------------------------------------
    class(amplitude_comm_t), intent(in)    :: amplitude
    character(len=*),        intent(in)    :: line
    type(amplitude_user_t),  intent(out)   :: user
    logical,                 intent(inout) :: error
    !
    character(len=*), parameter :: rname='AMPLITUDE>PARSE'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,amplitude%comm,user%cubeids,error)
    if (error) return
  end subroutine cubecompute_amplitude_parse
  !
  subroutine cubecompute_amplitude_main(amplitude,user,error)
    use cubeadm_timing
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(amplitude_comm_t), intent(in)    :: amplitude
    type(amplitude_user_t),  intent(in)    :: user
    logical,                 intent(inout) :: error
    !
    type(amplitude_prog_t) :: prog
    character(len=*), parameter :: rname='AMPLITUDE>MAIN'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call user%toprog(prog,error)
    if (error) return
    call prog%header(error)
    if (error) return
    call cubeadm_timing_prepro2process()
    call prog%data(error)
    if (error) return
    call cubeadm_timing_process2postpro()
  end subroutine cubecompute_amplitude_main
  !
  !----------------------------------------------------------------------
  !
  subroutine cubecompute_amplitude_user_toprog(user,prog,error)
    use cubeadm_get
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(amplitude_user_t), intent(in)    :: user
    type(amplitude_prog_t),  intent(out)   :: prog
    logical,                 intent(inout) :: error
    !
    character(len=*), parameter :: rname='AMPLITUDE>USER>TOPROG'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_get_header(amplitude%comm,icube,user%cubeids,&
         code_access_imaset,code_read,prog%complex,error)
    if (error) return
  end subroutine cubecompute_amplitude_user_toprog
  !
  !----------------------------------------------------------------------
  !
  subroutine cubecompute_amplitude_prog_header(prog,error)
    use cubetools_header_methods
    use cubedag_allflags
    use cubeadm_clone
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(amplitude_prog_t), intent(inout) :: prog
    logical,                 intent(inout) :: error
    !
    character(len=*), parameter :: rname='AMPLITUDE>PROG>HEADER'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call cubeadm_clone_header(prog%complex,flag_amplitude,prog%amplitude,error)
    if (error) return
    call cubetools_header_make_array_real(prog%amplitude%head,error)
    if (error) return
  end subroutine cubecompute_amplitude_prog_header
  !
  subroutine cubecompute_amplitude_prog_data(prog,error)
    use cubeadm_opened
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(amplitude_prog_t), intent(inout) :: prog
    logical,                 intent(inout) :: error
    !
    type(cubeadm_iterator_t) :: iter
    character(len=*), parameter :: rname='AMPLITUDE>PROG>DATA'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call cubeadm_datainit_all(iter,error)
    if (error) return
    !
    !$OMP PARALLEL DEFAULT(none) SHARED(prog,error) FIRSTPRIVATE(iter)
    !$OMP SINGLE
    do while (cubeadm_dataiterate_all(iter,error))
       if (error)  exit
       !$OMP TASK SHARED(prog) FIRSTPRIVATE(iter,error)
       if (.not.error) call prog%loop(iter%first,iter%last,error)
       !$OMP END TASK
    enddo ! ie
    !$OMP END SINGLE
    !$OMP END PARALLEL
  end subroutine cubecompute_amplitude_prog_data
  !
  !----------------------------------------------------------------------
  !
  subroutine cubecompute_amplitude_prog_loop(prog,first,last,error)
    use cubeadm_entryloop
    use cubeadm_image_types
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(amplitude_prog_t), intent(inout) :: prog
    integer(kind=entr_k),    intent(in)    :: first
    integer(kind=entr_k),    intent(in)    :: last    
    logical,                 intent(inout) :: error
    !
    integer(kind=entr_k) :: ie
    type(visi_t) :: complex
    type(image_t) :: amplitude
    character(len=*), parameter :: rname='AMPLITUDE>PROG>LOOP'
    !
    call complex%associate('complex',prog%complex,error)
    if (error) return
    call amplitude%allocate('amplitude',prog%amplitude,error)
    if (error) return
    !
    do ie=first,last
      call cubeadm_entryloop_iterate(ie,error)
      if (error) return
      call prog%act(ie,complex,amplitude,error)
      if (error) return
    enddo ! ie
  end subroutine cubecompute_amplitude_prog_loop
  !
  subroutine cubecompute_amplitude_prog_act(prog,ie,complex,amplitude,error)
    use cubeadm_image_types
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(amplitude_prog_t), intent(inout) :: prog
    integer(kind=entr_k),    intent(in)    :: ie
    type(visi_t),            intent(inout) :: complex
    type(image_t),           intent(inout) :: amplitude
    logical,                 intent(inout) :: error
    !
    integer(kind=pixe_k) :: ix,iy
    character(len=*), parameter :: rname='AMPLITUDE>PROG>ACT'
    !
    call complex%get(ie,error)
    if (error) return
    do iy=1,complex%ny
       do ix=1,complex%nx
          amplitude%val(ix,iy) = abs(complex%val(ix,iy))
       enddo ! ix
    enddo ! iy
    call amplitude%put(ie,error)
    if (error) return
  end subroutine cubecompute_amplitude_prog_act
end module cubecompute_amplitude
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
