!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeadm_init
  use cubetools_header_types
  use cubetuple_init
  use cubedag_types
  use cube_types
  use cubeadm_messaging
  use cubeadm_snapshot
  use cubeadm_timing
  !
  integer(kind=4) :: code_ftype_cube=0  ! cube_t identifier in the DAG (initialized at init)
  !
  public :: code_ftype_cube,cubeadm_library_init
  private
  !
contains
  !
  subroutine cubeadm_library_init(error)
    use gkernel_interfaces
    use cubedag_library
    use cubedag_type
    use cubeadm_directory_type
    !---------------------------------------------------------------------
    ! Initialize the ADM library
    !---------------------------------------------------------------------
    logical, intent(inout) :: error
    ! Local
    integer(kind=4) :: ier
    logical :: autoreimport
    !
    ! Initialization of Directories list buffer
    call dir%init(error)
    if (error) return
    call dir%sicdef(error)
    if (error) return
    !
    ! *** JP I don't understand why the cubedag_init is here and
    ! *** JP cubedag_exit is in lib/cube/package.f90?
    call cubedag_init(error)
    if (error)  return
    call cubedag_type_register(&
         'CUBE','cube',&
         cubeadm_cube_allocate,&
         cubeadm_cube_deallocate,&
         code_ftype_cube,error)
    if (error)  return
    !
    ! Implicit import of the previous snapshot, if any
    autoreimport = .true.
    ier = sic_getlog('CUBE_REIMPORT_AUTO',autoreimport)
    if (autoreimport) then
      call cubeadm_snapshot_reimport(cubeadm_snapshot_dagname(),  &
                                    cubeadm_snapshot_histname(),  &
                                    .true.,error)
      if (error)  return
    endif
    !
    call cubeadm_timing_variables(error)
    if (error)  return
    !
  end subroutine cubeadm_library_init
  !
  subroutine cubeadm_cube_allocate(object,error)
    use gkernel_interfaces
    !---------------------------------------------------------------------
    ! Allocate and initialize a 'cube_t' in memory
    !---------------------------------------------------------------------
    class(cubedag_node_object_t), pointer       :: object
    logical,                      intent(inout) :: error
    !
    type(cube_t), pointer :: cube
    integer(kind=4) :: ier
    character(len=*), parameter :: rname='ADM>ALLOCATE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    allocate(cube_t::object,stat=ier)
    if (failed_allocate(rname,'object',ier,error)) return
    cube => cubetuple_cube_ptr(object,error)
    if (error)  return
    call cubeadm_set_user(cube,error)
    if (error)  return
    call cubetuple_cube_init(cube%tuple,error)
    if (error)  return
    call cubetools_header_init(cube%head,error)
    if (error) return
    ! Set up the list-type method
    object%ltype    => cubeadm_cube_ltype
    object%memsize  => cubeadm_cube_memsize
    object%disksize => cubeadm_cube_disksize
    object%datasize => cubeadm_cube_datasize
  end subroutine cubeadm_cube_allocate
  !
  subroutine cubeadm_cube_deallocate(object,error)
    !-------------------------------------------------------------------
    ! Finalize and deallocate a 'cube_t' in memory
    !-------------------------------------------------------------------
    class(cubedag_node_object_t), pointer       :: object
    logical,                      intent(inout) :: error
    ! Local
    character(len=*), parameter :: rname='ADM>DEALLOCATE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    if (.not.associated(object)) then
      call cubeadm_message(seve%e,rname,'Internal error: object is not allocated')
      error = .true.
      return
    endif
    deallocate(object)  ! NB: deallocation is polymorphic: we are deallocating
                        ! a cube_t, which invokes implicitly its FINAL procedure
  end subroutine cubeadm_cube_deallocate

  function cubeadm_cube_ltype(obj)
    use cubetools_axset_types
    character(len=2) :: cubeadm_cube_ltype
    class(cubedag_node_object_t), intent(in) :: obj
    select type (obj)
    type is (cube_t)
      write(cubeadm_cube_ltype,'(I1,A1)')  cubetools_axset_count_genuine(obj%head%set),'D'
    class default
      cubeadm_cube_ltype = '??'
    end select
  end function cubeadm_cube_ltype

  function cubeadm_cube_memsize(obj)
    integer(kind=size_length) :: cubeadm_cube_memsize
    class(cubedag_node_object_t), intent(in) :: obj
    select type (obj)
    type is (cube_t)
      cubeadm_cube_memsize = obj%tuple%memsize()
    class default
      cubeadm_cube_memsize = 0
    end select
  end function cubeadm_cube_memsize

  function cubeadm_cube_disksize(obj)
    use cubedag_tuple
    integer(kind=size_length) :: cubeadm_cube_disksize
    class(cubedag_node_object_t), intent(in) :: obj
    select type (obj)
    type is (cube_t)
      cubeadm_cube_disksize = cubedag_tuple_disksizes(obj%node%tuple)
    class default
      cubeadm_cube_disksize = 0
    end select
  end function cubeadm_cube_disksize

  function cubeadm_cube_datasize(obj)
    integer(kind=size_length) :: cubeadm_cube_datasize
    class(cubedag_node_object_t), intent(in) :: obj
    logical :: error
    select type (obj)
    type is (cube_t)
      error = .false.
      call obj%head%arr%datasize(cubeadm_cube_datasize,error)
    class default
      cubeadm_cube_datasize = 0
    end select
  end function cubeadm_cube_datasize

  subroutine cubeadm_set_user(cube,error)
    use cubeadm_setup
    !----------------------------------------------------------------------
    ! Point a subpart of a cube_t to the global cubset buffer
    !----------------------------------------------------------------------
    type(cube_t), intent(inout) :: cube
    logical,      intent(inout) :: error
    !
    character(len=*), parameter :: rname='SET>USER'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    cube%user => cubset
  end subroutine cubeadm_set_user
end module cubeadm_init
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
