subroutine howto_comm(line,error)
  use gkernel_interfaces
  use gbl_message
  !---------------------------------------------------------------------
  ! IMAGER
  !   Support for command HOW_TO
  !   HOW_TO Keywords...
  !---------------------------------------------------------------------
  character(len=*), intent(in) :: line
  logical, intent(out) :: error
  !
  character(len=*), parameter :: rname='HOW_TO'
  integer, parameter :: mkeys=10
  integer :: nkeys, lkeys(mkeys), ikey
  character(len=20) :: ckeys(mkeys),string
  character(len=120) :: ligne
  character(len=256) :: file
  integer, save :: luntem=0
  integer :: ier, i, j, ifound, lt
  logical :: found, used
  !
  integer, parameter :: nuse=11
  character(len=8) :: useless(nuse)
  data useless /'?','a','all','at','do','i','it','my','some','the','to'/
  !
  error = .true.
  nkeys = sic_narg(0)
  if (nkeys.le.0) then
    call map_message(seve%e,rname,'Missing keywords')
    return
  endif
  !
  if (nkeys.gt.mkeys) then
    call map_message(seve%e,rname,'Too many keywords')
    return
  endif
  !
  ikey = 0
  do i=1,nkeys
    call sic_ch(line,0,i,string,lt,.true.,error)
    if (error) return
    if (nkeys.eq.1 .and. string.eq.'?') then
      ikey = 1
      exit
    endif
    !
    used = .true.
    do j=1,nuse
      if (string.eq.useless(j)) then
        used = .false.
        exit
      endif
    enddo
    if (used) then
      ikey = ikey+1
      ckeys(ikey) = string
      if (string(lt:lt).eq.'*') then
        lkeys(ikey) = lt-1
        ckeys(ikey)(lt:) = ' '
      else
        lkeys(ikey) = lt+1
      endif
    endif
  enddo
  nkeys = ikey
  !
  ! Open file (in production, will use a rewind(luntem) statement)
  if (luntem.eq.0) then
    ier = sic_getlun(luntem)
    if (ier.ne.1) return
  else    
    close(unit=luntem)
  endif
  call sic_parse_file('imager-howto','gag_pro:','.hlp',file)    
  ier = sic_open(luntem,file,'old',.true.)
  !
  ! Special case HOWTO ?
  if (nkeys.eq.1 .and. string.eq.'?') then
    do 
      read(luntem,'(A)',iostat=ier) ligne
      if (ier.ne.0)  exit
      !
      if (ligne(1:1).eq.'1') then
        read(luntem,'(A)',iostat=ier) ligne
        write(*,'(A)') trim(ligne)
      endif
    enddo
    error = .false.
    return
  endif
  !
  ! Scan for Keywords
  found = .false.
  ifound = 0
  !
  do 
    read(luntem,'(A)',iostat=ier) ligne
    if (ier.ne.0)  exit
    !
    if (ligne(1:1).eq.'1') then
      if (ifound.eq.nkeys) return ! Every keyword found
      ! We check 1 more character in ligne, which should be blank
      ! for correct match
      ifound = 0  ! Nothing found so far
      found = .false.
      do i=1,nkeys
        lt = lkeys(i)
        if (index(ligne,ckeys(i)(1:lt)).ne.0) then
          error = .false.
          ifound = ifound+1
        endif
      enddo
      found = ifound.eq.nkeys
      !!Print *,ifound,nkeys,trim(ligne)
      !
    else if (found) then
      write(*,'(A)') trim(ligne)
    endif
  enddo
  if (found) return
  !
  ! Second chance: list relevant HOWTOs
  write(*,'(A)') 'No result for '//trim(line)
  ifound = 0
  rewind(luntem)
  do 
    read(luntem,'(A)',iostat=ier) ligne
    if (ier.ne.0)  exit
    !
    if (ligne(1:1).eq.'1') then
      if (ifound.eq.nkeys) return ! Every keyword has been found
      ! We check 1 more character in ligne, which should be blank
      ! for correct match
      found = .false.
      do i=1,nkeys
        lt = lkeys(i)
        if (index(ligne,ckeys(i)(1:lt)).ne.0) then
          if (ifound.eq.0) write(*,'(A)') 'Relevant information '
          write(*,'(A)') ligne(3:len_trim(ligne))
          error = .false.
          ifound = ifound+1
        endif
      enddo
    endif
  enddo
end subroutine
