!     $Id: modulePakoTrack.f90,v 1.1 2005/06/22 14:46:28 ungerech Exp $
!     
!     Family:   OBSERVING MODES
!     Siblings: modulePakoOnOff.f90
!     Siblings: modulePakoTrack.f90
!
!----------------------------------------------------------------------
!     PAKO module for TRACK
!
Module modulePakoTrack
  !
  Use modulePakoMessages
  Use modulePakoTypes
  Use modulePakoGlobalParameters
  Use modulePakoLimits
  Use modulePakoXML
  Use modulePakoUtilities
  Use modulePakoPlots
  Use modulePakoDisplayText
  Use modulePakoGlobalVariables
  Use modulePakoSubscanList
  Use modulePakoReceiver
  Use modulePakoBackend
  Use modulePakoSource
  Use modulePakoSwBeam
  Use modulePakoSwWobbler
  Use modulePakoSwTotalPower
  !
  Implicit None
  Save
  Private
!
  Public :: track
!!$      Public :: saveTrack
  Public :: startTrack
  Public :: displayTrack
  Public :: plotOMTrack
  !     
  ! *** Variables for Track ***
  Include 'inc/variables/variablesTrack.inc'
!!!   
Contains
!!!
!!!
  Subroutine Track(programName, line, command, error)
    !
    ! *** Arguments ***
    Include 'inc/variables/headerForCommandHandler2.inc'
    !
    ! *** standard working variables ***
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    !     TBD: the following shall be replaced by a SR reading from XML:
    Include 'inc/ranges/rangesTrack.inc'
    !
    !D      Write (6,*) " module Track ---> SR: Track "
    !D      Write (6,*) "                          "
    !
    ! *** initialize ***
    If (.Not.isInitialized) Then
       Include 'inc/variables/setDefaults.inc'
       isInitialized = .True.
    Endif
    !
    ! *** set In-values = previous Values ***
    If (.Not.ERROR) Then
       vars(iIn) = vars(iValue)
    End If
    !
    ! *** check N of Parameters: 0, n --> at  most n allowed  ***
    !     read Parameters, Options (to detect errors)            
    !     and check for validity and ranges                      
    Call checkNofParameters(command,                                 &
         &     0, 2,                                                       &
         &     nArguments,                                                 &
         &     errorNumber)
    ERROR = ERROR .Or. errorNumber
    !
    If (.Not. ERROR) Then
       !
       Include 'inc/parameters/parametersOffsetsSourceName.inc'
       Include 'inc/options/readOptionsTrack.inc'
       !
    End If
    !
    ! *** set defaults ***
    Include 'inc/options/optionDefaults.inc'
    !
    ! *** read Parameters, Options (again, after defaults!) ***
    !     and check for validity and ranges 
    If (.Not. ERROR) Then
       !
       Include 'inc/parameters/parametersOffsetsSourceName.inc'
       Include 'inc/options/readOptionsTrack.inc'
       !
    End If
    !
    ! *** check consistency and                           ***
    ! *** store into temporary (intermediate) variables   ***
    If (.Not.error) Then
       !
       errorInconsistent = .False.
       !
       If (.Not. errorInconsistent) Then
          vars(iTemp) = vars(iIn)
       End If
       !
    End If
    !
    ERROR = ERROR .Or. errorInconsistent
    !
    ! *** store from temporary into final variables ***
    If (.Not.ERROR) Then
       vars(iValue) = vars(iTemp)
    End If
    !
    ! *** display values ***
    !     (Note: this is done independantly of the Error status)
    Call displayTrack
    !
    ! *** set "selected" observing mode & plot ***
    If (.Not.error) Then
       GV%observingMode = om%track
       TrackCommand = line(1:lenc(line))
       Call analyzeTrack (errorA)
       Call listSegmentList (errorA)
       Call plotOMTrack (errorP)
    End If
    !
    Return
  End Subroutine Track
!!!
!!!
  Subroutine analyzeTrack (errorA)
    !
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    Integer                :: nScan 
    Character (len=lenCh)  :: aUnit, sUnit
    Integer                :: iSS           = 0     ! counts subcans/segment
    Integer                :: nSS           = 1
    !
    errorA    = .False.
    iSS       = 0
    nScan     = 1111
    aUnit     = GV%angleUnitC                        ! 
    sUnit     = GV%speedUnitC                        ! 
    !
    ! TBD: calibrate subscans 
    !
    segList(:) = segDefault
    !
    Call countSubscans(value=0)
    Call countSegments(value=0)
    !
    Do kk = 1, vars(iValue)%nSubscans, 1
       !
       Call countSubscans(ii)
       Call countSegments(jj)
       !
       segList(ii)%newSubscan =  .True.
       segList(ii)%scanNumber =  nScan
       segList(ii)%ssNumber   =  ii
       segList(ii)%segNumber  =  1
       segList(ii)%ssType     =  ss%track
       segList(ii)%segType    =  seg%track
       segList(ii)%angleUnit  =  aUnit
       segList(ii)%speedUnit  =  sUnit
       segList(ii)%flagOn     =  .True.
       segList(ii)%flagRef    =  .False.
       segList(ii)%pStart     =  vars(iValue)%offset
       segList(ii)%pEnd       =  segList(ii)%pStart
       segList(ii)%speedStart =  0.0
       segList(ii)%speedEnd   =  0.0
       segList(ii)%systemName =  vars(iValue)%systemName
       segList(ii)%altOption  =  'tSegment'
       segList(ii)%tSegment   =  vars(iValue)%tSubscan
       segList(ii)%tRecord    =  0.1
       !
    End Do
    !
    Call getCountSegments(nSegments)
    !
    Return 
    !
  End Subroutine analyzeTrack
!!!
!!!
  Subroutine displayTrack
    !
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    Character(len=24)  :: command
    !
    Include 'inc/display/commandDisplayTrack.inc'
    !
  End Subroutine displayTrack
!!!
!!!
  Subroutine plotOMTrack (errorP)
    !
    !**   Variables  for Plots   ***
    Include 'inc/variables/headerForPlotMethods.inc'
    !
    !**   standard working variables   ***
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    errorP = .False.
    !
    Call configurePlots
    !
    ! TBD: replace the following by general plot of segList
    !
    jj = 0                     ! jj counts OTF subscans / segments
    !
    Do ii = 1, nSegments, 1
       !
       If (segList(ii)%ssType .Eq.ss%ref.And.                          &
            &       segList(ii)%segType.Eq.seg%track) Then
          Call plotTrackP(segList(ii)%pStart,                          &
               &                    errorP,                                        &
               &                    number=segList(ii)%ssNumber,                   &
               &                    Type=segList(ii)%ssType)
       End If
       !
       If (segList(ii)%ssType .Eq.ss%on.And.                           &
            &       segList(ii)%segType.Eq.seg%track) Then
          Call plotTrackP(segList(ii)%pStart,                          &
               &                    errorP,                                        &
               &                    number=segList(ii)%ssNumber,                   &
               &                    Type=segList(ii)%ssType)
       End If
       !
    End Do
    !
    Call gr_exec(      'set character 0.6' )
    Call gr_exec(      'pen 0'             )
    !
    errorP =  errorP .Or. GR_ERROR()
    !
    If (errorP)                                                    &
         &        Call pakoMessage(priorityE,severityE,                         &
         &        'Track',' could not plot ')
    !
    Return
  End Subroutine plotOMTrack
!!!
!!$!!!
!!$  Subroutine saveTrack(programName,LINE,commandToSave,                 &
!!$       &        iUnit, ERROR)
!!$    !
!!$    !**   Variables   ***
!!$    Include 'inc/variables/headerForSaveMethods.inc'
!!$    !      
!!$    !D      Write (6,*) '      ---> SR: saveTrack '
!!$    !
!!$    contC = contNN
!!$    !
!!$    Include 'inc/commands/saveCommand.inc'
!!$    !
!!$    contC = contCC
!!$    !
!!$    Include 'inc/parameters/saveOffsets.inc'
!!$    !
!!$    !TBD:      Include 'inc/options/saveBalance.inc'
!!$    !TBD:      Include 'inc/options/saveCalibrate.inc'
!!$    Include 'inc/options/saveNsubscans.inc'
!!$    Include 'inc/options/saveReference.inc'
!!$    Include 'inc/options/saveSystem.inc'
!!$    !
!!$    contC = contCN
!!$    !
!!$    Include 'inc/options/saveTsubscan.inc'
!!$    !
!!$    !
!!$    Write (iUnit,*) "!"
!!$    !
!!$    Return
!!$  End Subroutine saveTrack
!!$!!!
!!!
  Subroutine startTrack(programName,LINE,commandToSave,                &
       &        iUnit, ERROR)
    !
    ! *** Variables ***
    Include 'inc/variables/headerForSaveMethods.inc'
    !
    ! to format message text
    Character(len=lenLine)  ::  messageText
    !
    Integer                 :: ii
    Character (len=lenCh)   :: valueC
    Character (len=lenLine) :: valueComment
    Logical                 :: errorXML
    !
    !D    Write (6,*) "  --> module modulePakoTrack: SR startTrack "
    !
    Call pakoXMLsetOutputUnit(iunit=iunit)
    Call pakoXMLsetIndent(iIndent=2)
    !
    Include 'inc/startXML/generalHead.inc'
    !
    Call writeXMLset(programName,LINE,commandToSave,                  &
         &        iUnit, ERROR)
    !
    Call pakoXMLwriteStartElement("RESOURCE","pakoScript",            &
         &                         comment="save from pako",                &
         &                         error=errorXML)
    Call pakoXMLwriteStartElement("DESCRIPTION",                      &
         &                         doCdata=.True.,                          &
         &                         error=errorXML)
    !
!!$    Call pakoSaveSet(programName,LINE,commandToSave,                  &
!!$         &        OMselected, iUnit, ERROR)                                 
!!$    Call saveReceiver(programName,LINE,commandToSave,                 &
!!$         &        OMselected, iUnit, ERROR)                                 
!!$    Call saveBackend(programName,LINE,commandToSave,                   &
!!$         &        OMselected, iUnit, ERROR)
!!$    Call saveSwitching(programName,LINE,commandToSave,                 &
!!$         &        OMselected, iUnit, ERROR)
!!$    Call saveSource(programName,LINE,commandToSave,                    &
!!$         &        OMselected, iUnit, ERROR)
!!$    Call saveOffsets(programName,LINE,commandToSave,                   &
!!$         &        OMselected, iUnit, ERROR)
!!$    Call saveTrack(programName,LINE,commandToSave,                      &
!!$         &        OMselected, iUnit, ERROR)                                 
    !                                                                       
    Call pakoXMLwriteEndElement("DESCRIPTION",                         &
         &                         doCdata=.True.,                           &
         &                         error=errorXML)
    Call pakoXMLwriteEndElement  ("RESOURCE","pakoScript",             &
         &                         space="after",                            &
         &                         error=errorXML)
    !
    Call writeXMLreceiver(programName,LINE,commandToSave,             &
         &        iUnit, ERROR)
    !
    Call writeXMLbackend(programName,LINE,commandToSave,               &
         &        iUnit, ERROR)
    !
    Include 'inc/startXML/switchingMode.inc'
    !
    Call writeXMLsource(programName,LINE,commandToSave,                &
         &        iUnit, ERROR)
    !
    Include 'inc/startXML/generalScanHead.inc'
    !
    Call writeXMLsubscanList(programName,LINE,commandToSave,         &
         &        iUnit, ERROR)
    !   
    Include 'inc/startXML/generalTail.inc'
    !
    Return
  End Subroutine startTrack
!!!
!!!
End Module modulePakoTrack
