!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetemplate_cuberegion_types
  use cubetools_structure
  use cubetemplate_firstlaststride_types
  use cubetemplate_sperange_types
  use cubetemplate_sparange_types
  use cubetemplate_spapos_types
  use cubetemplate_spasize_types
  use cubetemplate_messaging
  !
  public :: cuberegion_comm_t,cuberegion_user_t,cuberegion_prog_t
  private
  !
  type cuberegion_comm_t
     type(sperange_opt_t) :: range
     type(spapos_opt_t)   :: center
     type(spasize_opt_t)  :: size
   contains
     procedure, public :: register => cubetemplate_cuberegion_register
     procedure, public :: parse    => cubetemplate_cuberegion_parse
  end type cuberegion_comm_t
  !
  type cuberegion_user_t
     type(sperange_user_t) :: range
     type(spapos_user_t)   :: center
     type(spasize_user_t)  :: size
   contains
     procedure, public :: toprog => cubetemplate_cuberegion_user_toprog
!     procedure, public :: list   => cubetemplate_cuberegion_user_list ! *** JP could be implemented
  end type cuberegion_user_t
  !
  type cuberegion_prog_t
     type(sparange_prog_t) :: xrange
     type(sparange_prog_t) :: yrange
     type(sperange_prog_t) :: zrange
     type(firstlaststride_t) :: ix,iy,iz
   contains
     procedure, public :: list   => cubetemplate_cuberegion_prog_list
     procedure, public :: header => cubetemplate_cuberegion_prog_header
  end type cuberegion_prog_t
  !
contains
  !
  subroutine cubetemplate_cuberegion_register(comm,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(cuberegion_comm_t), intent(inout) :: comm
    logical,                  intent(inout) :: error
    !
    character(len=*), parameter :: rname='CUBEREGION>REGISTER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call comm%size%register('Spatial size of the cube region of interest',error)
    if (error) return
    call comm%center%register('CENTER','Spatial center of the cube region of interest',error)
    if (error) return
    call comm%range%register('RANGE','Spectral range of the cube region of interest',error)
    if (error) return
  end subroutine cubetemplate_cuberegion_register
  !
  subroutine cubetemplate_cuberegion_parse(comm,line,user,error)
    !----------------------------------------------------------------------
    ! /SIZE sx [sy]
    ! /CENTER xcen ycen
    ! /RANGE zfirst zlast
    !----------------------------------------------------------------------
    class(cuberegion_comm_t), intent(in)    :: comm
    character(len=*),         intent(in)    :: line
    type(cuberegion_user_t),  intent(out)   :: user
    logical,                  intent(inout) :: error
    !
    character(len=*), parameter :: rname='CUBEREGION>PARSE'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call comm%size%parse(line,user%size,error)
    if (error) return
    call comm%center%parse(line,user%center,error)
    if (error) return
    call comm%range%parse(line,user%range,error)
    if (error) return
    ! *** JP: Unclear whether the following test should be factorize here. Future will tell.
    if (user%center%do.and..not.user%size%do) then
       call cubetemplate_message(seve%e,rname,'A size must be specified when giving a new center')
       error = .true.
       return
    endif
  end subroutine cubetemplate_cuberegion_parse
  !
  subroutine cubetemplate_cuberegion_user_toprog(user,cube,prog,error)
    use cube_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(cuberegion_user_t), intent(in)    :: user
    type(cube_t),             intent(in)    :: cube
    type(cuberegion_prog_t),  intent(inout) :: prog
    logical,                  intent(inout) :: error
    !
    type(spapos_prog_t) :: center
    integer(kind=ndim_k), parameter :: ix=1,iy=2
    character(len=*), parameter :: rname='CUBEREGION>USER>TOPROG'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call user%center%toprog(cube,center,error)
    if (error) return
    call prog%xrange%fromuser(&
         cube%head%set%il,cube,center%rela(ix),&
         user%size%x,user%size%unit,cube%head%spa%l%inc,&
         cube%head%spa%l%kind,error)
    if (error) return
    call prog%yrange%fromuser(&
         cube%head%set%im,cube,center%rela(iy),&
         user%size%y,user%size%unit,cube%head%spa%m%inc,&
         cube%head%spa%m%kind,error)
    if (error) return
    call user%range%toprog(cube,prog%zrange,error)
    if (error) return
    !
    call prog%xrange%to_pixe_k(prog%ix%first,prog%ix%last,prog%ix%stride,error)
    if (error) return
    call prog%yrange%to_pixe_k(prog%iy%first,prog%iy%last,prog%iy%stride,error)
    if (error) return
    call prog%zrange%to_chan_k(prog%iz%first,prog%iz%last,prog%iz%stride,error)
    if (error) return
    !
    ! Ensure that the range will be inside the axis range
    call prog%xrange%intersect_axis(error)
    if (error) return
    call prog%yrange%intersect_axis(error)
    if (error) return
    call prog%zrange%intersect_axis(error)
    if (error) return
  end subroutine cubetemplate_cuberegion_user_toprog
  !
  subroutine cubetemplate_cuberegion_prog_header(prog,cube,error)
    use cube_types
    use cubetools_axis_types
    use cubetools_header_methods
    !-------------------------------------------------------------------
    ! Update cube header according to the defined region
    !-------------------------------------------------------------------
    class(cuberegion_prog_t), intent(inout) :: prog
    class(cube_t),            intent(inout) :: cube
    logical,                  intent(inout) :: error
    !
    type(axis_t) :: axis
    character(len=*), parameter :: rname='CUBEREGION>PROG>HEADER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubetools_header_get_axis_head_l(cube%head,axis,error)
    if (error) return
    call prog%ix%update_axis_header(axis,error)
    if (error) return
    call cubetools_header_update_axset_l(axis,cube%head,error)
    if (error) return
    !
    call cubetools_header_get_axis_head_m(cube%head,axis,error)
    if (error) return
    call prog%iy%update_axis_header(axis,error)
    if (error) return
    call cubetools_header_update_axset_m(axis,cube%head,error)
    if (error) return
    !
    call cubetools_header_get_axis_head_c(cube%head,axis,error)
    if (error) return
    call prog%iz%intersect_axis(axis,error)
    if (error) return
    call cubetools_header_update_axset_c(axis,cube%head,error)
    if (error) return
  end subroutine cubetemplate_cuberegion_prog_header
  !
  subroutine cubetemplate_cuberegion_prog_list(prog,error)
    !-------------------------------------------------------------------
    ! List cube region in a user friendly way
    !-------------------------------------------------------------------
    class(cuberegion_prog_t), intent(in)    :: prog
    logical,                  intent(inout) :: error
    !
    character(len=*), parameter :: rname='CUBEREGION>PROG>LIST'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubetemplate_message(seve%r,rname,blankstr)
    call prog%xrange%list(error)
    if (error) return
    call prog%yrange%list(error)
    if (error) return
    call prog%zrange%list(error)
    if (error) return
  end subroutine cubetemplate_cuberegion_prog_list
end module cubetemplate_cuberegion_types
! 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
