!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubemain_ancillary_header_types
  use cubemain_messaging
  use cubemain_ancillary_cube_types
  !
  public :: ancillary_header_comm_t,ancillary_header_user_t,ancillary_header_prog_t
  private
  !
  type, extends(ancillary_cube_comm_t) :: ancillary_header_comm_t
   contains
     procedure, public :: short_register => cubemain_ancillary_header_comm_short_register
  end type ancillary_header_comm_t
  !
  type, extends(ancillary_cube_user_t) :: ancillary_header_user_t
     ! Empty for the moment
  end type ancillary_header_user_t
  !
  ! *** JP to be generic we would need to add the possibility of a spectral header...
  type, extends(ancillary_cube_prog_t) :: ancillary_header_prog_t
     logical :: isspatial = .false. ! Spatial or cube?
   contains
     procedure, public :: check_consistency => cubemain_ancillary_header_prog_check_consistency
     procedure, public :: must_be_spatial   => cubemain_ancillary_header_must_be_spatial
     procedure, public :: must_be_3d        => cubemain_ancillary_header_must_be_3d
  end type ancillary_header_prog_t
  !
contains
  !
  subroutine cubemain_ancillary_header_comm_short_register(key,abstract,error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    ! Register an optional "/HEADER [headerid]" key
    !----------------------------------------------------------------------
    class(ancillary_header_comm_t), intent(inout) :: key
    character(len=*),            intent(in)    :: abstract
    logical,                     intent(inout) :: error
    !
    character(len=*), parameter :: rname='ANCILLARY>HEADER>KEY>SHORT>REGISTER'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call key%register('HEADER','/HEADER [headerid]',&
         abstract,strg_id,&
         'Header',&
         '*** JP: ????',&
         [flag_header],&
         code_arg_optional, &
         error)
    if (error) return
  end subroutine cubemain_ancillary_header_comm_short_register
  !
  !------------------------------------------------------------------------
  !
  subroutine cubemain_ancillary_header_prog_check_consistency(header,refcube,error)
    use cubetools_header_methods
    use cube_types
    use cubeadm_consistency
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(ancillary_header_prog_t), intent(inout) :: header
    type(cube_t),                 intent(in)    :: refcube
    logical,                      intent(inout) :: error
    !
    integer(kind=chan_k) :: nc
    type(consistency_t) :: cons
    character(len=*), parameter :: rname='ANCILLARY>HEADER>PROG>CHECK>CONSISTENCY'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    if (.not.header%do) return
    !
    call cubetools_header_get_nchan(header%cube%head,nc,error)
    if (error) return
    header%isspatial = nc.eq.1
    if (header%isspatial) then
       call cons%spatial('Input cube',refcube,'Header',header%cube,error)
       if (error) return
    else
       call cons%grid('Input cube',refcube,'Header',header%cube,error)
       if (error) return
    endif    
  end subroutine cubemain_ancillary_header_prog_check_consistency
  !
  subroutine cubemain_ancillary_header_must_be_spatial(header,error)
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(ancillary_header_prog_t), intent(inout) :: header
    logical,                      intent(inout) :: error
    !
    character(len=*), parameter :: rname='ANCILLARY>HEADER>MUST>BE>SPATIAL'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    if (.not.header%isspatial) then
       call cubemain_message(seve%e,rname,'A spatial header is required')
    endif
  end subroutine cubemain_ancillary_header_must_be_spatial
  !
  subroutine cubemain_ancillary_header_must_be_3d(header,error)
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(ancillary_header_prog_t), intent(inout) :: header
    logical,                      intent(inout) :: error
    !
    character(len=*), parameter :: rname='ANCILLARY>HEADER>MUST>BE>3D'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    if (header%isspatial) then
       call cubemain_message(seve%e,rname,'A 3D header is required')
    endif
  end subroutine cubemain_ancillary_header_must_be_3d
end module cubemain_ancillary_header_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
